/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.config;

import com.google.gson.annotations.Expose;
import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.background.BackgroundBuilder;

public class Config {
    private static final String CONFIG_FILE_NAME = "nekoui.toml";
    private static Config instance;
    @Expose
    public String background = "default";
    @Expose
    public boolean agreedToTerms = false;

    private Config() {
        this.loadConfig();
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
            instance.load();
        }
        return instance;
    }

    private void loadConfig() {
        File configFile;
        File configDir = new File(Constants.configDir);
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if (!(configFile = new File(configDir, CONFIG_FILE_NAME)).exists()) {
            this.createDefaultConfig(configFile);
        }
        try {
            Toml toml = new Toml().read(configFile);
            this.background = toml.getString("background", this.background);
            this.agreedToTerms = toml.getBoolean("agreedToTerms", Boolean.valueOf(false));
        }
        catch (Throwable e) {
            Constants.LOG.printStackTrace(e, true, "NekoUI Error:", "Verbose Info", System.out);
        }
    }

    private void createDefaultConfig(File configFile) {
        try {
            this.saveToFile(configFile);
        }
        catch (Throwable e) {
            Constants.LOG.printStackTrace(e, true, "NekoUI Error:", "Verbose Info", System.out);
        }
    }

    public void load() {
        this.loadConfig();
        this.save();
    }

    public void save() {
        File configDir = new File(Constants.configDir);
        File configFile = new File(configDir, CONFIG_FILE_NAME);
        try {
            this.saveToFile(configFile);
        }
        catch (Throwable e) {
            Constants.LOG.printStackTrace(e, true, "NekoUI Error:", "Verbose Info", System.out);
        }
    }

    private void saveToFile(File file) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("background", this.background);
        data.put("agreedToTerms", this.agreedToTerms);
        TomlWriter writer = new TomlWriter();
        writer.write(data, file);
    }

    public static boolean hasAgreed() {
        return Config.getInstance().agreedToTerms;
    }

    public static void setAgreed() {
        Config.getInstance().agreedToTerms = true;
        Config.getInstance().save();
    }

    public static void setBackground(String bg) {
        Config.getInstance().background = bg;
        Config.getInstance().save();
        BackgroundBuilder.selectBackground(bg);
    }
}

