/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.forge;

import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.NekoUI;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.config.screen.ConfigScreen;
import org.nokarin.nekoui.core.ui.TitleScreen;
import org.nokarin.nekoui.forge.mods.ModScreenSuppliers;
import org.nokarin.nekoui.utils.MappingUtils;
import org.nokarin.nekoui.utils.OSUtils;

@Mod(value="nekoui")
public class NekoUIForge {
    public NekoUIForge(FMLJavaModLoadingContext context) {
        if (OSUtils.JAVA_SPEC < 1.8f) {
            throw new UnsupportedOperationException(String.format("NekoUI > Incompatible JVM!!! %1$s requires Java 8 or above to work properly!", "nekoui"));
        }
        if (FMLEnvironment.dist.isClient()) {
            try {
                context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> new ConfigScreen((Screen)parent)));
                Constants.LOG.info("NekoUI > %1$s-%2$s, Successfully resgiter GUI Config", "v1.0.1", "release");
            }
            catch (Throwable ex) {
                Constants.LOG.error("NekoUI > %1$s-%2$s, Failed while register GUI Config", "v1.0.1", "release", ex);
            }
            MappingUtils.setFilePath("/mappings-forge.srg");
            Constants.MOD_COUNT_SUPPLIER = () -> ModList.get().getMods().size();
            Constants.MOD_SCREEN_SUPPLIER = new ModScreenSuppliers();
            Constants.GAME_LOADER = "forge";
            new NekoUI(this::setupIntegrations);
            MinecraftForge.EVENT_BUS.addListener(this::onScreenOpen);
        } else {
            Constants.LOG.info("NekoUI > %1$s-%2$s, Disabling, as it is client side only.", "v1.0.1", "release");
        }
    }

    public void setupIntegrations() {
    }

    @SubscribeEvent
    public void onScreenOpen(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ScreenEvent.Opening event) {
        if (event.getScreen() instanceof net.minecraft.client.gui.screens.TitleScreen) {
            event.setNewScreen((Screen)new TitleScreen());
        }
    }
}

