/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.background.BackgroundBuilder;
import org.nokarin.nekoui.core.config.ConfigData;

public class Config {
    private static final String CONFIG_FILE_NAME = "nekoui.json";
    private static Config instance;
    private static final Gson gson;
    private ConfigData data = new ConfigData();

    private Config() {
        this.loadConfig();
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
            instance.load();
        }
        return instance;
    }

    private void loadConfig() {
        File configFile;
        File configDir = new File(Constants.configDir);
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if (!(configFile = new File(configDir, CONFIG_FILE_NAME)).exists()) {
            this.createDefaultConfig(configFile);
        }
        try (FileReader reader = new FileReader(configFile);){
            ConfigData loaded = (ConfigData)gson.fromJson((Reader)reader, ConfigData.class);
            if (loaded != null) {
                this.data = loaded;
            }
        }
        catch (Throwable e) {
            Constants.LOG.printStackTrace(e, true, "NekoUI Error:", "Config", System.out);
        }
    }

    private void createDefaultConfig(File configFile) {
        try {
            this.saveToFile(configFile);
        }
        catch (Throwable e) {
            Constants.LOG.printStackTrace(e, true, "NekoUI Error:", "Config", System.out);
        }
    }

    public void load() {
        this.loadConfig();
        this.save();
    }

    public void save() {
        File configDir = new File(Constants.configDir);
        File configFile = new File(configDir, CONFIG_FILE_NAME);
        try {
            this.saveToFile(configFile);
        }
        catch (Throwable e) {
            Constants.LOG.printStackTrace(e, true, "NekoUI Error:", "Config", System.out);
        }
    }

    private void saveToFile(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson((Object)this.data, (Appendable)writer);
        }
    }

    public int getBackgroundFrame() {
        return this.data.backgroundFrame;
    }

    public void setBackgroundFrame(int frame) {
        this.data.backgroundFrame = frame;
        this.save();
    }

    public String getBackground() {
        return this.data.background;
    }

    public void setBackground(String bg) {
        this.data.background = bg;
        this.save();
        BackgroundBuilder.selectBackground(bg);
    }

    public boolean hasAgreed() {
        return this.data.agreedToTerms;
    }

    public void setAgreed() {
        this.data.agreedToTerms = true;
        this.save();
    }

    public boolean isLowQualityMode() {
        return this.data.lowQualityMode;
    }

    public void setLowQualityMode(boolean value) {
        this.data.lowQualityMode = value;
        this.save();
    }

    public boolean isAutoDetectPerformance() {
        return this.data.autoDetectPerformance;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

