/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.utils;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageUtils {
    public static NativeImage loadNativeImage(InputStream stream, String formatHint) throws Exception {
        try (ImageInputStream imageStream = ImageIO.createImageInputStream(stream);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(imageStream);
            if (!readers.hasNext()) {
                throw new RuntimeException("No ImageReader found for format: " + formatHint);
            }
            ImageReader reader = readers.next();
            reader.setInput(imageStream, true);
            BufferedImage bufferedImage = reader.read(0);
            if (bufferedImage == null) {
                throw new RuntimeException("Image could not be read");
            }
            BufferedImage converted = ImageUtils.convertToARGB(bufferedImage);
            converted.getGraphics().drawImage(bufferedImage, 0, 0, null);
            NativeImage nativeImage = new NativeImage(converted.getWidth(), converted.getHeight(), true);
            for (int x = 0; x < converted.getWidth(); ++x) {
                for (int y = 0; y < converted.getHeight(); ++y) {
                    int argb = converted.getRGB(x, y);
                    Color color = new Color(argb, true);
                    int abgr = (color.getAlpha() & 0xFF) << 24 | (color.getBlue() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getRed() & 0xFF;
                    nativeImage.setPixelRGBA(x, y, abgr);
                }
            }
            NativeImage nativeImage2 = nativeImage;
            return nativeImage2;
        }
    }

    public static NativeImage resizeNativeImage(NativeImage original, int newWidth, int newHeight) {
        NativeImage resized = new NativeImage(NativeImage.Format.RGBA, newWidth, newHeight, false);
        for (int y = 0; y < newHeight; ++y) {
            for (int x = 0; x < newWidth; ++x) {
                int srcX = x * original.getWidth() / newWidth;
                int srcY = y * original.getHeight() / newHeight;
                int color = original.getPixelRGBA(srcX, srcY);
                resized.setPixelRGBA(x, y, color);
            }
        }
        original.close();
        return resized;
    }

    private static BufferedImage convertToARGB(BufferedImage image) {
        if (image.getType() == 2) {
            return image;
        }
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = newImage.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return newImage;
    }
}

