/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.background.cache;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.background.cache.BackgroundTextureKey;
import org.nokarin.nekoui.core.config.Config;
import org.nokarin.nekoui.utils.ImageUtils;

public class BackgroundCache {
    private static final Map<BackgroundTextureKey, DynamicTexture> textureCache = new HashMap<BackgroundTextureKey, DynamicTexture>();
    private static final Set<String> SUPPORTED_EXTENSIONS = Set.of("png", "jpg", "jpeg");
    private static final ExecutorService preloadExecutor = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("BackgroundPreloader");
        return t;
    });

    public static ResourceLocation registerTexture(ResourceLocation originalLocation) {
        ResourceLocation resourceLocation;
        block13: {
            BackgroundTextureKey key = new BackgroundTextureKey(originalLocation, Config.getInstance().isLowQualityMode());
            if (!BackgroundCache.isSupportedFormat(originalLocation.getPath())) {
                Constants.LOG.error("Unsupported image format: " + String.valueOf(originalLocation), new Object[0]);
                return null;
            }
            if (textureCache.containsKey(key)) {
                return BackgroundCache.buildRegisteredId(key);
            }
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> BackgroundCache.registerTexture(originalLocation));
                return BackgroundCache.buildRegisteredId(key);
            }
            Optional optional = Minecraft.getInstance().getResourceManager().getResource(originalLocation);
            if (optional.isEmpty()) {
                return null;
            }
            InputStream stream = ((Resource)optional.get()).open();
            try {
                NativeImage image = ImageUtils.loadNativeImage(stream, originalLocation.getPath());
                if (Config.getInstance().isLowQualityMode()) {
                    image = ImageUtils.resizeNativeImage(image, image.getWidth() / 2, image.getHeight() / 2);
                }
                DynamicTexture texture = new DynamicTexture(image);
                Minecraft.getInstance().getTextureManager().register(BackgroundCache.buildRegisteredId(key), (AbstractTexture)texture);
                textureCache.put(key, texture);
                resourceLocation = BackgroundCache.buildRegisteredId(key);
                if (stream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Constants.LOG.error("Failed to load texture: " + String.valueOf(originalLocation), new Object[0]);
                    Constants.LOG.printStackTrace((Throwable)e, "Background: ", "Verbose Info", new Appendable[0]);
                    return null;
                }
            }
            stream.close();
        }
        return resourceLocation;
    }

    public static void preload(ResourceLocation[] locations) {
        for (ResourceLocation loc : locations) {
            preloadExecutor.submit(() -> BackgroundCache.registerTexture(loc));
        }
    }

    private static boolean isSupportedFormat(String path) {
        String lower = path.toLowerCase();
        return SUPPORTED_EXTENSIONS.stream().anyMatch(lower::endsWith);
    }

    private static ResourceLocation buildRegisteredId(BackgroundTextureKey key) {
        String path = key.location().getPath().replace('/', '_');
        String suffix = key.lowQuality() ? "_low" : "_full";
        return ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)("extension_bg/" + key.location().getNamespace() + "_" + path + suffix));
    }

    public static void clear() {
        for (DynamicTexture tex : textureCache.values()) {
            tex.close();
        }
        textureCache.clear();
    }
}

