/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ImageButton
extends Button {
    private final ResourceLocation texture;
    private final int iconWidth;
    private final int iconHeight;
    private final List<Component> tooltip;
    private float externalOpacity = 1.0f;

    public ImageButton(int x, int y, int width, int height, ResourceLocation texture, Button.OnPress onClick, List<Component> tooltip) {
        super(x, y, width, height, (Component)Component.empty(), onClick, DEFAULT_NARRATION);
        this.texture = texture;
        this.iconWidth = width;
        this.iconHeight = height;
        this.tooltip = tooltip;
    }

    public ImageButton(int x, int y, int width, int height, ResourceLocation texture, Button.OnPress onClick, Component tooltip) {
        this(x, y, width, height, texture, onClick, List.of(tooltip));
    }

    protected void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.visible) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.externalOpacity);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            graphics.blit(this.texture, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.iconWidth, this.iconHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isHoveredOrFocused() && this.tooltip != null && !this.tooltip.isEmpty()) {
                graphics.renderComponentTooltip(Minecraft.getInstance().font, this.tooltip, mouseX, mouseY);
            }
        }
    }

    public void setExternalOpacity(float opacity) {
        this.externalOpacity = opacity;
    }
}

