/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.gui.layout;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import org.nokarin.nekoui.core.gui.layout.UIAnchor;

public class ColumnLayout {
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    private final int spacing;
    private final UIAnchor anchor;

    public ColumnLayout(UIAnchor anchor, int spacing) {
        this.anchor = anchor;
        this.spacing = spacing;
    }

    public void add(AbstractWidget widget) {
        this.widgets.add(widget);
    }

    public List<AbstractWidget> build(int screenWidth, int screenHeight) {
        int totalHeight = this.widgets.stream().mapToInt(AbstractWidget::getHeight).sum() + this.spacing * (this.widgets.size() - 1);
        int baseX = Math.max(8, this.anchor.resolveX(screenWidth, this.widgets.getFirst().getWidth()));
        int y = this.anchor.resolveY(screenHeight, totalHeight);
        for (AbstractWidget widget : this.widgets) {
            widget.setX(baseX);
            widget.setY(y);
            y += widget.getHeight() + this.spacing;
        }
        return this.widgets;
    }
}

