/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.gui.button;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.core.Constants;

public class TextIconButton
extends Button {
    private final ResourceLocation icon;
    private final TextAlign alignment;
    private final float fontScale;
    private final Component message;
    private final int iconSize;

    public TextIconButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, TextAlign align, ResourceLocation icon, float fontScale, int iconSize) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
        this.message = message;
        this.alignment = align;
        this.icon = icon;
        this.fontScale = fontScale;
        this.iconSize = iconSize;
    }

    public TextIconButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, TextAlign align, ResourceLocation icon) {
        this(x, y, width, height, message, onPress, align, icon, 1.0f, 12);
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int textColor;
        Font font = Minecraft.getInstance().font;
        int n = textColor = this.active ? 0xFFFFFF : 0xA0A0A0;
        if (this.isHoveredOrFocused()) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, Integer.MIN_VALUE);
        }
        int iconOffset = 0;
        if (this.icon != null) {
            iconOffset = this.iconSize + 8;
            int iconY = this.getY() + (this.getHeight() - this.iconSize) / 2;
            graphics.blit(RenderType::guiTextured, this.icon, this.getX() + 4, iconY, 0.0f, 0.0f, this.iconSize, this.iconSize, this.iconSize, this.iconSize);
        }
        String rawText = this.getMessage().getString();
        int maxTextWidth = (int)((float)(this.getWidth() - 8 - iconOffset) / this.fontScale);
        Object trimmedText = font.plainSubstrByWidth(rawText, maxTextWidth);
        int textWidth = (int)((float)font.width((String)trimmedText) * this.fontScale);
        int textHeight = (int)(8.0f * this.fontScale);
        int textX = switch (this.alignment.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.getX() + 4 + iconOffset;
            case 2 -> this.getX() + this.getWidth() - textWidth - 4;
            case 1 -> this.getX() + (this.getWidth() - textWidth) / 2;
        };
        int textY = this.getY() + (this.getHeight() - textHeight) / 2;
        if (!((String)trimmedText).equals(rawText) && ((String)trimmedText).length() > 3) {
            trimmedText = ((String)trimmedText).substring(0, ((String)trimmedText).length() - 3) + "...";
        }
        if (this.message.getString().equalsIgnoreCase("MODS")) {
            int badgeX = this.getX() + 55;
            int badgeY = this.getY() + 4;
            graphics.drawString(font, String.valueOf(Constants.getModCount()), badgeX + 8, badgeY + 2, 0xFFFFFF);
        }
        graphics.pose().pushPose();
        graphics.pose().translate((float)textX, (float)textY, 0.0f);
        graphics.pose().scale(this.fontScale, this.fontScale, 1.0f);
        graphics.drawString(font, (String)trimmedText, 0, 0, textColor);
        graphics.pose().popPose();
    }

    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;

    }
}

