/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.background;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.background.Background;
import org.nokarin.nekoui.core.background.cache.BackgroundCache;
import org.nokarin.nekoui.core.config.Config;
import org.nokarin.nekoui.core.utils.PerformanceDetector;
import org.nokarin.nekoui.utils.GameUtils;

public class BackgroundBuilder
extends TitleScreen {
    public static String selectedBackground = Config.getInstance().getBackground();
    private static Timer animationTimer;
    private static int currentFrame;
    private static final long FRAME_DURATION;
    private static Background cachedBackground;

    public static void selectBackground(@NotNull String background) {
        selectedBackground = background;
        currentFrame = 0;
        cachedBackground = BackgroundBuilder.loadBackground(background);
    }

    private static Background loadBackground(String name) {
        ResourceLocation[] frames = Background.loadAnimatedFramePaths(name);
        if (frames != null && frames.length > 0) {
            return new Background.AnimatedBackground(name, frames);
        }
        return new Background.DefaultBackground();
    }

    public static Background getBackground() {
        return cachedBackground;
    }

    private static void startFrameTimer() {
        if (animationTimer != null) {
            return;
        }
        animationTimer = new Timer();
        animationTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                BackgroundBuilder.updateFrame();
            }
        }, 0L, FRAME_DURATION);
    }

    private static void stopFrameTimer() {
        if (animationTimer != null) {
            animationTimer.cancel();
            animationTimer = null;
        }
    }

    private static void updateFrame() {
        if (!GameUtils.getMinecraft().isWindowActive()) {
            return;
        }
        if (cachedBackground != null && cachedBackground.isAnimated()) {
            currentFrame = (currentFrame + 1) % cachedBackground.getFramePaths().length;
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (cachedBackground == null || cachedBackground.getFramePaths().length == 0) {
            BackgroundBuilder.selectBackground(selectedBackground);
        }
        BackgroundBuilder.renderBackground(graphics, this.width, this.height);
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public static void renderBackground(@NotNull GuiGraphics graphics, int width, int height) {
        if (cachedBackground == null) {
            return;
        }
        ResourceLocation[] frames = cachedBackground.getFramePaths();
        if (frames.length == 0) {
            return;
        }
        int frameIndex = Config.getInstance().isLowQualityMode() ? 0 : currentFrame;
        ResourceLocation registeredId = BackgroundCache.registerTexture(frames[frameIndex]);
        if (registeredId == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)registeredId);
        graphics.blit(RenderType::guiTextured, registeredId, 0, 0, 0.0f, 0.0f, width, height, width, height);
    }

    public void removed() {
        super.removed();
        BackgroundBuilder.stopFrameTimer();
        BackgroundCache.clear();
    }

    static {
        currentFrame = 0;
        FRAME_DURATION = 1000 / Config.getInstance().getBackgroundFrame();
        if (Config.getInstance().isAutoDetectPerformance() && PerformanceDetector.isLowSpecSystem()) {
            Config.getInstance().setLowQualityMode(true);
            Constants.LOG.info("Low-end system detected. Automatically enabled lowQualityMode (static background only).", new Object[0]);
        }
        BackgroundBuilder.selectBackground(selectedBackground);
        if (!Config.getInstance().isLowQualityMode()) {
            BackgroundBuilder.startFrameTimer();
        }
    }
}

