/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.config.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.background.Background;
import org.nokarin.nekoui.core.background.cache.BackgroundCache;
import org.nokarin.nekoui.core.config.Config;
import org.nokarin.nekoui.core.gui.button.ImageButton;
import org.nokarin.nekoui.core.gui.button.TextButton;
import org.nokarin.nekoui.core.gui.slider.ConfigSlider;
import org.nokarin.nekoui.core.gui.widget.AnimatedWidget;

public class ConfigScreen
extends Screen {
    private static final Minecraft client = Minecraft.getInstance();
    private final Screen parent;
    private int selectedBackgroundIndex = 0;
    private List<String> animatedBackgrounds;
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final int PADDING = 10;
    private static final float PREVIEW_WIDTH_RATIO = 0.4f;
    private static final float PREVIEW_HEIGHT_RATIO = 0.4f;
    private static final float CAROUSEL_RADIUS = 400.0f;
    private float currentRotation = 0.0f;
    private float targetRotation = 0.0f;
    private final long startTime;
    private EditBox frameField;
    ResourceLocation BACK_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/gui/back_icon.png");
    ResourceLocation NEXT_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/gui/next_icon.png");
    ResourceLocation PREV_ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/gui/prev_icon.png");

    public ConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"Background Settings"));
        this.parent = parent;
        this.startTime = System.currentTimeMillis();
    }

    protected void init() {
        this.animatedBackgrounds = this.getAvailableAnimatedBackgrounds();
        if (!this.animatedBackgrounds.contains("default")) {
            this.animatedBackgrounds.addFirst("default");
        }
        int backSize = Math.min(16, this.height / 20);
        this.addRenderableWidget((GuiEventListener)new AnimatedWidget((AbstractWidget)new ImageButton(10, 10, backSize, backSize, this.BACK_ICON_TEXTURE, button -> client.setScreen(this.parent), (Component)Component.translatable((String)"nekoui.config.back")), AnimatedWidget.Direction.LEFT));
        int previewWidth = (int)((float)this.width * 0.4f);
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int navButtonSize = Math.min(16, this.width / 15);
        this.addRenderableWidget((GuiEventListener)new AnimatedWidget((AbstractWidget)new ImageButton(centerX - previewWidth / 2 - navButtonSize - 20, centerY - navButtonSize / 4, navButtonSize, navButtonSize, this.PREV_ICON_TEXTURE, button -> this.switchBackground(-1), (Component)Component.translatable((String)"nekoui.config.prev")), AnimatedWidget.Direction.LEFT));
        this.addRenderableWidget((GuiEventListener)new AnimatedWidget((AbstractWidget)new ImageButton(centerX + previewWidth / 2 + 20, centerY - navButtonSize / 4, navButtonSize, navButtonSize, this.NEXT_ICON_TEXTURE, button -> this.switchBackground(1), (Component)Component.translatable((String)"nekoui.config.next")), AnimatedWidget.Direction.RIGHT));
        int qualityButtonWidth = Math.min(200, this.width - 40);
        this.addRenderableWidget((GuiEventListener)new TextButton(this.width / 2 - qualityButtonWidth / 2, this.height - 20 - 80, qualityButtonWidth, 20, (Component)Component.translatable((String)"nekoui.config.low.quality.mode").append(" ").append((Component)(Config.getInstance().isLowQualityMode() ? Component.translatable((String)"nekoui.config.low.quality.mode.enable") : Component.translatable((String)"nekoui.config.low.quality.mode.disable"))), button -> {
            Config.getInstance().setLowQualityMode(!Config.getInstance().isLowQualityMode());
            button.setMessage((Component)Component.translatable((String)"nekoui.config.low.quality.mode").append(" ").append((Component)(Config.getInstance().isLowQualityMode() ? Component.translatable((String)"nekoui.config.low.quality.mode.enable") : Component.translatable((String)"nekoui.config.low.quality.mode.disable"))));
            Config.getInstance().save();
        }, TextButton.TextAlign.CENTER));
        this.addRenderableWidget((GuiEventListener)new ConfigSlider(this.width / 2 - 100, this.height - 40 - 30, 200, 20, 1, 60, Config.getInstance().getBackgroundFrame(), val -> {
            Config.getInstance().setBackgroundFrame((int)val);
            Config.getInstance().save();
        }));
        int buttonWidth = Math.min(200, this.width - 40);
        this.addRenderableWidget((GuiEventListener)new TextButton(this.width / 2 - buttonWidth / 2, this.height - 20 - 20, buttonWidth, 20, (Component)Component.translatable((String)"nekoui.config.background.apply"), button -> {
            String selected = this.animatedBackgrounds.get(this.selectedBackgroundIndex);
            Config.getInstance().setBackground(selected);
            Config.getInstance().save();
            client.setScreen(this.parent);
        }, TextButton.TextAlign.CENTER));
        String currentBg = Config.getInstance().getBackground();
        this.selectedBackgroundIndex = Math.max(0, this.animatedBackgrounds.indexOf(currentBg));
        this.currentRotation = this.targetRotation = (float)this.selectedBackgroundIndex * (360.0f / (float)Math.max(1, this.animatedBackgrounds.size()));
    }

    private void switchBackground(int delta) {
        if (this.animatedBackgrounds.isEmpty()) {
            return;
        }
        this.selectedBackgroundIndex = (this.selectedBackgroundIndex + delta + this.animatedBackgrounds.size()) % this.animatedBackgrounds.size();
        this.targetRotation = (float)this.selectedBackgroundIndex * (360.0f / (float)this.animatedBackgrounds.size());
    }

    private List<String> getAvailableAnimatedBackgrounds() {
        String[] backgrounds;
        ArrayList<String> validBackgrounds = new ArrayList<String>();
        for (String name : backgrounds = Background.getAvailableBackgrounds()) {
            ResourceLocation[] frames = Background.loadAnimatedFramePaths(name);
            if (frames == null || frames.length <= 0) continue;
            validBackgrounds.add(name);
        }
        return validBackgrounds;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        if (!this.animatedBackgrounds.isEmpty()) {
            float angleStep = 360.0f / (float)this.animatedBackgrounds.size();
            for (int i = 0; i < this.animatedBackgrounds.size(); ++i) {
                float angle = (float)Math.toRadians((float)i * angleStep - this.currentRotation);
                float x = (float)centerX + (float)Math.sin(angle) * 400.0f;
                float z = (float)Math.cos(angle) * 400.0f;
                float scale = 0.5f + 0.5f * (z + 400.0f) / 800.0f;
                if (!(z > 0.0f)) continue;
                int previewWidth = (int)((float)this.width * 0.4f * scale);
                int previewHeight = (int)((float)this.height * 0.4f * scale);
                int previewX = (int)x - previewWidth / 2;
                int previewY = centerY - previewHeight / 2;
                if (!(mouseX >= (double)previewX) || !(mouseX <= (double)(previewX + previewWidth)) || !(mouseY >= (double)previewY) || !(mouseY <= (double)(previewY + previewHeight))) continue;
                this.selectedBackgroundIndex = i;
                this.targetRotation = (float)i * angleStep;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void tick() {
        super.tick();
        float rotationDiff = this.targetRotation - this.currentRotation;
        if (Math.abs(rotationDiff) > 0.01f) {
            this.currentRotation += rotationDiff * 0.15f;
        }
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fillGradient(0, 0, this.width, this.height, -587202560, -301989888);
        if (this.animatedBackgrounds.isEmpty()) {
            return;
        }
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        float angleStep = 360.0f / (float)this.animatedBackgrounds.size();
        ArrayList<PreviewItem> previewItems = new ArrayList<PreviewItem>();
        for (int i = 0; i < this.animatedBackgrounds.size(); ++i) {
            float angle = (float)Math.toRadians((float)i * angleStep - this.currentRotation);
            float x = (float)centerX + (float)Math.sin(angle) * 400.0f;
            float z = (float)Math.cos(angle) * 400.0f;
            previewItems.add(new PreviewItem(i, x, z));
        }
        previewItems.sort((a, b) -> Float.compare(a.z, b.z));
        for (PreviewItem item : previewItems) {
            String currentBg;
            ResourceLocation[] frames;
            float scale = 0.5f + 0.5f * (item.z + 400.0f) / 800.0f;
            float previewScaleFactor = 0.6f;
            int previewWidth = (int)((float)this.width * 0.4f * scale * previewScaleFactor);
            int previewHeight = (int)((float)this.height * 0.4f * scale * previewScaleFactor);
            int previewX = (int)item.x - previewWidth / 2;
            int previewY = centerY - previewHeight / 2 - 60;
            if (!(item.z > 0.0f) || (frames = Background.loadAnimatedFramePaths(currentBg = this.animatedBackgrounds.get(item.index))) == null || frames.length <= 0) continue;
            float alpha = (item.z + 400.0f) / 800.0f;
            if (item.index == this.selectedBackgroundIndex) {
                float time = (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
                int borderColor = 0xFF000000 | (int)(Math.sin(time * 2.0f) * 32.0 + 223.0) << 16 | (int)(Math.sin(time * 2.0f + 2.0f) * 32.0 + 223.0) << 8 | (int)(Math.sin(time * 2.0f + 4.0f) * 32.0 + 223.0);
                graphics.fill(previewX - 2, previewY - 2, previewX + previewWidth + 2, previewY + previewHeight + 2, borderColor);
            } else {
                graphics.fill(previewX - 2, previewY - 2, previewX + previewWidth + 2, previewY + previewHeight + 2, -14540254);
            }
            graphics.fill(previewX, previewY, previewX + previewWidth, previewY + previewHeight, -13882324);
            ResourceLocation registeredId = BackgroundCache.registerTexture(frames[0]);
            if (registeredId == null) {
                return;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)registeredId);
            graphics.blit(RenderType::guiTextured, registeredId, previewX, previewY, 0.0f, 0.0f, previewWidth, previewHeight, previewWidth, previewHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (item.index != this.selectedBackgroundIndex) continue;
            int nameWidth = this.font.width(currentBg.toUpperCase());
            graphics.drawString(this.font, currentBg.toUpperCase(), previewX + (previewWidth - nameWidth) / 2, previewY + previewHeight + 10, 0xFFFFFF);
        }
        String title = Constants.TRANSLATOR.translate("nekoui.config.title", new Object[0]);
        int titleWidth = this.font.width(title);
        graphics.drawString(this.font, title, (this.width - titleWidth) / 2, 20, 0xFFFFFF);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    private record PreviewItem(int index, float x, float z) {
    }
}

