/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.rpc.intergrations;

import com.google.gson.JsonObject;
import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.IPCListener;
import com.jagrosh.discordipc.entities.Packet;
import com.jagrosh.discordipc.entities.User;
import org.nokarin.nekoui.NekoUI;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.impl.DiscordStatus;

public class IPCListeners
implements IPCListener {
    public void onActivityJoin(IPCClient client, String secret) {
    }

    public void onActivitySpectate(IPCClient client, String secret) {
    }

    public void onActivityJoinRequest(IPCClient client, String secret, User user) {
    }

    public void onReady(IPCClient client) {
        if (NekoUI.DISCORD_RPC.STATUS != DiscordStatus.Connected) {
            NekoUI.DISCORD_RPC.STATUS = DiscordStatus.Connected;
            NekoUI.DISCORD_RPC.CURRENT_USER = client.getCurrentUser();
            Constants.LOG.info(Constants.TRANSLATOR.translate("nekoui.rpc.loaded", new Object[0]), "1323688954679267489", NekoUI.DISCORD_RPC.CURRENT_USER != null ? NekoUI.DISCORD_RPC.CURRENT_USER.getEffectiveName() : "null");
        }
    }

    public void onClose(IPCClient client, JsonObject json) {
        if (NekoUI.DISCORD_RPC.isConnected()) {
            NekoUI.DISCORD_RPC.STATUS = DiscordStatus.Closed;
        }
    }

    public void onDisconnect(IPCClient client, Throwable t) {
        if (NekoUI.DISCORD_RPC.STATUS != DiscordStatus.Disconnected) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("nekoui.rpc.error.ipc", new Object[0]), t.getMessage());
            NekoUI.DISCORD_RPC.shutDown();
        }
    }

    public void onPacketReceived(IPCClient client, Packet packet) {
        try {
            JsonObject data;
            JsonObject parsedData = packet.getJson();
            if (parsedData.has("cmd") && parsedData.getAsJsonPrimitive("cmd").getAsString().equals("SET_ACTIVITY") && (data = parsedData.getAsJsonObject("data")).has("name")) {
                NekoUI.DISCORD_RPC.CURRENT_TITLE = data.getAsJsonPrimitive("name").getAsString();
            }
        }
        catch (Throwable ex) {
            Constants.LOG.debugError(ex);
        }
    }

    public void onPacketSent(IPCClient client, Packet packet) {
    }
}

