/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.background;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.core.background.cache.BackgroundCache;

public class Background {
    private final String name;
    private final ResourceLocation[] framePaths;

    protected Background(String name, ResourceLocation[] framePaths) {
        this.name = name;
        this.framePaths = framePaths;
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation[] getFramePaths() {
        return this.framePaths;
    }

    public boolean isAnimated() {
        return this.framePaths.length > 1;
    }

    public static ResourceLocation[] createFramePaths(String basePath, int frameCount) {
        ResourceLocation[] paths = new ResourceLocation[frameCount];
        for (int i = 0; i < frameCount; ++i) {
            String path = basePath + (i + 1) + ".png";
            paths[i] = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)path);
        }
        return paths;
    }

    public static String[] getAvailableBackgrounds() {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        HashSet backgrounds = new HashSet();
        resourceManager.listResources("background", location -> {
            String path = location.getPath().toLowerCase();
            return path.endsWith(".png") || path.endsWith(".jpg") || path.endsWith(".jpeg");
        }).forEach((location, resource) -> {
            String path = location.getPath();
            String[] parts = path.split("/");
            if (parts.length >= 2) {
                String bgName = parts[1].toLowerCase();
                backgrounds.add(bgName);
            }
        });
        return backgrounds.toArray(new String[0]);
    }

    public static ResourceLocation[] loadAnimatedFramePaths(String backgroundName) {
        if (backgroundName == null || backgroundName.isEmpty()) {
            Constants.LOG.warn("Background name is null or empty. Falling back to default background.", new Object[0]);
            return new DefaultBackground().getFramePaths();
        }
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        ArrayList<ResourceLocation> frameList = new ArrayList<ResourceLocation>();
        String folder = "background/" + backgroundName.toLowerCase();
        resourceManager.listResources(folder, location -> {
            String path = location.getPath().toLowerCase();
            return path.endsWith(".png") || path.endsWith(".jpg") || path.endsWith(".jpeg");
        }).forEach((location, resource) -> {
            if (location.getPath().startsWith(folder)) {
                frameList.add((ResourceLocation)location);
            }
        });
        if (frameList.isEmpty()) {
            Constants.LOG.warn("No frames found in '{}'. Falling back to default background.", folder);
            return new DefaultBackground().getFramePaths();
        }
        frameList.sort(Comparator.comparingInt(location -> {
            String filename = location.getPath().substring(location.getPath().lastIndexOf(47) + 1);
            String digits = filename.replaceAll("\\D+", "");
            try {
                return Integer.parseInt(digits);
            }
            catch (NumberFormatException e) {
                return Integer.MAX_VALUE;
            }
        }));
        ArrayList<ResourceLocation> validFrames = new ArrayList<ResourceLocation>();
        for (ResourceLocation loc : frameList) {
            String filename = loc.getPath().substring(loc.getPath().lastIndexOf(47) + 1);
            if (!filename.matches(".*\\d+.*")) continue;
            validFrames.add(loc);
        }
        if (validFrames.isEmpty()) {
            Constants.LOG.warn("No numbered frames found in '{}'. Ignoring non-numeric files. Using default background.", folder);
            return new DefaultBackground().getFramePaths();
        }
        return frameList.toArray(new ResourceLocation[0]);
    }

    public static class DefaultBackground
    extends Background {
        public DefaultBackground() {
            super("DEFAULT", DefaultBackground.createFramePaths("background/default/default", 1));
        }
    }

    public static class AnimatedBackground
    extends Background {
        public AnimatedBackground(String name, ResourceLocation[] framePaths) {
            super(name, framePaths);
            BackgroundCache.preload(framePaths);
        }
    }
}

