/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.background.cache;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.nokarin.nekoui.core.Constants;
import org.nokarin.nekoui.utils.ImageUtils;

public class BackgroundCache {
    private static final Map<ResourceLocation, DynamicTexture> cache = new HashMap<ResourceLocation, DynamicTexture>();
    private static final Set<String> SUPPORTED_EXTENSIONS = Set.of("png", "jpg", "jpeg");

    public static DynamicTexture getOrLoad(ResourceLocation location) {
        DynamicTexture dynamicTexture;
        block10: {
            if (!BackgroundCache.isSupportedFormat(location.getPath())) {
                Constants.LOG.error("Unsupported image format for background: " + location.getPath(), new Object[0]);
                return null;
            }
            if (cache.containsKey(location)) {
                return cache.get(location);
            }
            InputStream stream = ((Resource)Minecraft.getInstance().getResourceManager().getResource(location).orElseThrow()).open();
            try {
                DynamicTexture texture = new DynamicTexture(ImageUtils.loadNativeImage(stream, location.getPath()));
                cache.put(location, texture);
                dynamicTexture = texture;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Constants.LOG.error("Failed to load background frame: " + String.valueOf(location), new Object[0]);
                    Constants.LOG.printStackTrace((Throwable)e, "Background:", "Please enable verbose mode to view more details.", new Appendable[0]);
                    return null;
                }
            }
            stream.close();
        }
        return dynamicTexture;
    }

    public static void preload(ResourceLocation[] locations) {
        for (ResourceLocation loc : locations) {
            BackgroundCache.getOrLoad(loc);
        }
    }

    private static boolean isSupportedFormat(String path) {
        String lowerPath = path.toLowerCase();
        for (String ext : SUPPORTED_EXTENSIONS) {
            if (!lowerPath.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static void clear() {
        for (DynamicTexture tex : cache.values()) {
            tex.close();
        }
        cache.clear();
    }
}

