/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.ui.layout;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import org.nokarin.nekoui.core.ui.layout.UIAnchor;

public class GridLayout {
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    private final int columns;
    private final int spacing;
    private final UIAnchor anchor;

    public GridLayout(UIAnchor anchor, int columns, int spacing) {
        this.anchor = anchor;
        this.columns = columns;
        this.spacing = spacing;
    }

    public void add(AbstractWidget widget) {
        this.widgets.add(widget);
    }

    public List<AbstractWidget> build(int screenWidth, int screenHeight) {
        int cellWidth = this.widgets.get(0).getWidth();
        int cellHeight = this.widgets.get(0).getHeight();
        int rows = (int)Math.ceil((double)this.widgets.size() / (double)this.columns);
        int totalWidth = this.columns * cellWidth + (this.columns - 1) * this.spacing;
        int totalHeight = rows * cellHeight + (rows - 1) * this.spacing;
        int baseX = this.anchor.resolveX(screenWidth, totalWidth);
        int baseY = this.anchor.resolveY(screenHeight, totalHeight);
        for (int i = 0; i < this.widgets.size(); ++i) {
            int row = i / this.columns;
            int col = i % this.columns;
            AbstractWidget widget = this.widgets.get(i);
            int x = baseX + col * (cellWidth + this.spacing);
            int y = baseY + row * (cellHeight + this.spacing);
            widget.setX(x);
            widget.setY(y);
        }
        return this.widgets;
    }
}

