/*
 * Decompiled with CFR 0.152.
 */
package org.nokarin.nekoui.core.ui.widget;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.nokarin.nekoui.core.Constants;

public class VersionInfoWidget
extends AbstractWidget {
    private final ResourceLocation texture;
    private final float scale;

    public VersionInfoWidget(int x, int y, int width, int height, ResourceLocation texture, float scale) {
        super(x, y, width, height, (Component)Component.empty());
        this.texture = texture;
        this.scale = scale;
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Minecraft mc = Minecraft.getInstance();
        graphics.blit(RenderType::guiTextured, this.texture, this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        graphics.pose().scale(this.scale, this.scale, 1.0f);
        String nekouiT = "NekoUI: Java Edition";
        String versionT = "v1.0.1-release+mc" + Constants.MCVersion;
        int nekouiX = (int)(((float)this.getWidth() / 2.0f - (float)mc.font.width(nekouiT) / 2.0f) / this.scale);
        float f = (float)this.getHeight() / 2.0f;
        Objects.requireNonNull(mc.font);
        int nekouiY = (int)((f - 9.0f / 2.0f) / this.scale);
        int versionX = (int)(((float)this.getWidth() / 2.0f - (float)mc.font.width(versionT) / 2.0f) / this.scale);
        float f2 = (float)this.getHeight() / 2.0f;
        Objects.requireNonNull(mc.font);
        int versionY = (int)((f2 - 9.0f / 2.0f) / this.scale);
        graphics.drawString(mc.font, nekouiT, nekouiX - 8, nekouiY + 2, 0xFFFFFF);
        graphics.drawString(mc.font, versionT, versionX + 5, versionY + 16, 0xFFFFFF);
        graphics.pose().popPose();
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double d, double e, int i) {
        return false;
    }

    public void playDownSound(@NotNull SoundManager soundManager) {
    }
}

