/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.api.packager;

import com.simibubi.create.foundation.utility.BlockFace;
import java.util.Set;
import moe.paring.createlogisticsbackport.api.registry.SimpleRegistry;
import moe.paring.createlogisticsbackport.content.logistics.packager.AllInventoryIdentifiers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface InventoryIdentifier {
    public static final SimpleRegistry<Block, Finder> REGISTRY = SimpleRegistry.create();

    public boolean contains(BlockFace var1);

    @Nullable
    public static InventoryIdentifier get(Level level, BlockFace face) {
        BlockState state = level.m_8055_(face.getPos());
        Finder finder = REGISTRY.get((StateHolder<Block, ?>)state);
        Finder toQuery = finder != null ? finder : AllInventoryIdentifiers::fallback;
        return toQuery.find(level, state, face);
    }

    @FunctionalInterface
    public static interface Finder {
        @Nullable
        public InventoryIdentifier find(Level var1, BlockState var2, BlockFace var3);
    }

    public record MultiFace(BlockPos pos, Set<Direction> sides) implements InventoryIdentifier
    {
        @Override
        public boolean contains(BlockFace face) {
            return this.pos.equals((Object)face.getPos()) && this.sides.contains(face.getFace());
        }
    }

    public record Bounds(BoundingBox bounds) implements InventoryIdentifier
    {
        @Override
        public boolean contains(BlockFace face) {
            return this.bounds.m_71051_((Vec3i)face.getPos());
        }
    }

    public record Pair(BlockPos first, BlockPos second) implements InventoryIdentifier
    {
        @Override
        public boolean contains(BlockFace face) {
            BlockPos pos = face.getPos();
            return this.first.equals((Object)pos) || this.second.equals((Object)pos);
        }
    }

    public record Single(BlockPos pos) implements InventoryIdentifier
    {
        @Override
        public boolean contains(BlockFace face) {
            return this.pos.equals((Object)face.getPos());
        }
    }
}

