/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.api.packager.unpacking;

import com.simibubi.create.content.kinetics.crafter.ConnectedInputHandler;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import java.util.List;
import moe.paring.createlogisticsbackport.api.packager.unpacking.UnpackingHandler;
import moe.paring.createlogisticsbackport.content.logistics.BigItemStack;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.PackageOrderWithCrafts;
import moe.paring.createlogisticsbackport.mixin.MechanicalCrafterBlockEntityAccessor;
import moe.paring.createlogisticsbackport.polyfill.ConnectedInputExtra;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public enum CrafterUnpackingHandler implements UnpackingHandler
{
    INSTANCE;


    @Override
    public boolean unpack(Level level, BlockPos pos, BlockState state, Direction side, List<ItemStack> items, @Nullable PackageOrderWithCrafts orderContext, boolean simulate) {
        if (!PackageOrderWithCrafts.hasCraftingInformation(orderContext)) {
            return DEFAULT.unpack(level, pos, state, side, items, null, simulate);
        }
        List<BigItemStack> craftingContext = orderContext.getCraftingInformation();
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof MechanicalCrafterBlockEntity)) {
            return false;
        }
        MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)be;
        ConnectedInputHandler.ConnectedInput input = ((MechanicalCrafterBlockEntityAccessor)crafter).getInput();
        List<MechanicalCrafterBlockEntity.Inventory> inventories = ConnectedInputExtra.getInventories(input, level, pos);
        if (inventories.isEmpty()) {
            return false;
        }
        int max = Math.min(inventories.size(), craftingContext.size());
        block0: for (int i = 0; i < max; ++i) {
            MechanicalCrafterBlockEntity.Inventory inventory;
            BigItemStack targetStack = craftingContext.get(i);
            if (targetStack.stack.m_41619_() || !(inventory = inventories.get(i)).getStackInSlot(0).m_41619_()) continue;
            for (ItemStack stack : items) {
                ItemStack toInsert;
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)targetStack.stack) || !inventory.insertItem(0, toInsert = stack.m_255036_(1), simulate).m_41619_()) continue;
                stack.m_41774_(1);
                continue block0;
            }
        }
        for (ItemStack item : items) {
            if (item.m_41619_()) continue;
            return false;
        }
        if (!simulate) {
            ((MechanicalCrafterBlockEntityAccessor)crafter).invokeCheckCompletedRecipe(true);
        }
        return true;
    }
}

