/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.api.packager.unpacking;

import java.util.List;
import moe.paring.createlogisticsbackport.api.packager.unpacking.UnpackingHandler;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.PackageOrderWithCrafts;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public enum DefaultUnpackingHandler implements UnpackingHandler
{
    INSTANCE;


    @Override
    public boolean unpack(Level level, BlockPos pos, BlockState state, Direction side, List<ItemStack> items, @Nullable PackageOrderWithCrafts orderContext, boolean simulate) {
        BlockEntity targetBE = level.m_7702_(pos);
        if (targetBE == null) {
            return false;
        }
        IItemHandler targetInv = targetBE.getCapability(ForgeCapabilities.ITEM_HANDLER, side).resolve().orElse(null);
        if (targetInv == null) {
            return false;
        }
        if (!simulate) {
            for (ItemStack itemStack : items) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)false);
            }
            return true;
        }
        for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
            ItemStack itemInSlot = targetInv.getStackInSlot(slot);
            int itemsAddedToSlot = 0;
            for (int boxSlot = 0; boxSlot < items.size(); ++boxSlot) {
                ItemStack toInsert = items.get(boxSlot);
                if (toInsert.m_41619_() || targetInv.insertItem(slot, toInsert, true).m_41613_() == toInsert.m_41613_()) continue;
                if (itemInSlot.m_41619_()) {
                    int maxStackSize = targetInv.getSlotLimit(slot);
                    if (maxStackSize < toInsert.m_41613_()) {
                        toInsert.m_41774_(maxStackSize);
                        toInsert = ItemHandlerHelper.copyStackWithSize((ItemStack)toInsert, (int)maxStackSize);
                    } else {
                        items.set(boxSlot, ItemStack.f_41583_);
                    }
                    itemInSlot = toInsert;
                    targetInv.insertItem(slot, toInsert, simulate);
                    continue;
                }
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)toInsert, (ItemStack)itemInSlot)) continue;
                int insertedAmount = toInsert.m_41613_() - targetInv.insertItem(slot, toInsert, simulate).m_41613_();
                int slotLimit = (int)((targetInv.getStackInSlot(slot).m_41619_() ? (float)itemInSlot.m_41741_() / 64.0f : 1.0f) * (float)targetInv.getSlotLimit(slot));
                int insertableAmountWithPreviousItems = Math.min(toInsert.m_41613_(), slotLimit - itemInSlot.m_41613_() - itemsAddedToSlot);
                int added = Math.min(insertedAmount, Math.max(0, insertableAmountWithPreviousItems));
                itemsAddedToSlot += added;
                items.set(boxSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)toInsert, (int)(toInsert.m_41613_() - added)));
            }
        }
        for (ItemStack stack : items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }
}

