/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.compat.computercraft.luaObjects;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.paring.createlogisticsbackport.compat.computercraft.ComputerUtil;
import moe.paring.createlogisticsbackport.compat.computercraft.luaObjects.LuaComparable;
import moe.paring.createlogisticsbackport.compat.computercraft.luaObjects.LuaItemStack;
import moe.paring.createlogisticsbackport.compat.computercraft.luaObjects.PackageOrderLuaObject;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageItem;
import moe.paring.createlogisticsbackport.content.logistics.packager.PackagerBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class PackageLuaObject
implements LuaComparable {
    public PackagerBlockEntity blockEntity;
    public ItemStack box;
    public String address;

    public PackageLuaObject(PackagerBlockEntity blockEntity, ItemStack box) {
        this.blockEntity = blockEntity;
        this.box = box;
        this.address = PackageItem.getAddress(box);
    }

    @LuaFunction(mainThread=true)
    public final boolean isEditable() {
        return this.blockEntity != null && !this.blockEntity.heldBox.m_41619_() && this.blockEntity.heldBox == this.box;
    }

    @LuaFunction(mainThread=true)
    public final String getAddress() throws LuaException {
        if (this.isEditable()) {
            this.address = PackageItem.getAddress(this.box);
        }
        return this.address;
    }

    @LuaFunction(mainThread=true)
    public final void setAddress(String argument) throws LuaException {
        if (!this.isEditable()) {
            throw new LuaException("Package is not editable");
        }
        PackageItem.addAddress(this.box, argument);
        this.address = argument;
    }

    @LuaFunction(mainThread=true)
    public Map<Integer, Map<String, ?>> list() {
        return ComputerUtil.list((IItemHandler)PackageItem.getContents(this.box));
    }

    @LuaFunction(mainThread=true)
    public Map<String, ?> getItemDetail(int slot) throws LuaException {
        return ComputerUtil.getItemDetail((IItemHandler)PackageItem.getContents(this.box), slot);
    }

    public boolean hasOrderData() {
        return PackageItem.hasFragmentData(this.box);
    }

    @LuaFunction(mainThread=true)
    public final PackageOrderLuaObject getOrderData() throws LuaException {
        if (!this.hasOrderData()) {
            return null;
        }
        return new PackageOrderLuaObject(this);
    }

    public final List<LuaItemStack> getLuaItemStacks() {
        ItemStackHandler results = PackageItem.getContents(this.box);
        ArrayList<LuaItemStack> result = new ArrayList<LuaItemStack>();
        for (int i = 0; i < results.getSlots(); ++i) {
            ItemStack stack = results.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            result.add(new LuaItemStack(stack));
        }
        return result;
    }

    @Override
    public Map<?, ?> getTableRepresentation() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("address", this.getAddress());
            map.put("contents", this.getLuaItemStacks());
            if (this.hasOrderData()) {
                map.put("orderData", this.getOrderData());
            }
            return map;
        }
        catch (LuaException e) {
            return null;
        }
    }
}

