/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.equipment.blueprint;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.blueprint.BlueprintEntity;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.trains.track.TrackPlacement;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import moe.paring.createlogisticsbackport.content.logistics.BigItemStack;
import moe.paring.createlogisticsbackport.content.logistics.packager.InventorySummary;
import moe.paring.createlogisticsbackport.content.logistics.tableCloth.BlueprintOverlayShopContext;
import moe.paring.createlogisticsbackport.content.logistics.tableCloth.ShoppingListItem;
import moe.paring.createlogisticsbackport.content.logistics.tableCloth.TableClothBlockEntity;
import moe.paring.createlogisticsbackport.polyfill.ItemHelperExtra;
import moe.paring.createlogisticsbackport.registry.ExtraGuiTextures;
import moe.paring.createlogisticsbackport.registry.ExtraItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BlueprintOverlayRenderer2 {
    public static final IGuiOverlay OVERLAY = BlueprintOverlayRenderer2::renderOverlay;
    static BlueprintOverlayShopContext shopContext;
    static boolean active;
    static boolean empty;
    static boolean noOutput;
    static List<Pair<ItemStack, Boolean>> ingredients;
    static Map<ItemStack, ItemStack[]> cachedRenderedFilters;
    static List<ItemStack> results;
    static boolean resultCraftable;

    public static void tick() {
        Minecraft mc = Minecraft.m_91087_();
        active = false;
        noOutput = false;
        shopContext = null;
        if (mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        HitResult mouseOver = mc.f_91077_;
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.m_6662_() != HitResult.Type.ENTITY) {
            return;
        }
        EntityHitResult entityRay = (EntityHitResult)mouseOver;
        Entity entity = entityRay.m_82443_();
        if (!(entity instanceof BlueprintEntity)) {
            return;
        }
        BlueprintEntity blueprintEntity = (BlueprintEntity)entity;
        active = true;
    }

    public static void displayTrackRequirements(TrackPlacement.PlacementInfo info, ItemStack pavementItem) {
        if (active) {
            return;
        }
        BlueprintOverlayRenderer2.prepareCustomOverlay();
        for (int tracks = info.requiredTracks; tracks > 0; tracks -= 64) {
            ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)new ItemStack((ItemLike)info.trackMaterial.getBlock(), Math.min(64, tracks)), (Object)info.hasRequiredTracks));
        }
        for (int pavement = info.requiredPavement; pavement > 0; pavement -= 64) {
            ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)pavementItem, (int)Math.min(64, pavement)), (Object)info.hasRequiredPavement));
        }
    }

    public static void displayChainRequirements(Item chainItem, int count, boolean fulfilled) {
        if (active) {
            return;
        }
        BlueprintOverlayRenderer2.prepareCustomOverlay();
        for (int chains = count; chains > 0; chains -= 64) {
            ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)new ItemStack((ItemLike)chainItem, Math.min(64, chains)), (Object)fulfilled));
        }
    }

    public static void displayClothShop(TableClothBlockEntity dce, int alreadyPurchased, ShoppingListItem.ShoppingList list) {
        if (active) {
            return;
        }
        BlueprintOverlayRenderer2.prepareCustomOverlay();
        noOutput = false;
        shopContext = new BlueprintOverlayShopContext(false, dce.getStockLevelForTrade(list), alreadyPurchased);
        ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)dce.getPaymentItem().m_255036_(dce.getPaymentAmount()), (Object)(!dce.getPaymentItem().m_41619_() && shopContext.stockLevel() > shopContext.purchases() ? 1 : 0)));
        for (BigItemStack entry : dce.requestData.encodedRequest.stacks()) {
            results.add(entry.stack.m_255036_(entry.count));
        }
    }

    public static void displayShoppingList(Couple<InventorySummary> bakedList) {
        if (active || bakedList == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        BlueprintOverlayRenderer2.prepareCustomOverlay();
        noOutput = false;
        shopContext = new BlueprintOverlayShopContext(true, 1, 0);
        for (BigItemStack entry : ((InventorySummary)bakedList.getSecond()).getStacksByCount()) {
            ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)entry.stack.m_255036_(entry.count), (Object)BlueprintOverlayRenderer2.canAfford((Player)mc.f_91074_, entry)));
        }
        for (BigItemStack entry : ((InventorySummary)bakedList.getFirst()).getStacksByCount()) {
            results.add(entry.stack.m_255036_(entry.count));
        }
    }

    private static boolean canAfford(Player player, BigItemStack entry) {
        int itemsPresent = 0;
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack item = player.m_150109_().m_8020_(i);
            if (item.m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)entry.stack)) continue;
            itemsPresent += item.m_41613_();
        }
        return itemsPresent >= entry.count;
    }

    private static void prepareCustomOverlay() {
        active = true;
        empty = false;
        noOutput = true;
        ingredients.clear();
        results.clear();
        shopContext = null;
    }

    public static void renderOverlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91080_ != null) {
            return;
        }
        if (!active || empty) {
            return;
        }
        boolean invalidShop = shopContext != null && (ingredients.isEmpty() || ((ItemStack)ingredients.get(0).getFirst()).m_41619_() || shopContext.stockLevel() == 0);
        int w = 21 * ingredients.size();
        if (!noOutput) {
            w += 21 * results.size();
            w += 30;
        }
        int x = (width - w) / 2;
        int y = height - 100;
        if (shopContext != null) {
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)(x - 2), (int)(y + 1), (int)(w + 4), (int)19, (int)0, (int)0x55000000, (int)0x55000000, (int)0, (int)0);
            ExtraGuiTextures.TRADE_OVERLAY.render(graphics, width / 2 - 48, y - 19);
            if (shopContext.purchases() > 0) {
                graphics.m_280480_(ExtraItems.SHOPPING_LIST.asStack(), width / 2 + 20, y - 20);
                graphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)("x" + shopContext.purchases())), width / 2 + 20 + 16, y - 20 + 4, -1118482, true);
            }
        }
        for (Pair<ItemStack, Boolean> pair : ingredients) {
            RenderSystem.enableBlend();
            ((Boolean)pair.getSecond() != false ? AllGuiTextures.HOTSLOT_ACTIVE : AllGuiTextures.HOTSLOT).render(graphics, x, y);
            ItemStack itemStack = (ItemStack)pair.getFirst();
            String count = shopContext != null && !shopContext.checkout() || (Boolean)pair.getSecond() != false ? null : ChatFormatting.GOLD.toString() + itemStack.m_41613_();
            BlueprintOverlayRenderer2.drawItemStack(graphics, mc, x, y, itemStack, count);
            x += 21;
        }
        if (noOutput) {
            return;
        }
        x += 5;
        RenderSystem.enableBlend();
        if (invalidShop) {
            ExtraGuiTextures.HOTSLOT_ARROW_BAD.render(graphics, x, y + 4);
        } else {
            AllGuiTextures.HOTSLOT_ARROW.render(graphics, x, y + 4);
        }
        x += 25;
        if (results.isEmpty()) {
            AllGuiTextures.HOTSLOT.render(graphics, x, y);
            GuiGameElement.of((ItemLike)Items.f_42127_).at((float)(x + 3), (float)(y + 3)).render(graphics);
        } else {
            for (ItemStack result : results) {
                AllGuiTextures slot;
                AllGuiTextures allGuiTextures = slot = resultCraftable ? AllGuiTextures.HOTSLOT_SUPER_ACTIVE : AllGuiTextures.HOTSLOT;
                if (!invalidShop && shopContext != null && shopContext.stockLevel() > shopContext.purchases()) {
                    slot = AllGuiTextures.HOTSLOT_ACTIVE;
                }
                slot.render(graphics, resultCraftable ? x - 1 : x, resultCraftable ? y - 1 : y);
                BlueprintOverlayRenderer2.drawItemStack(graphics, mc, x, y, result, null);
                x += 21;
            }
        }
        if (shopContext != null && !shopContext.checkout()) {
            int cycle = 0;
            for (boolean count : Iterate.trueAndFalse) {
                for (int i = 0; i < results.size(); ++i) {
                    ItemStack result = results.get(i);
                    List tooltipLines = result.m_41651_((Player)mc.f_91074_, (TooltipFlag)TooltipFlag.f_256752_);
                    if (tooltipLines.size() <= 1) continue;
                    if (count) {
                        ++cycle;
                        continue;
                    }
                    if (gui.m_93079_() / 40 % cycle != i) continue;
                    graphics.m_280666_(gui.m_93082_(), tooltipLines, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
                }
            }
        }
        RenderSystem.disableBlend();
    }

    public static void drawItemStack(GuiGraphics graphics, Minecraft mc, int x, int y, ItemStack itemStack, String count) {
        if (itemStack.m_41720_() instanceof FilterItem) {
            int step = AnimationTickHolder.getTicks((LevelAccessor)mc.f_91073_) / 10;
            ItemStack[] itemsMatchingFilter = BlueprintOverlayRenderer2.getItemsMatchingFilter(itemStack);
            if (itemsMatchingFilter.length > 0) {
                itemStack = itemsMatchingFilter[step % itemsMatchingFilter.length];
            }
        }
        GuiGameElement.of((ItemStack)itemStack).at((float)(x + 3), (float)(y + 3)).render(graphics);
        graphics.m_280302_(mc.f_91062_, itemStack, x + 3, y + 3, count);
    }

    private static ItemStack[] getItemsMatchingFilter(ItemStack filter) {
        return cachedRenderedFilters.computeIfAbsent(filter, itemStack -> {
            CompoundTag tag = itemStack.m_41784_();
            if (AllItems.FILTER.isIn(itemStack) && !tag.m_128471_("Blacklist")) {
                ItemStackHandler filterItems = FilterItem.getFilterItems((ItemStack)itemStack);
                return (ItemStack[])ItemHelperExtra.getNonEmptyStacks(filterItems).toArray(ItemStack[]::new);
            }
            return new ItemStack[0];
        });
    }

    static {
        ingredients = new ArrayList<Pair<ItemStack, Boolean>>();
        cachedRenderedFilters = new IdentityHashMap<ItemStack, ItemStack[]>();
        results = new ArrayList<ItemStack>();
        resultCraftable = false;
    }
}

