/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.kinetics.chainConveyor;

import com.google.common.cache.Cache;
import com.jozufozu.flywheel.backend.Backend;
import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import moe.paring.createlogisticsbackport.config.ExtraConfigs;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorInteractionHandler;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorPackage;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorRoutingTable;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorShape;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageEntity;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageItem;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.frogport.FrogportBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;

public class ChainConveyorBlockEntity
extends KineticBlockEntity
implements ITransformableBlockEntity {
    public Set<BlockPos> connections = new HashSet<BlockPos>();
    public Map<BlockPos, ConnectionStats> connectionStats;
    public Map<BlockPos, ConnectedPort> loopPorts = new HashMap<BlockPos, ConnectedPort>();
    public Map<BlockPos, ConnectedPort> travelPorts = new HashMap<BlockPos, ConnectedPort>();
    public ChainConveyorRoutingTable routingTable = new ChainConveyorRoutingTable();
    List<ChainConveyorPackage> loopingPackages = new ArrayList<ChainConveyorPackage>();
    Map<BlockPos, List<ChainConveyorPackage>> travellingPackages = new HashMap<BlockPos, List<ChainConveyorPackage>>();
    public boolean reversed;
    public boolean cancelDrops;
    public boolean checkInvalid = true;
    BlockPos chainDestroyedEffectToSend;

    public ChainConveyorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(this.connections.isEmpty() ? 3.0 : 64.0);
    }

    public void lazyTick() {
        super.lazyTick();
        this.updateChainShapes();
    }

    public boolean canAcceptMorePackages() {
        return this.loopingPackages.size() + this.travellingPackages.size() < (Integer)ExtraConfigs.server().logistics.chainConveyorCapacity.get();
    }

    public boolean canAcceptPackagesFor(@Nullable BlockPos connection) {
        ChainConveyorBlockEntity otherClbe;
        BlockEntity blockEntity;
        if (connection == null && !this.canAcceptMorePackages()) {
            return false;
        }
        return connection == null || (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)connection))) instanceof ChainConveyorBlockEntity && (otherClbe = (ChainConveyorBlockEntity)blockEntity).canAcceptMorePackages();
    }

    public boolean canAcceptMorePackagesFromOtherConveyor() {
        return this.loopingPackages.size() < (Integer)ExtraConfigs.server().logistics.chainConveyorCapacity.get();
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return super.addToTooltip(tooltip, isPlayerSneaking);
    }

    public void tick() {
        Iterator iterator;
        super.tick();
        if (this.checkInvalid && !this.f_58857_.m_5776_()) {
            this.checkInvalid = false;
            this.removeInvalidConnections();
        }
        float serverSpeed = this.f_58857_.m_5776_() && !this.isVirtual() ? ServerSpeedProvider.get() : 1.0f;
        float speed = this.getSpeed() / 360.0f;
        float radius = 1.5f;
        float distancePerTick = Math.abs(speed);
        float degreesPerTick = speed / ((float)Math.PI * radius) * 360.0f;
        boolean reversedPreviously = this.reversed;
        this.prepareStats();
        if (this.f_58857_.m_5776_() && !Backend.canUseInstancing((Level)this.f_58857_)) {
            this.tickBoxVisuals();
        }
        if (!this.f_58857_.m_5776_()) {
            this.routingTable.tick();
            if (this.routingTable.shouldAdvertise()) {
                for (BlockPos blockPos : this.connections) {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)blockPos));
                    if (!(blockEntity instanceof ChainConveyorBlockEntity)) continue;
                    ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)blockEntity;
                    this.routingTable.advertiseTo(blockPos, clbe.routingTable);
                }
                this.routingTable.changed = false;
                this.routingTable.lastUpdate = 0;
            }
        }
        if (speed == 0.0f) {
            this.updateBoxWorldPositions();
            return;
        }
        if (reversedPreviously != this.reversed) {
            for (Map.Entry entry : this.travellingPackages.entrySet()) {
                BlockPos offset = (BlockPos)entry.getKey();
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)offset));
                if (!(blockEntity instanceof ChainConveyorBlockEntity)) continue;
                ChainConveyorBlockEntity otherLift = (ChainConveyorBlockEntity)blockEntity;
                iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    ChainConveyorPackage chainConveyorPackage = (ChainConveyorPackage)iterator.next();
                    if (chainConveyorPackage.justFlipped) continue;
                    chainConveyorPackage.justFlipped = true;
                    float length = (float)Vec3.m_82528_((Vec3i)offset).m_82553_() - 1.375f;
                    chainConveyorPackage.chainPosition = length - chainConveyorPackage.chainPosition;
                    otherLift.addTravellingPackage(chainConveyorPackage, offset.m_142393_(-1));
                    iterator.remove();
                }
            }
            this.notifyUpdate();
        }
        for (Map.Entry entry : this.travellingPackages.entrySet()) {
            BlockPos target = (BlockPos)entry.getKey();
            ConnectionStats stats = this.connectionStats.get(target);
            if (stats == null) continue;
            iterator = ((List)entry.getValue()).iterator();
            block4: while (iterator.hasNext()) {
                BlockEntity blockEntity;
                ChainConveyorPackage chainConveyorPackage = (ChainConveyorPackage)iterator.next();
                chainConveyorPackage.justFlipped = false;
                float prevChainPosition = chainConveyorPackage.chainPosition;
                chainConveyorPackage.chainPosition += serverSpeed * distancePerTick;
                float anticipatePosition = chainConveyorPackage.chainPosition = Math.min(stats.chainLength, chainConveyorPackage.chainPosition);
                anticipatePosition += serverSpeed * distancePerTick * 4.0f;
                anticipatePosition = Math.min(stats.chainLength, anticipatePosition);
                if (this.f_58857_.m_5776_() && !this.isVirtual()) continue;
                for (Map.Entry<BlockPos, ConnectedPort> portEntry : this.travelPorts.entrySet()) {
                    boolean notAtPositionYet;
                    ConnectedPort port = portEntry.getValue();
                    float chainPosition = port.chainPosition();
                    if (prevChainPosition > chainPosition || !target.equals((Object)port.connection)) continue;
                    boolean bl = notAtPositionYet = chainConveyorPackage.chainPosition < chainPosition;
                    if (notAtPositionYet && anticipatePosition < chainPosition || !PackageItem.matchAddress(chainConveyorPackage.item, port.filter())) continue;
                    if (notAtPositionYet) {
                        this.notifyPortToAnticipate(portEntry.getKey());
                        continue;
                    }
                    if (!this.exportToPort(chainConveyorPackage, portEntry.getKey())) continue;
                    iterator.remove();
                    this.notifyUpdate();
                    continue block4;
                }
                if (chainConveyorPackage.chainPosition < stats.chainLength || !((blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)target))) instanceof ChainConveyorBlockEntity)) continue;
                ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)blockEntity;
                chainConveyorPackage.chainPosition = this.wrapAngle(stats.tangentAngle + 180.0f + (float)(70 * (this.reversed ? -1 : 1)));
                clbe.addLoopingPackage(chainConveyorPackage);
                iterator.remove();
                this.notifyUpdate();
            }
        }
        Iterator<ChainConveyorPackage> iterator2 = this.loopingPackages.iterator();
        block6: while (iterator2.hasNext()) {
            ChainConveyorPackage chainConveyorPackage = iterator2.next();
            chainConveyorPackage.justFlipped = false;
            float prevChainPosition = chainConveyorPackage.chainPosition;
            chainConveyorPackage.chainPosition += serverSpeed * degreesPerTick;
            float anticipatePosition = chainConveyorPackage.chainPosition = this.wrapAngle(chainConveyorPackage.chainPosition);
            anticipatePosition += serverSpeed * degreesPerTick * 4.0f;
            anticipatePosition = this.wrapAngle(anticipatePosition);
            if (this.f_58857_.m_5776_()) continue;
            for (Map.Entry entry : this.loopPorts.entrySet()) {
                boolean notAtPositionYet;
                ConnectedPort port = (ConnectedPort)entry.getValue();
                float offBranchAngle = port.chainPosition();
                boolean bl = notAtPositionYet = !this.loopThresholdCrossed(chainConveyorPackage.chainPosition, prevChainPosition, offBranchAngle);
                if (notAtPositionYet && !this.loopThresholdCrossed(anticipatePosition, prevChainPosition, offBranchAngle) || !PackageItem.matchAddress(chainConveyorPackage.item, port.filter())) continue;
                if (notAtPositionYet) {
                    this.notifyPortToAnticipate((BlockPos)entry.getKey());
                    continue;
                }
                if (!this.exportToPort(chainConveyorPackage, (BlockPos)entry.getKey())) continue;
                iterator2.remove();
                this.notifyUpdate();
                continue block6;
            }
            for (BlockPos blockPos : this.connections) {
                float offBranchAngle;
                ChainConveyorBlockEntity ccbe;
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)blockPos));
                if (blockEntity instanceof ChainConveyorBlockEntity && !(ccbe = (ChainConveyorBlockEntity)blockEntity).canAcceptMorePackagesFromOtherConveyor() || !this.loopThresholdCrossed(chainConveyorPackage.chainPosition, prevChainPosition, offBranchAngle = this.connectionStats.get((Object)blockPos).tangentAngle) || !this.routingTable.getExitFor(chainConveyorPackage.item).equals((Object)blockPos)) continue;
                chainConveyorPackage.chainPosition = 0.0f;
                this.addTravellingPackage(chainConveyorPackage, blockPos);
                iterator2.remove();
                continue block6;
            }
        }
        this.updateBoxWorldPositions();
    }

    public void removeInvalidConnections() {
        boolean changed = false;
        Iterator<BlockPos> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            BlockPos next = iterator.next();
            BlockPos target = this.f_58858_.m_121955_((Vec3i)next);
            if (!this.f_58857_.m_46749_(target)) continue;
            BlockEntity blockEntity = this.f_58857_.m_7702_(target);
            if (blockEntity instanceof ChainConveyorBlockEntity) {
                ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)blockEntity;
                if (ccbe.connections.contains(next.m_142393_(-1))) continue;
            }
            iterator.remove();
            changed = true;
        }
        if (changed) {
            this.notifyUpdate();
        }
    }

    public void notifyConnectedToValidate() {
        for (BlockPos blockPos : this.connections) {
            BlockEntity blockEntity;
            BlockPos target = this.f_58858_.m_121955_((Vec3i)blockPos);
            if (!this.f_58857_.m_46749_(target) || !((blockEntity = this.f_58857_.m_7702_(target)) instanceof ChainConveyorBlockEntity)) continue;
            ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)blockEntity;
            ccbe.checkInvalid = true;
        }
    }

    public void tickBoxVisuals() {
        for (ChainConveyorPackage chainConveyorPackage : this.loopingPackages) {
            this.tickBoxVisuals(chainConveyorPackage);
        }
        for (Map.Entry entry : this.travellingPackages.entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.tickBoxVisuals(box);
            }
        }
    }

    public boolean loopThresholdCrossed(float chainPosition, float prevChainPosition, float offBranchAngle) {
        int sign2;
        int sign1 = Mth.m_14205_((double)AngleHelper.getShortestAngleDiff((double)offBranchAngle, (double)prevChainPosition));
        boolean notCrossed = sign1 >= (sign2 = Mth.m_14205_((double)AngleHelper.getShortestAngleDiff((double)offBranchAngle, (double)chainPosition))) && !this.reversed || sign1 <= sign2 && this.reversed;
        return !notCrossed;
    }

    private boolean exportToPort(ChainConveyorPackage box, BlockPos offset) {
        BlockPos globalPos = this.f_58858_.m_121955_((Vec3i)offset);
        BlockEntity blockEntity = this.f_58857_.m_7702_(globalPos);
        if (!(blockEntity instanceof FrogportBlockEntity)) {
            return false;
        }
        FrogportBlockEntity ppbe = (FrogportBlockEntity)blockEntity;
        if (ppbe.isAnimationInProgress()) {
            return false;
        }
        if (ppbe.isBackedUp()) {
            return false;
        }
        ppbe.startAnimation(box.item, false);
        return true;
    }

    private void notifyPortToAnticipate(BlockPos offset) {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)offset));
        if (blockEntity instanceof FrogportBlockEntity) {
            FrogportBlockEntity ppbe = (FrogportBlockEntity)blockEntity;
            ppbe.sendAnticipate();
        }
    }

    public boolean addTravellingPackage(ChainConveyorPackage box, BlockPos connection) {
        if (!this.connections.contains(connection)) {
            return false;
        }
        this.travellingPackages.computeIfAbsent(connection, $ -> new ArrayList()).add(box);
        if (this.f_58857_.f_46443_) {
            return true;
        }
        this.notifyUpdate();
        return true;
    }

    public void notifyUpdate() {
        this.f_58857_.m_151543_(this.f_58858_);
        this.sendData();
    }

    public boolean addLoopingPackage(ChainConveyorPackage box) {
        this.loopingPackages.add(box);
        this.notifyUpdate();
        return true;
    }

    public void prepareStats() {
        float speed = this.getSpeed();
        if (this.reversed != speed < 0.0f && speed != 0.0f) {
            this.reversed = speed < 0.0f;
            this.connectionStats = null;
        }
        if (this.connectionStats == null) {
            this.connectionStats = new HashMap<BlockPos, ConnectionStats>();
            this.connections.forEach(this::calculateConnectionStats);
        }
    }

    public void updateBoxWorldPositions() {
        this.prepareStats();
        for (Map.Entry<BlockPos, List<ChainConveyorPackage>> entry : this.travellingPackages.entrySet()) {
            BlockPos target = entry.getKey();
            ConnectionStats stats = this.connectionStats.get(target);
            if (stats == null) continue;
            for (ChainConveyorPackage box : entry.getValue()) {
                box.worldPosition = this.getPackagePosition(box.chainPosition, target);
                if (this.f_58857_ == null || !this.f_58857_.m_5776_()) continue;
                Vec3 diff = stats.end.m_82546_(stats.start).m_82541_();
                box.yaw = Mth.m_14177_((float)((float)Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_) * 57.295776f - 90.0f));
            }
        }
        for (ChainConveyorPackage box : this.loopingPackages) {
            box.worldPosition = this.getPackagePosition(box.chainPosition, null);
            box.yaw = Mth.m_14177_((float)box.chainPosition);
            if (!this.reversed) continue;
            box.yaw += 180.0f;
        }
    }

    public Vec3 getPackagePosition(float chainPosition, @Nullable BlockPos travelTarget) {
        if (travelTarget == null) {
            return Vec3.m_82539_((Vec3i)this.f_58858_).m_82549_(VecHelper.rotate((Vec3)new Vec3(0.0, 0.375, 0.875), (double)chainPosition, (Direction.Axis)Direction.Axis.Y));
        }
        this.prepareStats();
        ConnectionStats stats = this.connectionStats.get(travelTarget);
        if (stats == null) {
            return Vec3.f_82478_;
        }
        Vec3 diff = stats.end.m_82546_(stats.start).m_82541_();
        return stats.start.m_82549_(diff.m_82490_((double)Math.min(stats.chainLength, chainPosition)));
    }

    private void tickBoxVisuals(ChainConveyorPackage box) {
        if (box.worldPosition == null) {
            return;
        }
        ChainConveyorPackage.ChainConveyorPackagePhysicsData physicsData = box.physicsData((LevelAccessor)this.f_58857_);
        physicsData.setBE(this);
        if (!physicsData.shouldTick() && !this.isVirtual()) {
            return;
        }
        physicsData.prevTargetPos = physicsData.targetPos;
        physicsData.prevPos = physicsData.pos;
        physicsData.prevYaw = physicsData.yaw;
        physicsData.flipped = this.reversed;
        if (physicsData.pos != null) {
            if (physicsData.pos.m_82557_(box.worldPosition) > 2.25) {
                physicsData.pos = box.worldPosition.m_82549_(physicsData.pos.m_82546_(box.worldPosition).m_82541_().m_82490_(1.5));
            }
            physicsData.motion = physicsData.motion.m_82520_(0.0, -0.25, 0.0).m_82490_(0.75).m_82549_(box.worldPosition.m_82546_(physicsData.pos).m_82490_(0.25));
            physicsData.pos = physicsData.pos.m_82549_(physicsData.motion);
        }
        physicsData.targetPos = box.worldPosition.m_82492_(0.0, 0.5625, 0.0);
        if (physicsData.pos == null) {
            physicsData.pos = physicsData.targetPos;
            physicsData.prevPos = physicsData.targetPos;
            physicsData.prevTargetPos = physicsData.targetPos;
        }
        physicsData.yaw = AngleHelper.angleLerp((double)0.25, (double)physicsData.yaw, (double)box.yaw);
    }

    private void calculateConnectionStats(BlockPos connection) {
        boolean reversed = this.getSpeed() < 0.0f;
        float offBranchDistance = 35.0f;
        float direction = 57.295776f * (float)Mth.m_14136_((double)connection.m_123341_(), (double)connection.m_123343_());
        float angle = this.wrapAngle(direction - offBranchDistance * (float)(reversed ? -1 : 1));
        float oppositeAngle = this.wrapAngle(angle + 180.0f + 2.0f * offBranchDistance * (float)(reversed ? -1 : 1));
        Vec3 start = Vec3.m_82539_((Vec3i)this.f_58858_).m_82549_(VecHelper.rotate((Vec3)new Vec3(0.0, 0.0, 1.25), (double)angle, (Direction.Axis)Direction.Axis.Y)).m_82520_(0.0, 0.375, 0.0);
        Vec3 end = Vec3.m_82539_((Vec3i)this.f_58858_.m_121955_((Vec3i)connection)).m_82549_(VecHelper.rotate((Vec3)new Vec3(0.0, 0.0, 1.25), (double)oppositeAngle, (Direction.Axis)Direction.Axis.Y)).m_82520_(0.0, 0.375, 0.0);
        float length = (float)start.m_82554_(end);
        this.connectionStats.put(connection, new ConnectionStats(angle, length, start, end));
    }

    public boolean addConnectionTo(BlockPos target) {
        BlockPos localTarget = target.m_121996_((Vec3i)this.f_58858_);
        boolean added = this.connections.add(localTarget);
        if (added) {
            this.notifyUpdate();
            this.calculateConnectionStats(localTarget);
            this.updateChainShapes();
        }
        this.detachKinetics();
        this.updateSpeed = true;
        return added;
    }

    public void chainDestroyed(BlockPos target, boolean spawnDrops, boolean sendEffect) {
        int chainCount = ChainConveyorBlockEntity.getChainCost(target);
        if (sendEffect) {
            this.chainDestroyedEffectToSend = target;
            this.sendData();
        }
        if (!spawnDrops) {
            return;
        }
        if (!this.forPointsAlongChains(target, chainCount, vec -> this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, vec.f_82479_, vec.f_82480_, vec.f_82481_, new ItemStack((ItemLike)Items.f_42026_))))) {
            while (chainCount > 0) {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)new ItemStack((ItemLike)Blocks.f_50184_.m_5456_(), Math.min(chainCount, 64)));
                chainCount -= 64;
            }
        }
    }

    public boolean removeConnectionTo(BlockPos target) {
        BlockPos localTarget = target.m_121996_((Vec3i)this.f_58858_);
        if (!this.connections.contains(localTarget)) {
            return false;
        }
        this.detachKinetics();
        this.connections.remove(localTarget);
        this.connectionStats.remove(localTarget);
        List<ChainConveyorPackage> packages = this.travellingPackages.remove(localTarget);
        if (packages != null) {
            for (ChainConveyorPackage box : packages) {
                this.drop(box);
            }
        }
        this.notifyUpdate();
        this.updateChainShapes();
        this.updateSpeed = true;
        return true;
    }

    private void updateChainShapes() {
        this.prepareStats();
        ArrayList<ChainConveyorShape> shapes = new ArrayList<ChainConveyorShape>();
        shapes.add(new ChainConveyorShape.ChainConveyorBB(Vec3.m_82539_((Vec3i)BlockPos.f_121853_)));
        for (BlockPos target : this.connections) {
            ConnectionStats stats = this.connectionStats.get(target);
            if (stats == null) continue;
            Vec3 localStart = stats.start.m_82546_(Vec3.m_82528_((Vec3i)this.f_58858_));
            Vec3 localEnd = stats.end.m_82546_(Vec3.m_82528_((Vec3i)this.f_58858_));
            shapes.add(new ChainConveyorShape.ChainConveyorOBB(target, localStart, localEnd));
        }
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            ((Cache)ChainConveyorInteractionHandler.loadedChains.get((LevelAccessor)this.f_58857_)).put((Object)this.f_58858_, shapes);
        }
    }

    public void remove() {
        super.remove();
        if (this.f_58857_ == null || !this.f_58857_.m_5776_()) {
            return;
        }
        for (BlockPos blockPos : this.connections) {
            this.spawnDestroyParticles(blockPos);
        }
    }

    private void spawnDestroyParticles(BlockPos blockPos) {
        this.forPointsAlongChains(blockPos, (int)Math.round(Vec3.m_82528_((Vec3i)blockPos).m_82553_() * 8.0), vec -> this.f_58857_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50184_.m_49966_()), vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0));
    }

    public void destroy() {
        super.destroy();
        for (BlockPos blockPos : this.connections) {
            this.chainDestroyed(blockPos, !this.cancelDrops, false);
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)blockPos));
            if (!(blockEntity instanceof ChainConveyorBlockEntity)) continue;
            ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)blockEntity;
            clbe.removeConnectionTo(this.f_58858_);
        }
        for (ChainConveyorPackage chainConveyorPackage : this.loopingPackages) {
            this.drop(chainConveyorPackage);
        }
        for (Map.Entry entry : this.travellingPackages.entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.drop(box);
            }
        }
    }

    public boolean forPointsAlongChains(BlockPos connection, int positions, Consumer<Vec3> callback) {
        this.prepareStats();
        ConnectionStats stats = this.connectionStats.get(connection);
        if (stats == null) {
            return false;
        }
        Vec3 start = stats.start;
        Vec3 direction = stats.end.m_82546_(start);
        Vec3 origin = Vec3.m_82512_((Vec3i)this.f_58858_);
        Vec3 normal = direction.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        Vec3 offset = start.m_82546_(origin);
        Vec3 start2 = origin.m_82549_(offset.m_82549_(normal.m_82490_(-2.0 * normal.m_82526_(offset))));
        for (boolean firstChain : Iterate.trueAndFalse) {
            int steps = positions / 2;
            if (firstChain) {
                steps += positions % 2;
            }
            for (int i = 0; i < steps; ++i) {
                callback.accept((firstChain ? start : start2).m_82549_(direction.m_82490_((0.5 + (double)i) / (double)steps)));
            }
        }
        return true;
    }

    public void invalidate() {
        super.invalidate();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            ((Cache)ChainConveyorInteractionHandler.loadedChains.get((LevelAccessor)this.f_58857_)).invalidate((Object)this.f_58858_);
        }
    }

    private void drop(ChainConveyorPackage box) {
        if (box.worldPosition != null) {
            this.f_58857_.m_7967_((Entity)PackageEntity.fromItemStack(this.f_58857_, box.worldPosition.m_82492_(0.0, 0.5, 0.0), box.item));
        }
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        this.connections.forEach(p -> neighbours.add(this.f_58858_.m_121955_((Vec3i)p)));
        return super.addPropagationLocations(block, state, neighbours);
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (this.connections.contains(target.m_58899_().m_121996_((Vec3i)this.f_58858_))) {
            if (!(target instanceof ChainConveyorBlockEntity)) {
                return 0.0f;
            }
            return 1.0f;
        }
        return super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        tag.m_128365_("Connections", (Tag)NBTHelper.writeCompoundList(this.connections, NbtUtils::m_129224_));
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (clientPacket && this.chainDestroyedEffectToSend != null) {
            compound.m_128365_("DestroyEffect", (Tag)NbtUtils.m_129224_((BlockPos)this.chainDestroyedEffectToSend));
            this.chainDestroyedEffectToSend = null;
        }
        compound.m_128365_("Connections", (Tag)NBTHelper.writeCompoundList(this.connections, NbtUtils::m_129224_));
        compound.m_128365_("TravellingPackages", (Tag)NBTHelper.writeCompoundList(this.travellingPackages.entrySet(), entry -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_("Target", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)entry.getKey())));
            compoundTag.m_128365_("Packages", (Tag)NBTHelper.writeCompoundList((Iterable)((Iterable)entry.getValue()), clientPacket ? ChainConveyorPackage::writeToClient : ChainConveyorPackage::write));
            return compoundTag;
        }));
        compound.m_128365_("LoopingPackages", (Tag)NBTHelper.writeCompoundList(this.loopingPackages, clientPacket ? ChainConveyorPackage::writeToClient : ChainConveyorPackage::write));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket && compound.m_128441_("DestroyEffect") && this.f_58857_ != null) {
            this.spawnDestroyParticles(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("DestroyEffect")));
        }
        int sizeBefore = this.connections.size();
        this.connections.clear();
        NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("Connections", 10), c -> this.connections.add(NbtUtils.m_129239_((CompoundTag)c)));
        this.travellingPackages.clear();
        NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("TravellingPackages", 10), c -> this.travellingPackages.put(NbtUtils.m_129239_((CompoundTag)c.m_128469_("Target")), NBTHelper.readCompoundList((ListTag)c.m_128437_("Packages", 10), ChainConveyorPackage::read)));
        this.loopingPackages = NBTHelper.readCompoundList((ListTag)compound.m_128437_("LoopingPackages", 10), ChainConveyorPackage::read);
        this.connectionStats = null;
        this.updateBoxWorldPositions();
        this.updateChainShapes();
        if (this.connections.size() != sizeBefore && this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    public float wrapAngle(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static int getChainCost(BlockPos connection) {
        return (int)Math.max(Math.round(Vec3.m_82528_((Vec3i)connection).m_82553_() / 2.5), 1L);
    }

    public static boolean getChainsFromInventory(Player player, ItemStack chain, int cost, boolean simulate) {
        int found = 0;
        Inventory inv = player.m_150109_();
        int size = inv.f_35974_.size();
        for (int j = 0; j <= size + 1; ++j) {
            boolean offhand;
            int i = j;
            boolean bl = offhand = j == size + 1;
            if (j == size) {
                i = inv.f_35977_;
            } else if (offhand) {
                i = 0;
            } else if (j == inv.f_35977_) continue;
            ItemStack stackInSlot = (ItemStack)(offhand ? inv.f_35976_ : inv.f_35974_).get(i);
            if (!stackInSlot.m_150930_(chain.m_41720_()) || found >= cost) continue;
            int count = stackInSlot.m_41613_();
            if (!simulate) {
                int remainingItems = count - Math.min(cost - found, count);
                if (i == inv.f_35977_) {
                    stackInSlot.m_41751_(null);
                }
                ItemStack newItem = ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)remainingItems);
                if (offhand) {
                    player.m_21008_(InteractionHand.OFF_HAND, newItem);
                } else {
                    inv.m_6836_(i, newItem);
                }
            }
            found += count;
        }
        return found >= cost;
    }

    public List<ChainConveyorPackage> getLoopingPackages() {
        return this.loopingPackages;
    }

    public Map<BlockPos, List<ChainConveyorPackage>> getTravellingPackages() {
        return this.travellingPackages;
    }

    public ItemRequirement getRequiredItems(BlockState state) {
        return super.getRequiredItems(state);
    }

    public void transform(StructureTransform transform) {
        if (this.connections == null || this.connections.isEmpty()) {
            return;
        }
        this.connections = new HashSet<BlockPos>(this.connections.stream().map(arg_0 -> ((StructureTransform)transform).applyWithoutOffset(arg_0)).toList());
        HashMap<BlockPos, List<ChainConveyorPackage>> newMap = new HashMap<BlockPos, List<ChainConveyorPackage>>();
        this.travellingPackages.entrySet().forEach(e -> newMap.put(transform.applyWithoutOffset((BlockPos)e.getKey()), (List)e.getValue()));
        this.travellingPackages = newMap;
        this.connectionStats = null;
        this.notifyUpdate();
    }

    public record ConnectionStats(float tangentAngle, float chainLength, Vec3 start, Vec3 end) {
    }

    public record ConnectedPort(float chainPosition, BlockPos connection, String filter) {
    }
}

