/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.kinetics.chainConveyor;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import moe.paring.createlogisticsbackport.config.ExtraConfigs;
import moe.paring.createlogisticsbackport.content.equipment.blueprint.BlueprintOverlayRenderer2;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorBlock;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorConnectionPacket;
import moe.paring.createlogisticsbackport.registry.ExtraBlocks;
import moe.paring.createlogisticsbackport.registry.ExtraPackets;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ChainConveyorConnectionHandler {
    private static BlockPos firstPos;
    private static ResourceKey<Level> firstDim;

    public static boolean onRightClick() {
        BlockHitResult bhr;
        Minecraft mc = Minecraft.m_91087_();
        if (!ChainConveyorConnectionHandler.isChain(mc.f_91074_.m_21205_())) {
            return false;
        }
        if (firstPos == null) {
            return false;
        }
        boolean missed = false;
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof BlockHitResult && (bhr = (BlockHitResult)hitResult).m_6662_() != HitResult.Type.MISS && !(mc.f_91073_.m_7702_(bhr.m_82425_()) instanceof ChainConveyorBlockEntity)) {
            missed = true;
        }
        if (!mc.f_91074_.m_6144_() && !missed) {
            return false;
        }
        firstPos = null;
        Lang.translate((String)"chain_conveyor.selection_cleared", (Object[])new Object[0]).sendStatus((Player)mc.f_91074_);
        return true;
    }

    @SubscribeEvent
    public static void onItemUsedOnBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack = event.getItemStack();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockState blockState = level.m_8055_(pos);
        if (!ExtraBlocks.CHAIN_CONVEYOR.has(blockState)) {
            return;
        }
        if (!ChainConveyorConnectionHandler.isChain(itemStack)) {
            return;
        }
        if (!player.m_36326_() || player instanceof FakePlayer) {
            return;
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.CONSUME);
        if (!level.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChainConveyorBlockEntity) {
            ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)blockEntity;
            if (ccbe.connections.size() >= (Integer)ExtraConfigs.server().kinetics.maxChainConveyorConnections.get()) {
                Lang.translate((String)"chain_conveyor.cannot_add_more_connections", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                return;
            }
        }
        if (firstPos == null || firstDim != level.m_46472_()) {
            firstPos = pos;
            firstDim = level.m_46472_();
            player.m_6674_(event.getHand());
            return;
        }
        boolean success = ChainConveyorConnectionHandler.validateAndConnect((LevelAccessor)level, pos, player, itemStack, false);
        firstPos = null;
        if (!success) {
            AllSoundEvents.DENY.play(level, player, (Vec3i)pos);
            return;
        }
        SoundType soundtype = Blocks.f_50184_.m_49966_().m_60827_();
        if (soundtype != null) {
            level.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        }
    }

    private static boolean isChain(ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_42026_);
    }

    public static void clientTick() {
        if (firstPos == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockEntity sourceLift = player.m_9236_().m_7702_(firstPos);
        if (firstDim != player.m_9236_().m_46472_() || !(sourceLift instanceof ChainConveyorBlockEntity)) {
            firstPos = null;
            Lang.translate((String)"chain_conveyor.selection_cleared", (Object[])new Object[0]).sendStatus((Player)player);
            return;
        }
        ItemStack stack = player.m_21205_();
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (!ChainConveyorConnectionHandler.isChain(stack) && !ChainConveyorConnectionHandler.isChain(stack = player.m_21206_())) {
            return;
        }
        if (hitResult == null || hitResult.m_6662_() != HitResult.Type.BLOCK) {
            ChainConveyorConnectionHandler.highlightConveyor(firstPos, 0xFFFFFF, "chain_connect");
            return;
        }
        Level level = player.m_9236_();
        BlockHitResult bhr = (BlockHitResult)hitResult;
        BlockPos pos = bhr.m_82425_();
        BlockState hitState = level.m_8055_(pos);
        if (pos.equals((Object)firstPos)) {
            ChainConveyorConnectionHandler.highlightConveyor(firstPos, 0xFFFFFF, "chain_connect");
            Lang.translate((String)"chain_conveyor.select_second", (Object[])new Object[0]).sendStatus((Player)player);
            return;
        }
        if (!(hitState.m_60734_() instanceof ChainConveyorBlock)) {
            ChainConveyorConnectionHandler.highlightConveyor(firstPos, 0xFFFFFF, "chain_connect");
            return;
        }
        boolean success = ChainConveyorConnectionHandler.validateAndConnect((LevelAccessor)level, pos, (Player)player, stack, true);
        if (success) {
            Lang.translate((String)"chain_conveyor.valid_connection", (Object[])new Object[0]).style(ChatFormatting.GREEN).sendStatus((Player)player);
        }
        int color = success ? 9817409 : 15359019;
        ChainConveyorConnectionHandler.highlightConveyor(firstPos, color, "chain_connect");
        ChainConveyorConnectionHandler.highlightConveyor(pos, color, "chain_connect_to");
        Vec3 from = Vec3.m_82512_((Vec3i)pos);
        Vec3 to = Vec3.m_82512_((Vec3i)firstPos);
        Vec3 diff = from.m_82546_(to);
        if (diff.m_82553_() < 1.0) {
            return;
        }
        from = from.m_82546_(diff.m_82541_().m_82490_(0.5));
        to = to.m_82549_(diff.m_82541_().m_82490_(0.5));
        Vec3 normal = diff.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_(0.875);
        CreateClient.OUTLINER.showLine((Object)"chain_connect_line", from.m_82549_(normal), to.m_82549_(normal)).lineWidth(0.0625f).colored(color);
        CreateClient.OUTLINER.showLine((Object)"chain_connect_line_1", from.m_82546_(normal), to.m_82546_(normal)).lineWidth(0.0625f).colored(color);
    }

    private static void highlightConveyor(BlockPos pos, int color, String key) {
        for (int y : Iterate.zeroAndOne) {
            Vec3 prevV = VecHelper.rotate((Vec3)new Vec3(0.0, 0.125 + (double)y * 0.75, 1.25), (double)-22.5, (Direction.Axis)Direction.Axis.Y).m_82549_(Vec3.m_82539_((Vec3i)pos));
            for (int i = 0; i < 8; ++i) {
                Vec3 v = VecHelper.rotate((Vec3)new Vec3(0.0, 0.125 + (double)y * 0.75, 1.25), (double)(22.5 + (double)(i * 45)), (Direction.Axis)Direction.Axis.Y).m_82549_(Vec3.m_82539_((Vec3i)pos));
                CreateClient.OUTLINER.showLine((Object)(key + y + i), prevV, v).lineWidth(0.0625f).colored(color);
                prevV = v;
            }
        }
    }

    public static boolean validateAndConnect(LevelAccessor level, BlockPos pos, Player player, ItemStack chain, boolean simulate) {
        if (!simulate && player.m_6144_()) {
            Lang.translate((String)"chain_conveyor.selection_cleared", (Object[])new Object[0]).sendStatus(player);
            return false;
        }
        if (pos.equals((Object)firstPos)) {
            return false;
        }
        if (!pos.m_123314_((Vec3i)firstPos, (double)((Integer)ExtraConfigs.server().kinetics.maxChainConveyorLength.get()).intValue())) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.too_far");
        }
        if (pos.m_123314_((Vec3i)firstPos, 2.5)) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.too_close");
        }
        Vec3 diff = Vec3.m_82528_((Vec3i)pos.m_121996_((Vec3i)firstPos));
        double horizontalDistance = diff.m_82542_(1.0, 0.0, 1.0).m_82553_() - 1.5;
        if (horizontalDistance <= 0.0) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.cannot_connect_vertically");
        }
        if (Math.abs(diff.f_82480_) / horizontalDistance > 1.0) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.too_steep");
        }
        ChainConveyorBlock chainConveyorBlock = (ChainConveyorBlock)((Object)ExtraBlocks.CHAIN_CONVEYOR.get());
        ChainConveyorBlockEntity sourceLift = (ChainConveyorBlockEntity)chainConveyorBlock.getBlockEntity((BlockGetter)level, firstPos);
        ChainConveyorBlockEntity targetLift = (ChainConveyorBlockEntity)chainConveyorBlock.getBlockEntity((BlockGetter)level, pos);
        if (targetLift.connections.size() >= (Integer)ExtraConfigs.server().kinetics.maxChainConveyorConnections.get()) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.cannot_add_more_connections");
        }
        if (targetLift.connections.contains(firstPos.m_121996_((Vec3i)pos))) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.already_connected");
        }
        if (sourceLift == null || targetLift == null) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.blocks_invalid");
        }
        if (!player.m_7500_()) {
            int chainCost = ChainConveyorBlockEntity.getChainCost(pos.m_121996_((Vec3i)firstPos));
            boolean hasEnough = ChainConveyorBlockEntity.getChainsFromInventory(player, chain, chainCost, true);
            if (simulate) {
                BlueprintOverlayRenderer2.displayChainRequirements(chain.m_41720_(), chainCost, hasEnough);
            }
            if (!hasEnough) {
                return ChainConveyorConnectionHandler.fail("chain_conveyor.not_enough_chains");
            }
        }
        if (simulate) {
            return true;
        }
        ExtraPackets.getChannel().sendToServer((Object)new ChainConveyorConnectionPacket(firstPos, pos, chain, true));
        Lang.text((String)"").sendStatus(player);
        firstPos = null;
        firstDim = null;
        return true;
    }

    private static boolean fail(String message) {
        Lang.translate((String)message, (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus((Player)Minecraft.m_91087_().f_91074_);
        return false;
    }
}

