/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.kinetics.chainConveyor;

import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import moe.paring.createlogisticsbackport.config.ExtraConfigs;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ChainConveyorConnectionPacket
extends BlockEntityConfigurationPacket<ChainConveyorBlockEntity> {
    private BlockPos targetPos;
    private boolean connect;
    private ItemStack chain;

    public ChainConveyorConnectionPacket(BlockPos pos, BlockPos targetPos, ItemStack chain, boolean connect) {
        super(pos);
        this.targetPos = targetPos;
        this.chain = chain;
        this.connect = connect;
    }

    public ChainConveyorConnectionPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.targetPos);
        buffer.writeBoolean(this.connect);
        buffer.m_130055_(this.chain);
    }

    protected void readSettings(FriendlyByteBuf buffer) {
        this.targetPos = buffer.m_130135_();
        this.connect = buffer.readBoolean();
        this.chain = buffer.m_130267_();
    }

    protected int maxRange() {
        return (Integer)ExtraConfigs.server().kinetics.maxChainConveyorLength.get() + 16;
    }

    protected void applySettings(ServerPlayer player, ChainConveyorBlockEntity be) {
        if (!be.m_58899_().m_123314_((Vec3i)this.targetPos, (double)(this.maxRange() - 16 + 1))) {
            return;
        }
        BlockEntity blockEntity = be.m_58904_().m_7702_(this.targetPos);
        if (!(blockEntity instanceof ChainConveyorBlockEntity)) {
            return;
        }
        ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)blockEntity;
        if (this.connect && !player.m_7500_()) {
            int chainCost = ChainConveyorBlockEntity.getChainCost(this.targetPos.m_121996_((Vec3i)be.m_58899_()));
            boolean hasEnough = ChainConveyorBlockEntity.getChainsFromInventory((Player)player, this.chain, chainCost, true);
            if (!hasEnough) {
                return;
            }
            ChainConveyorBlockEntity.getChainsFromInventory((Player)player, this.chain, chainCost, false);
        }
        if (!this.connect) {
            if (!player.m_7500_()) {
                for (int chainCost = ChainConveyorBlockEntity.getChainCost(this.targetPos.m_121996_((Vec3i)this.pos)); chainCost > 0; chainCost -= 64) {
                    player.m_150109_().m_150079_(new ItemStack((ItemLike)Items.f_42026_, Math.min(chainCost, 64)));
                }
            }
            be.chainDestroyed(this.targetPos.m_121996_((Vec3i)be.m_58899_()), false, true);
            be.m_58904_().m_247517_(null, player.m_20183_(), SoundEvents.f_11794_, SoundSource.BLOCKS);
        }
        if (this.connect) {
            if (!clbe.addConnectionTo(be.m_58899_())) {
                return;
            }
        } else {
            clbe.removeConnectionTo(be.m_58899_());
        }
        if (this.connect) {
            if (!be.addConnectionTo(this.targetPos)) {
                clbe.removeConnectionTo(be.m_58899_());
            }
        } else {
            be.removeConnectionTo(this.targetPos);
        }
    }

    protected void applySettings(ChainConveyorBlockEntity be) {
    }
}

