/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.kinetics.chainConveyor;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.api.instance.TickableInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.instancing.GroupInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.SingleRotatingInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorPackage;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageItem;
import moe.paring.createlogisticsbackport.registry.ExtraPartialModels;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ChainConveyorInstance
extends SingleRotatingInstance<ChainConveyorBlockEntity>
implements DynamicInstance,
TickableInstance {
    private final List<ModelData> guards = new ArrayList<ModelData>();
    private final HashMap<ResourceLocation, GroupInstance<ModelData>> boxes = new HashMap();
    private final HashMap<ResourceLocation, GroupInstance<ModelData>> rigging = new HashMap();

    public ChainConveyorInstance(MaterialManager materialManager, ChainConveyorBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
    }

    public void init() {
        super.init();
        this.setupGuards();
        this.updateLight();
    }

    private Instancer<ModelData> getBoxModel(ResourceLocation location) {
        return this.materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(ExtraPartialModels.PACKAGES.get(location));
    }

    private Instancer<ModelData> getRigModel(ResourceLocation location) {
        return this.materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(ExtraPartialModels.PACKAGE_RIGGING.get(location));
    }

    private void clearBoxModels() {
        this.boxes.values().forEach(GroupInstance::clear);
        this.boxes.clear();
    }

    private void clearRigModels() {
        this.rigging.values().forEach(GroupInstance::clear);
        this.rigging.clear();
    }

    public void update() {
        super.update();
        this.setupGuards();
    }

    public void tick() {
        ((ChainConveyorBlockEntity)this.blockEntity).tickBoxVisuals();
    }

    public void beginFrame() {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        this.clearBoxModels();
        this.clearRigModels();
        for (ChainConveyorPackage chainConveyorPackage : ((ChainConveyorBlockEntity)this.blockEntity).loopingPackages) {
            this.setupBoxVisual((ChainConveyorBlockEntity)this.blockEntity, chainConveyorPackage, partialTicks);
        }
        for (Map.Entry entry : ((ChainConveyorBlockEntity)this.blockEntity).travellingPackages.entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.setupBoxVisual((ChainConveyorBlockEntity)this.blockEntity, box, partialTicks);
            }
        }
    }

    InstanceData newBoxModel(ResourceLocation location) {
        if (this.boxes.containsKey(location)) {
            return this.boxes.get(location).addInstance();
        }
        GroupInstance group = new GroupInstance(this.getBoxModel(location));
        this.boxes.put(location, (GroupInstance<ModelData>)group);
        return group.addInstance();
    }

    InstanceData newRigModel(ResourceLocation location) {
        if (this.rigging.containsKey(location)) {
            return this.rigging.get(location).addInstance();
        }
        GroupInstance group = new GroupInstance(this.getRigModel(location));
        this.rigging.put(location, (GroupInstance<ModelData>)group);
        return group.addInstance();
    }

    private void setupBoxVisual(ChainConveyorBlockEntity be, ChainConveyorPackage box, float partialTicks) {
        if (box.worldPosition == null) {
            return;
        }
        if (box.item == null || box.item.m_41619_()) {
            return;
        }
        ChainConveyorPackage.ChainConveyorPackagePhysicsData physicsData = box.physicsData((LevelAccessor)be.m_58904_());
        if (physicsData.prevPos == null) {
            return;
        }
        Vec3 position = physicsData.prevPos.m_165921_(physicsData.pos, (double)partialTicks);
        Vec3 targetPosition = physicsData.prevTargetPos.m_165921_(physicsData.targetPos, (double)partialTicks);
        float yaw = AngleHelper.angleLerp((double)partialTicks, (double)physicsData.prevYaw, (double)physicsData.yaw);
        Vec3 offset = new Vec3(targetPosition.f_82479_ - (double)this.pos.m_123341_(), targetPosition.f_82480_ - (double)this.pos.m_123342_(), targetPosition.f_82481_ - (double)this.pos.m_123343_());
        BlockPos containingPos = BlockPos.m_274446_((Position)position);
        if (physicsData.modelKey == null) {
            ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)box.item.m_41720_());
            if (key == null) {
                return;
            }
            physicsData.modelKey = key;
        }
        ModelData rigBuffer = (ModelData)this.newRigModel(physicsData.modelKey);
        ModelData boxBuffer = (ModelData)this.newBoxModel(physicsData.modelKey);
        Vec3 dangleDiff = VecHelper.rotate((Vec3)targetPosition.m_82520_(0.0, 0.5, 0.0).m_82546_(position), (double)(-yaw), (Direction.Axis)Direction.Axis.Y);
        float zRot = Mth.m_14177_((float)((float)Mth.m_14136_((double)(-dangleDiff.f_82479_), (double)dangleDiff.f_82480_) * 57.295776f)) / 2.0f;
        float xRot = Mth.m_14177_((float)((float)Mth.m_14136_((double)dangleDiff.f_82481_, (double)dangleDiff.f_82480_) * 57.295776f)) / 2.0f;
        zRot = Mth.m_14036_((float)zRot, (float)-25.0f, (float)25.0f);
        xRot = Mth.m_14036_((float)xRot, (float)-25.0f, (float)25.0f);
        this.relight(containingPos, new FlatLit[]{rigBuffer, boxBuffer});
        for (ModelData buf : new ModelData[]{rigBuffer, boxBuffer}) {
            buf.loadIdentity();
            buf.translate((Vec3i)this.getInstancePosition());
            buf.translate(offset);
            buf.translate(0.0, 0.625, 0.0);
            buf.rotateY((double)yaw);
            buf.rotateZ((double)zRot);
            buf.rotateX((double)xRot);
            if (physicsData.flipped && buf == rigBuffer) {
                buf.rotateY(180.0);
            }
            buf.unCentre();
            buf.translate(0.0, (double)(-PackageItem.getHookDistance(box.item) + 0.4375f), 0.0);
            buf.markDirty();
        }
    }

    private void deleteGuards() {
        for (ModelData guard : this.guards) {
            guard.delete();
        }
        this.guards.clear();
    }

    private void setupGuards() {
        this.deleteGuards();
        Instancer guardInstancer = this.materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(ExtraPartialModels.CHAIN_CONVEYOR_GUARD);
        for (BlockPos blockPos : ((ChainConveyorBlockEntity)this.blockEntity).connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = ((ChainConveyorBlockEntity)this.blockEntity).connectionStats.get(blockPos);
            if (stats == null) continue;
            Vec3 diff = stats.end().m_82546_(stats.start());
            double yaw = 57.2957763671875 * Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_);
            ModelData guard = (ModelData)guardInstancer.createInstance();
            ((ModelData)((ModelData)((ModelData)((ModelData)guard.translate((Vec3i)this.getInstancePosition())).centre()).rotateY((double)((float)yaw))).unCentre()).markDirty();
            this.relight(this.pos, new FlatLit[]{guard});
            this.guards.add(guard);
        }
    }

    protected Instancer<RotatingData> getModel() {
        return this.materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(ExtraPartialModels.CHAIN_CONVEYOR_SHAFT);
    }

    public void updateLight() {
        super.updateLight();
        for (ModelData guard : this.guards) {
            this.relight(this.pos, new FlatLit[]{guard});
        }
        this.boxes.values().forEach(modelData -> this.relight(this.pos, modelData.stream()));
    }

    public void remove() {
        super.remove();
        this.deleteGuards();
        this.boxes.forEach((resourceLocation, modelData) -> modelData.clear());
        this.rigging.forEach((resourceLocation, modelData) -> modelData.clear());
        this.boxes.clear();
        this.rigging.clear();
    }
}

