/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.kinetics.chainConveyor;

import com.google.common.cache.Cache;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import moe.paring.createlogisticsbackport.foundation.utility.TickBasedCache;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class ChainConveyorPackage {
    public static final AtomicInteger netIdGenerator = new AtomicInteger();
    private static final int ticksUntilExpired = 30;
    public static final WorldAttached<Cache<Integer, ChainConveyorPackagePhysicsData>> physicsDataCache = new WorldAttached($ -> new TickBasedCache(30, true));
    public float chainPosition;
    public ItemStack item;
    public int netId;
    public boolean justFlipped;
    public Vec3 worldPosition;
    public float yaw;
    private ChainConveyorPackagePhysicsData physicsData;

    public ChainConveyorPackage(float chainPosition, ItemStack item) {
        this(chainPosition, item, netIdGenerator.incrementAndGet());
    }

    public ChainConveyorPackage(float chainPosition, ItemStack item, int netId) {
        this.chainPosition = chainPosition;
        this.item = item;
        this.netId = netId;
        this.physicsData = null;
    }

    public CompoundTag writeToClient() {
        CompoundTag tag = this.write();
        tag.m_128405_("NetID", this.netId);
        return tag;
    }

    public CompoundTag write() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128350_("Position", this.chainPosition);
        compoundTag.m_128365_("Item", (Tag)this.item.serializeNBT());
        return compoundTag;
    }

    public static ChainConveyorPackage read(CompoundTag compoundTag) {
        float pos = compoundTag.m_128457_("Position");
        ItemStack item = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("Item"));
        if (compoundTag.m_128441_("NetID")) {
            return new ChainConveyorPackage(pos, item, compoundTag.m_128451_("NetID"));
        }
        return new ChainConveyorPackage(pos, item);
    }

    public ChainConveyorPackagePhysicsData physicsData(LevelAccessor level) {
        if (this.physicsData == null) {
            try {
                this.physicsData = (ChainConveyorPackagePhysicsData)((Cache)physicsDataCache.get(level)).get((Object)this.netId, () -> new ChainConveyorPackagePhysicsData(this.worldPosition));
                return this.physicsData;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        ((Cache)physicsDataCache.get(level)).getIfPresent((Object)this.netId);
        return this.physicsData;
    }

    public class ChainConveyorPackagePhysicsData {
        public Vec3 targetPos = null;
        public Vec3 prevTargetPos = null;
        public Vec3 prevPos = null;
        public Vec3 pos = null;
        public Vec3 motion = Vec3.f_82478_;
        public int lastTick = AnimationTickHolder.getTicks();
        public float yaw;
        public float prevYaw;
        public boolean flipped;
        public ResourceLocation modelKey;
        public WeakReference<ChainConveyorBlockEntity> beReference;

        public ChainConveyorPackagePhysicsData(Vec3 serverPosition) {
        }

        public boolean shouldTick() {
            if (this.lastTick == AnimationTickHolder.getTicks()) {
                return false;
            }
            this.lastTick = AnimationTickHolder.getTicks();
            return true;
        }

        public void setBE(ChainConveyorBlockEntity ccbe) {
            if (this.beReference == null || this.beReference.get() != ccbe) {
                this.beReference = new WeakReference<ChainConveyorBlockEntity>(ccbe);
            }
        }
    }
}

