/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.kinetics.chainConveyor;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Map;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorPackage;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageItem;
import moe.paring.createlogisticsbackport.registry.ExtraPartialModels;
import moe.paring.createlogisticsbackport.registry.ExtraRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ChainConveyorRenderer
extends KineticBlockEntityRenderer<ChainConveyorBlockEntity> {
    public static final ResourceLocation CHAIN_LOCATION = new ResourceLocation("textures/block/chain.png");
    public static final int MIP_DISTANCE = 48;

    public ChainConveyorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(ChainConveyorBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        BlockPos pos = be.m_58899_();
        this.renderChains(be, ms, buffer, light, overlay);
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        for (ChainConveyorPackage chainConveyorPackage : be.loopingPackages) {
            this.renderBox(be, ms, buffer, overlay, pos, chainConveyorPackage, partialTicks);
        }
        for (Map.Entry entry : be.travellingPackages.entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.renderBox(be, ms, buffer, overlay, pos, box, partialTicks);
            }
        }
    }

    private void renderBox(ChainConveyorBlockEntity be, PoseStack ms, MultiBufferSource buffer, int overlay, BlockPos pos, ChainConveyorPackage box, float partialTicks) {
        if (box.worldPosition == null) {
            return;
        }
        if (box.item == null || box.item.m_41619_()) {
            return;
        }
        ChainConveyorPackage.ChainConveyorPackagePhysicsData physicsData = box.physicsData((LevelAccessor)be.m_58904_());
        if (physicsData.prevPos == null) {
            return;
        }
        Vec3 position = physicsData.prevPos.m_165921_(physicsData.pos, (double)partialTicks);
        Vec3 targetPosition = physicsData.prevTargetPos.m_165921_(physicsData.targetPos, (double)partialTicks);
        float yaw = AngleHelper.angleLerp((double)partialTicks, (double)physicsData.prevYaw, (double)physicsData.yaw);
        Vec3 offset = new Vec3(targetPosition.f_82479_ - (double)pos.m_123341_(), targetPosition.f_82480_ - (double)pos.m_123342_(), targetPosition.f_82481_ - (double)pos.m_123343_());
        BlockPos containingPos = BlockPos.m_274446_((Position)position);
        Level level = be.m_58904_();
        BlockState blockState = be.m_58900_();
        int light = LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, containingPos), (int)level.m_45517_(LightLayer.SKY, containingPos));
        if (physicsData.modelKey == null) {
            ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)box.item.m_41720_());
            if (key == null) {
                return;
            }
            physicsData.modelKey = key;
        }
        SuperByteBuffer rigBuffer = CachedBufferer.partial((PartialModel)ExtraPartialModels.PACKAGE_RIGGING.get(physicsData.modelKey), (BlockState)blockState);
        SuperByteBuffer boxBuffer = CachedBufferer.partial((PartialModel)ExtraPartialModels.PACKAGES.get(physicsData.modelKey), (BlockState)blockState);
        Vec3 dangleDiff = VecHelper.rotate((Vec3)targetPosition.m_82520_(0.0, 0.5, 0.0).m_82546_(position), (double)(-yaw), (Direction.Axis)Direction.Axis.Y);
        float zRot = Mth.m_14177_((float)((float)Mth.m_14136_((double)(-dangleDiff.f_82479_), (double)dangleDiff.f_82480_) * 57.295776f)) / 2.0f;
        float xRot = Mth.m_14177_((float)((float)Mth.m_14136_((double)dangleDiff.f_82481_, (double)dangleDiff.f_82480_) * 57.295776f)) / 2.0f;
        zRot = Mth.m_14036_((float)zRot, (float)-25.0f, (float)25.0f);
        xRot = Mth.m_14036_((float)xRot, (float)-25.0f, (float)25.0f);
        for (SuperByteBuffer buf : new SuperByteBuffer[]{rigBuffer, boxBuffer}) {
            buf.translate(offset);
            buf.translate(0.0, 0.625, 0.0);
            buf.rotateY((double)yaw);
            buf.rotateZ((double)zRot);
            buf.rotateX((double)xRot);
            if (physicsData.flipped && buf == rigBuffer) {
                buf.rotateY(180.0);
            }
            buf.unCentre();
            buf.translate(0.0, (double)(-PackageItem.getHookDistance(box.item) + 0.4375f), 0.0);
            buf.light(light).overlay(overlay).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
        }
    }

    private void renderChains(ChainConveyorBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_()) / (360.0f / Math.abs(be.getSpeed()));
        if ((time %= 1.0f) < 0.0f) {
            time += 1.0f;
        }
        float animation = time - 0.5f;
        for (BlockPos blockPos : be.connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = be.connectionStats.get(blockPos);
            if (stats == null) continue;
            Vec3 diff = stats.end().m_82546_(stats.start());
            double yaw = 57.2957763671875 * Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_);
            double pitch = 57.2957763671875 * Mth.m_14136_((double)diff.f_82480_, (double)diff.m_82542_(1.0, 0.0, 1.0).m_82553_());
            Level level = be.m_58904_();
            BlockPos tilePos = be.m_58899_();
            Vec3 startOffset = stats.start().m_82546_(Vec3.m_82512_((Vec3i)tilePos));
            if (!Backend.canUseInstancing((Level)be.m_58904_())) {
                SuperByteBuffer guard = CachedBufferer.partial((PartialModel)ExtraPartialModels.CHAIN_CONVEYOR_GUARD, (BlockState)be.m_58900_());
                guard.centre();
                guard.rotateY((double)((float)yaw));
                guard.unCentre();
                guard.light(light).overlay(overlay).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
            }
            ms.m_85836_();
            TransformStack chain = TransformStack.cast((PoseStack)ms);
            chain.centre();
            chain.translate(startOffset);
            chain.rotateY((double)((float)yaw));
            chain.rotateX((double)(90.0f - (float)pitch));
            chain.rotateY(45.0);
            chain.translate(0.0, 0.5, 0.0);
            chain.unCentre();
            int light1 = LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, tilePos), (int)level.m_45517_(LightLayer.SKY, tilePos));
            int light2 = LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, tilePos.m_121955_((Vec3i)blockPos)), (int)level.m_45517_(LightLayer.SKY, tilePos.m_121955_((Vec3i)blockPos)));
            boolean far = Minecraft.m_91087_().f_91073_ == be.m_58904_() && !Minecraft.m_91087_().m_167982_().f_112249_.m_90583_().m_82509_((Position)Vec3.m_82512_((Vec3i)tilePos).m_82520_((double)((float)blockPos.m_123341_() / 2.0f), (double)((float)blockPos.m_123342_() / 2.0f), (double)((float)blockPos.m_123343_() / 2.0f)), 48.0);
            ChainConveyorRenderer.renderChain(ms, buffer, animation, stats.chainLength(), light1, light2, far);
            ms.m_85849_();
        }
    }

    public static void renderChain(PoseStack ms, MultiBufferSource buffer, float animation, float length, int light1, int light2, boolean far) {
        float radius = far ? 0.0625f : 0.09375f;
        float minV = far ? 0.0f : animation;
        float maxV = far ? 0.0625f : length + minV;
        float minU = far ? 0.1875f : 0.0f;
        float maxU = far ? 0.25f : 0.1875f;
        ms.m_85836_();
        ms.m_85837_(0.5, 0.0, 0.5);
        VertexConsumer vc = buffer.m_6299_(ExtraRenderTypes.chain(CHAIN_LOCATION));
        ChainConveyorRenderer.renderPart(ms, vc, length, 0.0f, radius, radius, 0.0f, -radius, 0.0f, 0.0f, -radius, minU, maxU, minV, maxV, light1, light2, far);
        ms.m_85849_();
    }

    private static void renderPart(PoseStack pPoseStack, VertexConsumer pConsumer, float pMaxY, float pX0, float pZ0, float pX1, float pZ1, float pX2, float pZ2, float pX3, float pZ3, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2, boolean far) {
        PoseStack.Pose posestack$pose = pPoseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        float uO = far ? 0.0f : 0.1875f;
        ChainConveyorRenderer.renderQuad(matrix4f, matrix3f, pConsumer, 0.0f, pMaxY, pX0, pZ0, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, matrix3f, pConsumer, 0.0f, pMaxY, pX3, pZ3, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, matrix3f, pConsumer, 0.0f, pMaxY, pX1, pZ1, pX2, pZ2, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, matrix3f, pConsumer, 0.0f, pMaxY, pX2, pZ2, pX1, pZ1, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
    }

    private static void renderQuad(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pMinY, float pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2) {
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMinX, pMinZ, pMaxU, pMinV, light2);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMinX, pMinZ, pMaxU, pMaxV, light1);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMaxX, pMaxZ, pMinU, pMaxV, light1);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMaxX, pMaxZ, pMinU, pMinV, light2);
    }

    private static void addVertex(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pY, float pX, float pZ, float pU, float pV, int light) {
        pConsumer.m_252986_(pPose, pX, pY, pZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(pU, pV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public int m_142163_() {
        return 256;
    }

    public boolean shouldRenderOffScreen(ChainConveyorBlockEntity be) {
        return true;
    }

    protected SuperByteBuffer getRotatedModel(ChainConveyorBlockEntity be, BlockState state) {
        return CachedBufferer.partial((PartialModel)ExtraPartialModels.CHAIN_CONVEYOR_SHAFT, (BlockState)state);
    }

    protected RenderType getRenderType(ChainConveyorBlockEntity be, BlockState state) {
        return RenderType.m_110457_();
    }
}

