/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.kinetics.chainConveyor;

import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import com.simibubi.create.foundation.utility.AngleHelper;
import java.util.List;
import moe.paring.createlogisticsbackport.config.ExtraConfigs;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorPackage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class ChainPackageInteractionPacket
extends BlockEntityConfigurationPacket<ChainConveyorBlockEntity> {
    private BlockPos selectedConnection;
    private float chainPosition;
    private ItemStack insertedPackage;

    public ChainPackageInteractionPacket(BlockPos pos, BlockPos selectedConnection, float chainPosition, ItemStack insertedPackage) {
        super(pos);
        this.selectedConnection = selectedConnection == null ? BlockPos.f_121853_ : selectedConnection;
        this.chainPosition = chainPosition;
        this.insertedPackage = insertedPackage == null ? ItemStack.f_41583_ : insertedPackage;
    }

    public ChainPackageInteractionPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.selectedConnection);
        buffer.writeFloat(this.chainPosition);
        buffer.m_130055_(this.insertedPackage);
    }

    protected void readSettings(FriendlyByteBuf buffer) {
        this.selectedConnection = buffer.m_130135_();
        this.chainPosition = buffer.readFloat();
        this.insertedPackage = buffer.m_130267_();
    }

    protected int maxRange() {
        return (Integer)ExtraConfigs.server().kinetics.maxChainConveyorLength.get() + 16;
    }

    protected void applySettings(ChainConveyorBlockEntity be) {
    }

    protected void applySettings(ServerPlayer player, ChainConveyorBlockEntity be) {
        if (this.insertedPackage.m_41619_()) {
            List<ChainConveyorPackage> list;
            float bestDiff = Float.POSITIVE_INFINITY;
            ChainConveyorPackage best = null;
            List<ChainConveyorPackage> list2 = list = this.selectedConnection.equals((Object)BlockPos.f_121853_) ? be.loopingPackages : be.travellingPackages.get(this.selectedConnection);
            if (list == null || list.isEmpty()) {
                return;
            }
            for (ChainConveyorPackage liftPackage : list) {
                float diff = Math.abs(this.selectedConnection == null ? AngleHelper.getShortestAngleDiff((double)liftPackage.chainPosition, (double)this.chainPosition) : liftPackage.chainPosition - this.chainPosition);
                if (diff > bestDiff) continue;
                bestDiff = diff;
                best = liftPackage;
            }
            if (best == null) {
                return;
            }
            if (player.m_21205_().m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, best.item.m_41777_());
            } else {
                player.m_150109_().m_150079_(best.item.m_41777_());
            }
            list.remove(best);
            be.sendData();
            return;
        }
        ChainConveyorPackage chainConveyorPackage = new ChainConveyorPackage(this.chainPosition, this.insertedPackage);
        if (!be.canAcceptPackagesFor(this.selectedConnection)) {
            return;
        }
        if (!player.m_7500_()) {
            player.m_21205_().m_41774_(1);
            if (player.m_21205_().m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
        }
        if (this.selectedConnection.equals((Object)BlockPos.f_121853_)) {
            be.addLoopingPackage(chainConveyorPackage);
        } else {
            be.addTravellingPackage(chainConveyorPackage, this.selectedConnection);
        }
    }
}

