/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class BigItemStack {
    public static final int INF = 1000000000;
    public ItemStack stack;
    public int count;

    public BigItemStack(ItemStack stack) {
        this(stack, 1);
    }

    public BigItemStack(ItemStack stack, int count) {
        this.stack = stack;
        this.count = count;
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Item", (Tag)this.stack.serializeNBT());
        tag.m_128405_("Amount", this.count);
        return tag;
    }

    public static BigItemStack read(CompoundTag tag) {
        return new BigItemStack(ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item")), tag.m_128451_("Amount"));
    }

    public void send(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.stack);
        buffer.m_130130_(this.count);
    }

    public boolean isInfinite() {
        return this.count >= 1000000000;
    }

    public static BigItemStack receive(FriendlyByteBuf buffer) {
        return new BigItemStack(buffer.m_130267_(), buffer.m_130242_());
    }

    public static Comparator<? super BigItemStack> comparator() {
        return (i1, i2) -> Integer.compare(i2.count, i1.count);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BigItemStack) {
            BigItemStack other = (BigItemStack)obj;
            return Objects.equals(this.stack, other.stack) && this.count == other.count;
        }
        return false;
    }

    public int hashCode() {
        return this.nullHash(this.stack) * 31 ^ Integer.hashCode(this.count);
    }

    int nullHash(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public String toString() {
        return "(" + this.stack.m_41786_().getString() + " x" + this.count + ")";
    }

    public static List<BigItemStack> duplicateWrappers(List<BigItemStack> list) {
        ArrayList<BigItemStack> copy = new ArrayList<BigItemStack>();
        for (BigItemStack bigItemStack : list) {
            copy.add(new BigItemStack(bigItemStack.stack, bigItemStack.count));
        }
        return copy;
    }
}

