/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.box;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageEntity;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageItem;
import moe.paring.createlogisticsbackport.polyfill.EntityVisualExtras;
import moe.paring.createlogisticsbackport.registry.ExtraBlocks;
import moe.paring.createlogisticsbackport.registry.ExtraPartialModels;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class PackageVisual
extends EntityInstance<PackageEntity>
implements DynamicInstance {
    public final ModelData instance;

    public PackageVisual(MaterialManager materialManager, PackageEntity entity) {
        super(materialManager, (Entity)entity);
        ItemStack box = entity.box;
        if (box.m_41619_() || !PackageItem.isPackage(box)) {
            box = ExtraBlocks.CARDBOARD_BLOCK.asStack();
        }
        PartialModel model = ExtraPartialModels.PACKAGES.get(ForgeRegistries.ITEMS.getKey((Object)box.m_41720_()));
        this.instance = (ModelData)materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(model).createInstance();
        this.animate();
    }

    public void beginFrame() {
        this.animate();
    }

    private void animate() {
        float partialTick = AnimationTickHolder.getPartialTicks();
        float yaw = Mth.m_14179_((float)partialTick, (float)((PackageEntity)this.entity).f_19859_, (float)((PackageEntity)this.entity).m_146908_());
        Vec3 pos = ((PackageEntity)this.entity).m_20182_();
        Vec3i renderOrigin = this.materialManager.getOriginCoordinate();
        float x = (float)(Mth.m_14139_((double)partialTick, (double)((PackageEntity)this.entity).f_19854_, (double)pos.f_82479_) - (double)renderOrigin.m_123341_());
        float y = (float)(Mth.m_14139_((double)partialTick, (double)((PackageEntity)this.entity).f_19855_, (double)pos.f_82480_) - (double)renderOrigin.m_123342_());
        float z = (float)(Mth.m_14139_((double)partialTick, (double)((PackageEntity)this.entity).f_19856_, (double)pos.f_82481_) - (double)renderOrigin.m_123343_());
        long randomBits = (long)((PackageEntity)this.entity).m_19879_() * 31L * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float xNudge = (((float)(randomBits >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float yNudge = (((float)(randomBits >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float zNudge = (((float)(randomBits >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        Pair<Integer, Integer> light = EntityVisualExtras.computePackedLight(partialTick, this.entity, this.world);
        ((ModelData)((ModelData)((ModelData)this.instance.loadIdentity().translate((double)x - 0.5 + (double)xNudge, (double)(y + yNudge), (double)z - 0.5 + (double)zNudge).centre()).rotateY((double)(-yaw - 90.0f))).unCentre()).setBlockLight(((Integer)light.getFirst()).intValue()).setSkyLight(((Integer)light.getSecond()).intValue()).markDirty();
    }

    protected void remove() {
        this.instance.delete();
    }
}

