/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.factoryBoard;

import com.simibubi.create.foundation.utility.VecHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelBehaviour;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelBlock;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelPosition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FactoryPanelConnection {
    public FactoryPanelPosition from;
    public int amount;
    public List<Direction> path;
    public int arrowBendMode;
    public boolean success;
    public WeakReference<Object> cachedSource;
    private int arrowBendModeCurrentPathUses;

    public FactoryPanelConnection(FactoryPanelPosition from, int amount) {
        this.from = from;
        this.amount = amount;
        this.path = new ArrayList<Direction>();
        this.success = true;
        this.arrowBendMode = -1;
        this.arrowBendModeCurrentPathUses = 0;
        this.cachedSource = new WeakReference<Object>(null);
    }

    public static FactoryPanelConnection read(CompoundTag nbt) {
        FactoryPanelConnection connection = new FactoryPanelConnection(FactoryPanelPosition.read(nbt), nbt.m_128451_("Amount"));
        connection.arrowBendMode = nbt.m_128451_("ArrowBending");
        return connection;
    }

    public CompoundTag write() {
        CompoundTag nbt = this.from.write();
        nbt.m_128405_("Amount", this.amount);
        nbt.m_128405_("ArrowBending", this.arrowBendMode);
        return nbt;
    }

    public List<Direction> getPath(Level level, BlockState state, FactoryPanelPosition to) {
        if (!this.path.isEmpty() && this.arrowBendModeCurrentPathUses == this.arrowBendMode) {
            return this.path;
        }
        boolean findSuitable = this.arrowBendMode == -1;
        this.arrowBendModeCurrentPathUses = this.arrowBendMode;
        FactoryPanelBehaviour fromBehaviour = FactoryPanelBehaviour.at((BlockAndTintGetter)level, to);
        Vec3 diff = this.calculatePathDiff(state, to);
        Vec3 start = fromBehaviour != null ? fromBehaviour.getSlotPositioning().getLocalOffset((LevelAccessor)level, to.pos(), state).m_82549_(Vec3.m_82528_((Vec3i)to.pos())) : Vec3.f_82478_;
        float xRot = 57.295776f * FactoryPanelBlock.getXRot(state);
        float yRot = 57.295776f * FactoryPanelBlock.getYRot(state);
        block0: for (int actualMode = 0; actualMode <= 4; ++actualMode) {
            this.path.clear();
            if (!findSuitable && actualMode != this.arrowBendMode) continue;
            boolean desperateOption = actualMode == 4;
            BlockPos toTravelFirst = BlockPos.f_121853_;
            BlockPos toTravelLast = BlockPos.m_274446_((Position)diff.m_82490_(2.0).m_82520_(0.1, 0.1, 0.1));
            if (actualMode > 1) {
                boolean flipX = diff.f_82479_ > 0.0 ^ actualMode % 2 == 1;
                boolean flipZ = diff.f_82481_ > 0.0 ^ actualMode % 2 == 0;
                int ceilX = Mth.m_184652_((int)toTravelLast.m_123341_(), (int)2);
                int ceilZ = Mth.m_184652_((int)toTravelLast.m_123343_(), (int)2);
                int floorZ = Mth.m_14042_((int)toTravelLast.m_123343_(), (int)2);
                int floorX = Mth.m_14042_((int)toTravelLast.m_123341_(), (int)2);
                toTravelFirst = new BlockPos(flipX ? floorX : ceilX, 0, flipZ ? floorZ : ceilZ);
                toTravelLast = new BlockPos(!flipX ? floorX : ceilX, 0, !flipZ ? floorZ : ceilZ);
            }
            Direction lastDirection = null;
            Direction currentDirection = null;
            for (BlockPos toTravel : List.of(toTravelFirst, toTravelLast)) {
                boolean zIsFarther;
                boolean bl = zIsFarther = Math.abs(toTravel.m_123343_()) > Math.abs(toTravel.m_123341_());
                boolean zIsPreferred = desperateOption ? zIsFarther : actualMode % 2 == 1;
                List<Direction> directionOrder = zIsPreferred ? List.of(Direction.SOUTH, Direction.NORTH, Direction.WEST, Direction.EAST) : List.of(Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.NORTH);
                for (int i = 0; i < 100 && !toTravel.equals((Object)BlockPos.f_121853_); ++i) {
                    for (Direction d : directionOrder) {
                        if (lastDirection != null && d == lastDirection.m_122424_() || currentDirection != null && toTravel.m_121945_(d).m_123333_((Vec3i)BlockPos.f_121853_) >= toTravel.m_121945_(currentDirection).m_123333_((Vec3i)BlockPos.f_121853_)) continue;
                        currentDirection = d;
                    }
                    lastDirection = currentDirection;
                    toTravel = toTravel.m_121945_(currentDirection);
                    this.path.add(currentDirection);
                }
            }
            if (!findSuitable || desperateOption) break;
            BlockPos travelled = BlockPos.f_121853_;
            for (int i = 0; i < this.path.size() - 1; ++i) {
                Direction d = this.path.get(i);
                travelled = travelled.m_121945_(d);
                Vec3 testOffset = Vec3.m_82528_((Vec3i)travelled).m_82490_(0.5);
                testOffset = VecHelper.rotate((Vec3)testOffset, (double)180.0, (Direction.Axis)Direction.Axis.Y);
                testOffset = VecHelper.rotate((Vec3)testOffset, (double)(xRot + 90.0f), (Direction.Axis)Direction.Axis.X);
                Vec3 v = start.m_82549_(testOffset = VecHelper.rotate((Vec3)testOffset, (double)yRot, (Direction.Axis)Direction.Axis.Y));
                if (!level.m_45772_(new AABB(v, v).m_82400_(0.0078125))) continue block0;
            }
        }
        return this.path;
    }

    public Vec3 calculatePathDiff(BlockState state, FactoryPanelPosition to) {
        float xRot = 57.295776f * FactoryPanelBlock.getXRot(state);
        float yRot = 57.295776f * FactoryPanelBlock.getYRot(state);
        int slotDiffx = to.slot().xOffset - this.from.slot().xOffset;
        int slotDiffY = to.slot().yOffset - this.from.slot().yOffset;
        Vec3 diff = Vec3.m_82528_((Vec3i)to.pos().m_121996_((Vec3i)this.from.pos()));
        diff = VecHelper.rotate((Vec3)diff, (double)(-yRot), (Direction.Axis)Direction.Axis.Y);
        diff = VecHelper.rotate((Vec3)diff, (double)(-xRot - 90.0f), (Direction.Axis)Direction.Axis.X);
        diff = VecHelper.rotate((Vec3)diff, (double)-180.0, (Direction.Axis)Direction.Axis.Y);
        diff = diff.m_82520_((double)slotDiffx * 0.5, 0.0, (double)slotDiffY * 0.5);
        diff = diff.m_82542_(1.0, 0.0, 1.0);
        return diff;
    }
}

