/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.factoryBoard;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelBehaviour;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelBlock;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelConnection;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelConnectionPacket;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelPosition;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelSlotPositioning;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import moe.paring.createlogisticsbackport.registry.ExtraBlocks;
import moe.paring.createlogisticsbackport.registry.ExtraPackets;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FactoryPanelConnectionHandler {
    static FactoryPanelPosition connectingFrom;
    static AABB connectingFromBox;
    static boolean relocating;
    static FactoryPanelPosition validRelocationTarget;

    public static boolean panelClicked(LevelAccessor level, Player player, FactoryPanelBehaviour panel) {
        if (connectingFrom == null) {
            return false;
        }
        FactoryPanelBehaviour at = FactoryPanelBehaviour.at((BlockAndTintGetter)level, connectingFrom);
        if (panel.getPanelPosition().equals(connectingFrom) || at == null) {
            player.m_5661_((Component)Component.m_237119_(), true);
            connectingFrom = null;
            connectingFromBox = null;
            return true;
        }
        String checkForIssues = FactoryPanelConnectionHandler.checkForIssues(at, panel);
        if (checkForIssues != null) {
            player.m_5661_((Component)Lang.translate((String)checkForIssues, (Object[])new Object[0]).style(ChatFormatting.RED).component(), true);
            connectingFrom = null;
            connectingFromBox = null;
            AllSoundEvents.DENY.playAt(player.m_9236_(), (Vec3i)player.m_20183_(), 1.0f, 1.0f, false);
            return true;
        }
        ItemStack filterFrom = panel.getFilter();
        ItemStack filterTo = at.getFilter();
        ExtraPackets.getChannel().sendToServer((Object)new FactoryPanelConnectionPacket(panel.getPanelPosition(), connectingFrom, false));
        player.m_5661_((Component)Lang.translate((String)"factory_panel.panels_connected", (Object[])new Object[]{filterFrom.m_41786_().getString(), filterTo.m_41786_().getString()}).style(ChatFormatting.GREEN).component(), true);
        connectingFrom = null;
        connectingFromBox = null;
        player.m_9236_().m_245747_(player.m_20183_(), SoundEvents.f_144048_, SoundSource.BLOCKS, 0.5f, 0.5f, false);
        return true;
    }

    @Nullable
    private static String checkForIssues(FactoryPanelBehaviour from, FactoryPanelBehaviour to) {
        if (from == null) {
            return "factory_panel.connection_aborted";
        }
        if (from.targetedBy.containsKey(to.getPanelPosition())) {
            return "factory_panel.already_connected";
        }
        if (from.targetedBy.size() >= 9) {
            return "factory_panel.cannot_add_more_inputs";
        }
        BlockState state1 = to.blockEntity.m_58900_();
        BlockState state2 = from.blockEntity.m_58900_();
        BlockPos diff = to.getPos().m_121996_((Vec3i)from.getPos());
        if (((BlockState)state1.m_61124_((Property)FactoryPanelBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FactoryPanelBlock.POWERED, (Comparable)Boolean.valueOf(false)) != ((BlockState)state2.m_61124_((Property)FactoryPanelBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FactoryPanelBlock.POWERED, (Comparable)Boolean.valueOf(false))) {
            return "factory_panel.same_orientation";
        }
        if (FactoryPanelBlock.connectedDirection(state1).m_122434_().m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_()) != 0) {
            return "factory_panel.same_surface";
        }
        if (!diff.m_123314_((Vec3i)BlockPos.f_121853_, 16.0)) {
            return "factory_panel.too_far_apart";
        }
        if (to.panelBE().restocker) {
            return "factory_panel.input_in_restock_mode";
        }
        if (to.getFilter().m_41619_() || from.getFilter().m_41619_()) {
            return "factory_panel.no_item";
        }
        return null;
    }

    @Nullable
    private static String checkForIssues(FactoryPanelBehaviour from, FactoryPanelSupportBehaviour to) {
        if (from == null) {
            return "factory_panel.connection_aborted";
        }
        BlockState state1 = from.blockEntity.m_58900_();
        BlockState state2 = to.blockEntity.m_58900_();
        BlockPos diff = to.getPos().m_121996_((Vec3i)from.getPos());
        Direction connectedDirection = FactoryPanelBlock.connectedDirection(state1);
        if (connectedDirection != state2.m_61145_((Property)WrenchableDirectionalBlock.f_52588_).orElse(connectedDirection)) {
            return "factory_panel.same_orientation";
        }
        if (connectedDirection.m_122434_().m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_()) != 0) {
            return "factory_panel.same_surface";
        }
        if (!diff.m_123314_((Vec3i)BlockPos.f_121853_, 16.0)) {
            return "factory_panel.too_far_apart";
        }
        return null;
    }

    public static void clientTick() {
        BlockHitResult bhr;
        if (connectingFrom == null || connectingFromBox == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        FactoryPanelBehaviour at = FactoryPanelBehaviour.at((BlockAndTintGetter)mc.f_91073_, connectingFrom);
        if (!connectingFrom.pos().m_123314_((Vec3i)mc.f_91074_.m_20183_(), 16.0) || at == null) {
            connectingFrom = null;
            connectingFromBox = null;
            mc.f_91074_.m_5661_((Component)Component.m_237119_(), true);
            return;
        }
        CreateClient.OUTLINER.showAABB((Object)connectingFrom, connectingFromBox).colored(AnimationTickHolder.getTicks() % 16 > 8 ? 3716964 : 11006064).lineWidth(0.0625f);
        mc.f_91074_.m_5661_((Component)Lang.translate((String)(relocating ? "factory_panel.click_to_relocate" : "factory_panel.click_second_panel"), (Object[])new Object[0]).component(), true);
        if (!relocating) {
            return;
        }
        validRelocationTarget = null;
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult) || (bhr = (BlockHitResult)hitResult).m_6662_() == HitResult.Type.MISS) {
            return;
        }
        Vec3 offsetPos = bhr.m_82450_().m_82549_(Vec3.m_82528_((Vec3i)bhr.m_82434_().m_122436_()).m_82490_(0.03125));
        BlockPos pos = BlockPos.m_274446_((Position)offsetPos);
        BlockState blockState = at.blockEntity.m_58900_();
        FactoryPanelBlock.PanelSlot slot = FactoryPanelBlock.getTargetedSlot(pos, blockState, offsetPos);
        BlockPos diff = pos.m_121996_((Vec3i)connectingFrom.pos());
        Direction facing = FactoryPanelBlock.connectedDirection(blockState);
        if (facing.m_122434_().m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_()) != 0) {
            return;
        }
        if (!((FactoryPanelBlock)((Object)ExtraBlocks.FACTORY_GAUGE.get())).m_7898_(blockState, (LevelReader)mc.f_91073_, pos)) {
            return;
        }
        if (ExtraBlocks.PACKAGER.has(mc.f_91073_.m_8055_(pos.m_121945_(facing.m_122424_())))) {
            return;
        }
        validRelocationTarget = new FactoryPanelPosition(pos, slot);
        CreateClient.OUTLINER.showAABB((Object)"target", FactoryPanelConnectionHandler.getBB(blockState, validRelocationTarget)).colored(0xEEEEEE).disableLineNormals().lineWidth(0.0625f);
    }

    public static boolean onRightClick() {
        BlockHitResult bhr;
        if (connectingFrom == null || connectingFromBox == null) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        boolean missed = false;
        if (relocating) {
            if (mc.f_91074_.m_6144_()) {
                validRelocationTarget = null;
            }
            if (validRelocationTarget != null) {
                ExtraPackets.getChannel().sendToServer((Object)new FactoryPanelConnectionPacket(validRelocationTarget, connectingFrom, true));
            }
            connectingFrom = null;
            connectingFromBox = null;
            if (validRelocationTarget == null) {
                mc.f_91074_.m_5661_((Component)Lang.translate((String)"factory_panel.relocation_aborted", (Object[])new Object[0]).component(), true);
            }
            relocating = false;
            validRelocationTarget = null;
            return true;
        }
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof BlockHitResult && (bhr = (BlockHitResult)hitResult).m_6662_() != HitResult.Type.MISS) {
            BlockEntity blockEntity = mc.f_91073_.m_7702_(bhr.m_82425_());
            FactoryPanelSupportBehaviour behaviour = (FactoryPanelSupportBehaviour)BlockEntityBehaviour.get((BlockGetter)mc.f_91073_, (BlockPos)bhr.m_82425_(), FactoryPanelSupportBehaviour.TYPE);
            if (behaviour != null) {
                FactoryPanelBehaviour at = FactoryPanelBehaviour.at((BlockAndTintGetter)mc.f_91073_, connectingFrom);
                String checkForIssues = FactoryPanelConnectionHandler.checkForIssues(at, behaviour);
                if (checkForIssues != null) {
                    mc.f_91074_.m_5661_((Component)Lang.translate((String)checkForIssues, (Object[])new Object[0]).style(ChatFormatting.RED).component(), true);
                    connectingFrom = null;
                    connectingFromBox = null;
                    AllSoundEvents.DENY.playAt((Level)mc.f_91073_, (Vec3i)mc.f_91074_.m_20183_(), 1.0f, 1.0f, false);
                    return true;
                }
                FactoryPanelPosition bestPosition = null;
                double bestDistance = Double.POSITIVE_INFINITY;
                for (FactoryPanelBlock.PanelSlot slot : FactoryPanelBlock.PanelSlot.values()) {
                    FactoryPanelPosition panelPosition = new FactoryPanelPosition(blockEntity.m_58899_(), slot);
                    FactoryPanelConnection connection = new FactoryPanelConnection(panelPosition, 1);
                    Vec3 diff = connection.calculatePathDiff(mc.f_91073_.m_8055_(connectingFrom.pos()), connectingFrom);
                    if (bestDistance < diff.m_82556_()) continue;
                    bestDistance = diff.m_82556_();
                    bestPosition = panelPosition;
                }
                ExtraPackets.getChannel().sendToServer((Object)new FactoryPanelConnectionPacket(bestPosition, connectingFrom, false));
                mc.f_91074_.m_5661_((Component)Lang.translate((String)"factory_panel.link_connected", (Object[])new Object[]{blockEntity.m_58900_().m_60734_().m_49954_()}).style(ChatFormatting.GREEN).component(), true);
                connectingFrom = null;
                connectingFromBox = null;
                mc.f_91074_.m_9236_().m_245747_(mc.f_91074_.m_20183_(), SoundEvents.f_144048_, SoundSource.BLOCKS, 0.5f, 0.5f, false);
                return true;
            }
            if (!(blockEntity instanceof FactoryPanelBlockEntity)) {
                missed = true;
            }
        }
        if (!mc.f_91074_.m_6144_() && !missed) {
            return false;
        }
        connectingFrom = null;
        connectingFromBox = null;
        mc.f_91074_.m_5661_((Component)Lang.translate((String)"factory_panel.connection_aborted", (Object[])new Object[0]).component(), true);
        return true;
    }

    public static void startRelocating(FactoryPanelBehaviour behaviour) {
        FactoryPanelConnectionHandler.startConnection(behaviour);
        relocating = true;
    }

    public static void startConnection(FactoryPanelBehaviour behaviour) {
        relocating = false;
        connectingFrom = behaviour.getPanelPosition();
        connectingFromBox = FactoryPanelConnectionHandler.getBB(behaviour.blockEntity.m_58900_(), connectingFrom);
    }

    public static AABB getBB(BlockState blockState, FactoryPanelPosition factoryPanelPosition) {
        Vec3 location = FactoryPanelSlotPositioning.getCenterOfSlot(blockState, factoryPanelPosition.slot()).m_82549_(Vec3.m_82528_((Vec3i)factoryPanelPosition.pos()));
        Vec3 plane = VecHelper.axisAlingedPlaneOf((Direction)FactoryPanelBlock.connectedDirection(blockState));
        return new AABB(location, location).m_82377_(plane.f_82479_ * 3.0 / 16.0, plane.f_82480_ * 3.0 / 16.0, plane.f_82481_ * 3.0 / 16.0);
    }
}

