/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.factoryBoard;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.foundation.model.BakedModelWrapperWithData;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelBehaviour;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelBlock;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelPosition;
import moe.paring.createlogisticsbackport.registry.ExtraPartialModels;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class FactoryPanelModel
extends BakedModelWrapperWithData {
    private static final ModelProperty<FactoryPanelModelData> PANEL_PROPERTY = new ModelProperty();

    public FactoryPanelModel(BakedModel originalModel) {
        super(originalModel);
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        FactoryPanelModelData data = new FactoryPanelModelData();
        for (FactoryPanelBlock.PanelSlot slot : FactoryPanelBlock.PanelSlot.values()) {
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviour.at(world, new FactoryPanelPosition(pos, slot));
            if (behaviour == null) continue;
            data.states.put(slot, behaviour.count == 0 ? FactoryPanelBlock.PanelState.PASSIVE : FactoryPanelBlock.PanelState.ACTIVE);
            data.type = behaviour.panelBE().restocker ? FactoryPanelBlock.PanelType.PACKAGER : FactoryPanelBlock.PanelType.NETWORK;
        }
        data.ponder = world instanceof PonderWorld;
        return builder.with(PANEL_PROPERTY, (Object)data);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType renderType) {
        if (side != null || !data.has(PANEL_PROPERTY)) {
            return Collections.emptyList();
        }
        FactoryPanelModelData modelData = (FactoryPanelModelData)data.get(PANEL_PROPERTY);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(super.getQuads(state, null, rand, data, renderType));
        for (FactoryPanelBlock.PanelSlot panelSlot : FactoryPanelBlock.PanelSlot.values()) {
            if (!modelData.states.containsKey((Object)panelSlot)) continue;
            this.addPanel(quads, state, panelSlot, modelData.type, modelData.states.get((Object)panelSlot), rand, data, renderType, modelData.ponder);
        }
        return quads;
    }

    public void addPanel(List<BakedQuad> quads, BlockState state, FactoryPanelBlock.PanelSlot slot, FactoryPanelBlock.PanelType type, FactoryPanelBlock.PanelState panelState, RandomSource rand, ModelData data, RenderType renderType, boolean ponder) {
        PartialModel factoryPanel = panelState == FactoryPanelBlock.PanelState.PASSIVE ? (type == FactoryPanelBlock.PanelType.NETWORK ? ExtraPartialModels.FACTORY_PANEL : ExtraPartialModels.FACTORY_PANEL_RESTOCKER) : (type == FactoryPanelBlock.PanelType.NETWORK ? ExtraPartialModels.FACTORY_PANEL_WITH_BULB : ExtraPartialModels.FACTORY_PANEL_RESTOCKER_WITH_BULB);
        List quadsToAdd = factoryPanel.get().getQuads(state, null, rand, data, RenderType.m_110451_());
        float xRot = 57.295776f * FactoryPanelBlock.getXRot(state);
        float yRot = 57.295776f * FactoryPanelBlock.getYRot(state);
        for (BakedQuad bakedQuad : quadsToAdd) {
            int[] vertices = bakedQuad.m_111303_();
            int[] transformedVertices = Arrays.copyOf(vertices, vertices.length);
            Vec3 quadNormal = Vec3.m_82528_((Vec3i)bakedQuad.m_111306_().m_122436_());
            quadNormal = VecHelper.rotate((Vec3)quadNormal, (double)180.0, (Direction.Axis)Direction.Axis.Y);
            quadNormal = VecHelper.rotate((Vec3)quadNormal, (double)(xRot + 90.0f), (Direction.Axis)Direction.Axis.X);
            quadNormal = VecHelper.rotate((Vec3)quadNormal, (double)yRot, (Direction.Axis)Direction.Axis.Y);
            for (int i = 0; i < vertices.length / BakedQuadHelper.VERTEX_STRIDE; ++i) {
                Vec3 vertex = BakedQuadHelper.getXYZ((int[])vertices, (int)i);
                vertex = vertex.m_82520_((double)slot.xOffset * 0.5, 0.0, (double)slot.yOffset * 0.5);
                vertex = VecHelper.rotateCentered((Vec3)vertex, (double)180.0, (Direction.Axis)Direction.Axis.Y);
                vertex = VecHelper.rotateCentered((Vec3)vertex, (double)(xRot + 90.0f), (Direction.Axis)Direction.Axis.X);
                vertex = VecHelper.rotateCentered((Vec3)vertex, (double)yRot, (Direction.Axis)Direction.Axis.Y);
                BakedQuadHelper.setXYZ((int[])transformedVertices, (int)i, (Vec3)vertex);
            }
            Direction newNormal = Direction.m_122378_((int)((int)Math.round(quadNormal.f_82479_)), (int)((int)Math.round(quadNormal.f_82480_)), (int)((int)Math.round(quadNormal.f_82481_)));
            quads.add(new BakedQuad(transformedVertices, bakedQuad.m_111305_(), newNormal, bakedQuad.m_173410_(), !ponder && bakedQuad.m_111307_()));
        }
    }

    private static class FactoryPanelModelData {
        public FactoryPanelBlock.PanelType type;
        public EnumMap<FactoryPanelBlock.PanelSlot, FactoryPanelBlock.PanelState> states = new EnumMap(FactoryPanelBlock.PanelSlot.class);
        private boolean ponder;

        private FactoryPanelModelData() {
        }
    }
}

