/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.factoryBoard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import moe.paring.createlogisticsbackport.content.logistics.AddressEditBox;
import moe.paring.createlogisticsbackport.content.logistics.BigItemStack;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageStyles;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelBehaviour;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelConfigurationPacket;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelConnection;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelPosition;
import moe.paring.createlogisticsbackport.polyfill.NewIconButton;
import moe.paring.createlogisticsbackport.registry.ExtraBlocks;
import moe.paring.createlogisticsbackport.registry.ExtraGuiTextures;
import moe.paring.createlogisticsbackport.registry.ExtraIcons;
import moe.paring.createlogisticsbackport.registry.ExtraPackets;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.items.ItemHandlerHelper;

public class FactoryPanelScreen
extends AbstractSimiScreen {
    private EditBox addressBox;
    private NewIconButton confirmButton;
    private NewIconButton deleteButton;
    private NewIconButton newInputButton;
    private NewIconButton relocateButton;
    private NewIconButton activateCraftingButton;
    private ScrollInput promiseExpiration;
    private FactoryPanelBehaviour behaviour;
    private boolean restocker;
    private boolean sendReset;
    private boolean sendRedstoneReset;
    private BigItemStack outputConfig;
    private List<BigItemStack> inputConfig;
    private List<FactoryPanelConnection> connections;
    private CraftingRecipe availableCraftingRecipe;
    private boolean craftingActive;
    private List<BigItemStack> craftingIngredients;

    public FactoryPanelScreen(FactoryPanelBehaviour behaviour) {
        this.behaviour = behaviour;
        this.f_96541_ = Minecraft.m_91087_();
        this.restocker = behaviour.panelBE().restocker;
        this.availableCraftingRecipe = null;
        this.craftingActive = !behaviour.activeCraftingArrangement.isEmpty();
        this.updateConfigs();
    }

    private void updateConfigs() {
        this.connections = new ArrayList<FactoryPanelConnection>(this.behaviour.targetedBy.values());
        this.outputConfig = new BigItemStack(this.behaviour.getFilter(), this.behaviour.recipeOutput);
        this.inputConfig = this.connections.stream().map(c -> {
            FactoryPanelBehaviour b = FactoryPanelBehaviour.at((BlockAndTintGetter)this.f_96541_.f_91073_, c.from);
            return b == null ? new BigItemStack(ItemStack.f_41583_, 0) : new BigItemStack(b.getFilter(), c.amount);
        }).toList();
        this.searchForCraftingRecipe();
        if (this.availableCraftingRecipe == null) {
            this.craftingActive = false;
            return;
        }
        this.craftingIngredients = FactoryPanelScreen.convertRecipeToPackageOrderContext(this.availableCraftingRecipe, this.inputConfig, false);
    }

    public static List<BigItemStack> convertRecipeToPackageOrderContext(CraftingRecipe availableCraftingRecipe, List<BigItemStack> inputs, boolean respectAmounts) {
        ArrayList<BigItemStack> craftingIngredients = new ArrayList<BigItemStack>();
        BigItemStack emptyIngredient = new BigItemStack(ItemStack.f_41583_, 1);
        NonNullList ingredients = availableCraftingRecipe.m_7527_();
        List<BigItemStack> mutableInputs = BigItemStack.duplicateWrappers(inputs);
        int width = Math.min(3, ingredients.size());
        int height = Math.min(3, ingredients.size() / 3 + 1);
        if (availableCraftingRecipe instanceof IShapedRecipe) {
            IShapedRecipe shaped = (IShapedRecipe)availableCraftingRecipe;
            width = shaped.getRecipeWidth();
            height = shaped.getRecipeHeight();
        }
        if (height == 1) {
            for (int i = 0; i < 3; ++i) {
                craftingIngredients.add(emptyIngredient);
            }
        }
        if (width == 1) {
            craftingIngredients.add(emptyIngredient);
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            BigItemStack craftingIngredient = emptyIngredient;
            if (!ingredient.m_43947_()) {
                for (BigItemStack bigItemStack : mutableInputs) {
                    if (bigItemStack.count <= 0 || !ingredient.test(bigItemStack.stack)) continue;
                    craftingIngredient = new BigItemStack(bigItemStack.stack, 1);
                    if (!respectAmounts) break;
                    --bigItemStack.count;
                    break;
                }
            }
            craftingIngredients.add(craftingIngredient);
            if (width >= 3 || (i + 1) % width != 0) continue;
            for (int j = 0; j < 3 - width; ++j) {
                if (craftingIngredients.size() >= 9) continue;
                craftingIngredients.add(emptyIngredient);
            }
        }
        while (craftingIngredients.size() < 9) {
            craftingIngredients.add(emptyIngredient);
        }
        return craftingIngredients;
    }

    protected void m_7856_() {
        int sizeX = ExtraGuiTextures.FACTORY_GAUGE_BOTTOM.getWidth();
        int sizeY = (this.restocker ? ExtraGuiTextures.FACTORY_GAUGE_RESTOCK : ExtraGuiTextures.FACTORY_GAUGE_RECIPE).getHeight() + ExtraGuiTextures.FACTORY_GAUGE_BOTTOM.getHeight();
        this.setWindowSize(sizeX, sizeY);
        super.m_7856_();
        this.m_169413_();
        int x = this.guiLeft;
        int y = this.guiTop;
        if (this.addressBox == null) {
            String frogAddress = this.behaviour.getFrogAddress();
            this.addressBox = new AddressEditBox((Screen)this, (Font)new NoShadowFontWrapper(this.f_96547_), x + 36, y + this.windowHeight - 51, 108, 10, false, frogAddress);
            this.addressBox.m_94144_(this.behaviour.recipeAddress);
            this.addressBox.m_94202_(0x555555);
        }
        this.addressBox.m_252865_(x + 36);
        this.addressBox.m_253211_(y + this.windowHeight - 51);
        this.m_142416_((GuiEventListener)this.addressBox);
        this.confirmButton = new NewIconButton(x + sizeX - 33, y + sizeY - 25, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.f_96541_.m_91152_(null));
        this.confirmButton.setToolTip((Component)Lang.translate((String)"gui.factory_panel.save_and_close", (Object[])new Object[0]).component());
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.deleteButton = new NewIconButton(x + sizeX - 55, y + sizeY - 25, (ScreenElement)AllIcons.I_TRASH);
        this.deleteButton.withCallback(() -> {
            this.sendReset = true;
            this.f_96541_.m_91152_(null);
        });
        this.deleteButton.setToolTip((Component)Lang.translate((String)"gui.factory_panel.reset", (Object[])new Object[0]).component());
        this.m_142416_((GuiEventListener)this.deleteButton);
        this.promiseExpiration = new ScrollInput(x + 97, y + this.windowHeight - 24, 28, 16).withRange(-1, 31).titled(Lang.translate((String)"gui.factory_panel.promises_expire_title", (Object[])new Object[0]).component());
        this.promiseExpiration.setState(this.behaviour.promiseClearingInterval);
        this.m_142416_((GuiEventListener)this.promiseExpiration);
        this.newInputButton = new NewIconButton(x + 31, y + 47, (ScreenElement)AllIcons.I_ADD);
        this.newInputButton.withCallback(() -> {
            FactoryPanelConnectionHandler.startConnection(this.behaviour);
            this.f_96541_.m_91152_(null);
        });
        this.newInputButton.setToolTip((Component)Lang.translate((String)"gui.factory_panel.connect_input", (Object[])new Object[0]).component());
        this.relocateButton = new NewIconButton(x + 31, y + 67, ExtraIcons.I_MOVE_GAUGE);
        this.relocateButton.withCallback(() -> {
            FactoryPanelConnectionHandler.startRelocating(this.behaviour);
            this.f_96541_.m_91152_(null);
        });
        this.relocateButton.setToolTip((Component)Lang.translate((String)"gui.factory_panel.relocate", (Object[])new Object[0]).component());
        if (!this.restocker) {
            this.m_142416_((GuiEventListener)this.newInputButton);
            this.m_142416_((GuiEventListener)this.relocateButton);
        }
        this.activateCraftingButton = null;
        if (this.availableCraftingRecipe != null) {
            this.activateCraftingButton = new NewIconButton(x + 31, y + 27, (ScreenElement)AllIcons.I_3x3);
            this.activateCraftingButton.withCallback(() -> {
                this.craftingActive = !this.craftingActive;
                this.m_7856_();
                if (this.craftingActive) {
                    this.outputConfig.count = this.availableCraftingRecipe.m_8043_(this.f_96541_.f_91073_.m_9598_()).m_41613_();
                }
            });
            this.activateCraftingButton.setToolTip((Component)Lang.translate((String)"gui.factory_panel.activate_crafting", (Object[])new Object[0]).component());
            this.m_142416_((GuiEventListener)this.activateCraftingButton);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.inputConfig.size() != this.behaviour.targetedBy.size()) {
            this.updateConfigs();
            this.m_7856_();
        }
        if (this.activateCraftingButton != null) {
            this.activateCraftingButton.green = this.craftingActive;
        }
        this.addressBox.m_94120_();
        this.promiseExpiration.titled(Lang.translate((String)(this.promiseExpiration.getState() == -1 ? "gui.factory_panel.promises_do_not_expire" : "gui.factory_panel.promises_expire_title"), (Object[])new Object[0]).component());
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int state;
        ExtraGuiTextures bg;
        int x = this.guiLeft;
        int y = this.guiTop;
        ExtraGuiTextures extraGuiTextures = bg = this.restocker ? ExtraGuiTextures.FACTORY_GAUGE_RESTOCK : ExtraGuiTextures.FACTORY_GAUGE_RECIPE;
        if (this.restocker) {
            ExtraGuiTextures.FACTORY_GAUGE_RECIPE.render(graphics, x, y - 16);
        }
        bg.render(graphics, x, y);
        ExtraGuiTextures.FACTORY_GAUGE_BOTTOM.render(graphics, x, y + bg.getHeight());
        y = this.guiTop;
        int slot = 0;
        if (this.craftingActive) {
            for (BigItemStack itemStack : this.craftingIngredients) {
                this.renderInputItem(graphics, slot++, itemStack, mouseX, mouseY);
            }
        } else {
            for (BigItemStack itemStack : this.inputConfig) {
                this.renderInputItem(graphics, slot++, itemStack, mouseX, mouseY);
            }
            if (this.inputConfig.isEmpty()) {
                int inputX = this.guiLeft + (this.restocker ? 88 : 68 + slot % 3 * 20);
                int inputY = this.guiTop + (this.restocker ? 12 : 28) + slot / 3 * 20;
                if (!this.restocker && mouseY > inputY && mouseY < inputY + 60 && mouseX > inputX && mouseX < inputX + 60) {
                    graphics.m_280666_(this.f_96547_, List.of(Lang.translate((String)"gui.factory_panel.unconfigured_input", (Object[])new Object[0]).color(5476833).component(), Lang.translate((String)"gui.factory_panel.unconfigured_input_tip", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), Lang.translate((String)"gui.factory_panel.unconfigured_input_tip_1", (Object[])new Object[0]).style(ChatFormatting.GRAY).component()), mouseX, mouseY);
                }
            }
        }
        if (this.restocker) {
            this.renderInputItem(graphics, slot, new BigItemStack(this.behaviour.getFilter(), 1), mouseX, mouseY);
        }
        if (!this.restocker) {
            int outputX = x + 160;
            int outputY = y + 48;
            graphics.m_280480_(this.outputConfig.stack, outputX, outputY);
            graphics.m_280302_(this.f_96547_, this.behaviour.getFilter(), outputX, outputY, "" + this.outputConfig.count);
            if (mouseX >= outputX - 1 && mouseX < outputX - 1 + 18 && mouseY >= outputY - 1 && mouseY < outputY - 1 + 18) {
                MutableComponent c1 = Lang.translate((String)"gui.factory_panel.expected_output", (Object[])new Object[]{Lang.itemName((ItemStack)this.outputConfig.stack).add(Lang.text((String)(" x" + this.outputConfig.count))).string()}).color(5476833).component();
                MutableComponent c2 = Lang.translate((String)"gui.factory_panel.expected_output_tip", (Object[])new Object[0]).style(ChatFormatting.GRAY).component();
                MutableComponent c3 = Lang.translate((String)"gui.factory_panel.expected_output_tip_1", (Object[])new Object[0]).style(ChatFormatting.GRAY).component();
                MutableComponent c4 = Lang.translate((String)"gui.factory_panel.expected_output_tip_2", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component();
                graphics.m_280666_(this.f_96547_, this.craftingActive ? List.of(c1, c2, c3) : List.of(c1, c2, c3, c4), mouseX, mouseY);
            }
        }
        PoseStack ms = graphics.m_280168_();
        ms.m_85836_();
        ms.m_252880_(0.0f, 0.0f, 10.0f);
        if (this.addressBox.m_274382_() && !this.addressBox.m_93696_()) {
            this.showAddressBoxTooltip(graphics, mouseX, mouseY);
        }
        MutableComponent title = Lang.translate((String)(this.restocker ? "gui.factory_panel.title_as_restocker" : "gui.factory_panel.title_as_recipe"), (Object[])new Object[0]).component();
        graphics.m_280614_(this.f_96547_, (Component)title, x + 97 - this.f_96547_.m_92852_((FormattedText)title) / 2, y + (this.restocker ? -12 : 4), 4013128, false);
        int previewY = this.restocker ? 0 : 60;
        ms.m_85836_();
        ms.m_252880_(0.0f, (float)previewY, 0.0f);
        GuiGameElement.of((ItemStack)ExtraBlocks.FACTORY_GAUGE.asStack()).scale(4.0).at(0.0f, 0.0f, -200.0f).render(graphics, x + 195, y + 55);
        if (!this.behaviour.getFilter().m_41619_()) {
            GuiGameElement.of((ItemStack)this.behaviour.getFilter()).scale(1.625).at(0.0f, 0.0f, 100.0f).render(graphics, x + 214, y + 68);
        }
        ms.m_85849_();
        if (!this.behaviour.targetedByLinks.isEmpty()) {
            ItemStack asStack = AllBlocks.REDSTONE_LINK.asStack();
            int itemX = x + 9;
            int itemY = y + this.windowHeight - 24;
            ExtraGuiTextures.FROGPORT_SLOT.render(graphics, itemX - 1, itemY - 1);
            graphics.m_280480_(asStack, itemX, itemY);
            if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
                List<MutableComponent> linkTip = List.of(Lang.translate((String)"gui.factory_panel.has_link_connections", (Object[])new Object[0]).color(5476833).component(), Lang.translate((String)"gui.factory_panel.left_click_disconnect", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component());
                graphics.m_280666_(this.f_96547_, linkTip, mouseX, mouseY);
            }
        }
        graphics.m_280614_(this.f_96547_, (Component)Lang.text((String)((state = this.promiseExpiration.getState()) == -1 ? " /" : (state == 0 ? "30s" : state + "m"))).component(), this.promiseExpiration.m_252754_() + 3, this.promiseExpiration.m_252907_() + 4, -1118482, true);
        ItemStack asStack = PackageStyles.getDefaultBox();
        int itemX = x + 68;
        int itemY = y + this.windowHeight - 24;
        graphics.m_280480_(asStack, itemX, itemY);
        int promised = this.behaviour.getPromised();
        graphics.m_280302_(this.f_96547_, asStack, itemX, itemY, "" + promised);
        if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
            List<Object> promiseTip = List.of();
            promiseTip = promised == 0 ? List.of(Lang.translate((String)"gui.factory_panel.no_open_promises", (Object[])new Object[0]).color(5476833).component(), Lang.translate((String)(this.restocker ? "gui.factory_panel.restocker_promises_tip" : "gui.factory_panel.recipe_promises_tip"), (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), Lang.translate((String)(this.restocker ? "gui.factory_panel.restocker_promises_tip_1" : "gui.factory_panel.recipe_promises_tip_1"), (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), Lang.translate((String)"gui.factory_panel.promise_prevents_oversending", (Object[])new Object[0]).style(ChatFormatting.GRAY).component()) : List.of(Lang.translate((String)"gui.factory_panel.promised_items", (Object[])new Object[0]).color(5476833).component(), Lang.text((String)(this.behaviour.getFilter().m_41786_().getString() + " x" + promised)).component(), Lang.translate((String)"gui.factory_panel.left_click_reset", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component());
            graphics.m_280666_(this.f_96547_, promiseTip, mouseX, mouseY);
        }
        ms.m_85849_();
    }

    private void renderInputItem(GuiGraphics graphics, int slot, BigItemStack itemStack, int mouseX, int mouseY) {
        int inputX = this.guiLeft + (this.restocker ? 88 : 68 + slot % 3 * 20);
        int inputY = this.guiTop + (this.restocker ? 12 : 28) + slot / 3 * 20;
        graphics.m_280480_(itemStack.stack, inputX, inputY);
        if (!(this.craftingActive || this.restocker || itemStack.stack.m_41619_())) {
            graphics.m_280302_(this.f_96547_, itemStack.stack, inputX, inputY, "" + itemStack.count);
        }
        if (mouseX < inputX - 2 || mouseX >= inputX - 2 + 20 || mouseY < inputY - 2 || mouseY >= inputY - 2 + 20) {
            return;
        }
        if (this.craftingActive) {
            graphics.m_280666_(this.f_96547_, List.of(Lang.translate((String)"gui.factory_panel.crafting_input", (Object[])new Object[0]).color(5476833).component(), Lang.translate((String)"gui.factory_panel.crafting_input_tip", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), Lang.translate((String)"gui.factory_panel.crafting_input_tip_1", (Object[])new Object[0]).style(ChatFormatting.GRAY).component()), mouseX, mouseY);
            return;
        }
        if (itemStack.stack.m_41619_()) {
            graphics.m_280666_(this.f_96547_, List.of(Lang.translate((String)"gui.factory_panel.empty_panel", (Object[])new Object[0]).color(5476833).component(), Lang.translate((String)"gui.factory_panel.left_click_disconnect", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
            return;
        }
        if (this.restocker) {
            graphics.m_280666_(this.f_96547_, List.of(Lang.translate((String)"gui.factory_panel.sending_item", (Object[])new Object[]{Lang.itemName((ItemStack)itemStack.stack).string()}).color(5476833).component(), Lang.translate((String)"gui.factory_panel.sending_item_tip", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), Lang.translate((String)"gui.factory_panel.sending_item_tip_1", (Object[])new Object[0]).style(ChatFormatting.GRAY).component()), mouseX, mouseY);
            return;
        }
        graphics.m_280666_(this.f_96547_, List.of(Lang.translate((String)"gui.factory_panel.sending_item", (Object[])new Object[]{Lang.itemName((ItemStack)itemStack.stack).add(Lang.text((String)(" x" + itemStack.count))).string()}).color(5476833).component(), Lang.translate((String)"gui.factory_panel.scroll_to_change_amount", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component(), Lang.translate((String)"gui.factory_panel.left_click_disconnect", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
    }

    private void showAddressBoxTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.addressBox.m_94155_().isBlank()) {
            if (this.restocker) {
                graphics.m_280666_(this.f_96547_, List.of(Lang.translate((String)"gui.factory_panel.restocker_address", (Object[])new Object[0]).color(5476833).component(), Lang.translate((String)"gui.factory_panel.restocker_address_tip", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), Lang.translate((String)"gui.factory_panel.restocker_address_tip_1", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), Lang.translate((String)"gui.schedule.lmb_edit", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
            } else {
                graphics.m_280666_(this.f_96547_, List.of(Lang.translate((String)"gui.factory_panel.recipe_address", (Object[])new Object[0]).color(5476833).component(), Lang.translate((String)"gui.factory_panel.recipe_address_tip", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), Lang.translate((String)"gui.factory_panel.recipe_address_tip_1", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), Lang.translate((String)"gui.schedule.lmb_edit", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
            }
        } else {
            graphics.m_280666_(this.f_96547_, List.of(Lang.translate((String)(this.restocker ? "gui.factory_panel.restocker_address_given" : "gui.factory_panel.recipe_address_given"), (Object[])new Object[0]).color(5476833).component(), Lang.text((String)("'" + this.addressBox.m_94155_() + "'")).style(ChatFormatting.GRAY).component()), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int pButton) {
        if (this.m_7222_() != null && !this.m_7222_().m_5953_(mouseX, mouseY)) {
            this.m_7522_(null);
        }
        int x = this.guiLeft;
        int y = this.guiTop;
        if (!this.craftingActive) {
            for (int i = 0; i < this.connections.size(); ++i) {
                int inputX = x + 68 + i % 3 * 20;
                int inputY = y + 28 + i / 3 * 20;
                if (!(mouseX >= (double)inputX) || !(mouseX < (double)(inputX + 16)) || !(mouseY >= (double)inputY) || !(mouseY < (double)(inputY + 16))) continue;
                this.sendIt(this.connections.get((int)i).from, false);
                this.playButtonSound();
                return true;
            }
        }
        int itemX = x + 68;
        int itemY = y + this.windowHeight - 24;
        if (mouseX >= (double)itemX && mouseX < (double)(itemX + 16) && mouseY >= (double)itemY && mouseY < (double)(itemY + 16)) {
            this.sendIt(null, true);
            this.playButtonSound();
            return true;
        }
        itemX = x + 9;
        itemY = y + this.windowHeight - 24;
        if (mouseX >= (double)itemX && mouseX < (double)(itemX + 16) && mouseY >= (double)itemY && mouseY < (double)(itemY + 16)) {
            this.sendRedstoneReset = true;
            this.sendIt(null, false);
            this.playButtonSound();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, pButton);
    }

    public void playButtonSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f, (float)0.25f));
    }

    public boolean m_6050_(double mouseX, double mouseY, double pDelta) {
        int x = this.guiLeft;
        int y = this.guiTop;
        if (this.addressBox.m_6050_(mouseX, mouseY, pDelta)) {
            return true;
        }
        if (this.craftingActive) {
            return super.m_6050_(mouseX, mouseY, pDelta);
        }
        for (int i = 0; i < this.inputConfig.size(); ++i) {
            int inputX = x + 68 + i % 3 * 20;
            int inputY = y + 26 + i / 3 * 20;
            if (!(mouseX >= (double)inputX) || !(mouseX < (double)(inputX + 16)) || !(mouseY >= (double)inputY) || !(mouseY < (double)(inputY + 16))) continue;
            BigItemStack itemStack = this.inputConfig.get(i);
            if (itemStack.stack.m_41619_()) {
                return true;
            }
            itemStack.count = Mth.m_14045_((int)((int)((double)itemStack.count + Math.signum(pDelta) * (double)(FactoryPanelScreen.m_96638_() ? 10 : 1))), (int)1, (int)64);
            return true;
        }
        if (!this.restocker) {
            int outputX = x + 160;
            int outputY = y + 48;
            if (mouseX >= (double)outputX && mouseX < (double)(outputX + 16) && mouseY >= (double)outputY && mouseY < (double)(outputY + 16)) {
                BigItemStack itemStack = this.outputConfig;
                itemStack.count = Mth.m_14045_((int)((int)((double)itemStack.count + Math.signum(pDelta) * (double)(FactoryPanelScreen.m_96638_() ? 10 : 1))), (int)1, (int)64);
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, pDelta);
    }

    public void m_7861_() {
        this.sendIt(null, false);
        super.m_7861_();
    }

    private void sendIt(@Nullable FactoryPanelPosition toRemove, boolean clearPromises) {
        HashMap<FactoryPanelPosition, Integer> inputs = new HashMap<FactoryPanelPosition, Integer>();
        if (this.inputConfig.size() == this.connections.size()) {
            for (int i = 0; i < this.inputConfig.size(); ++i) {
                BigItemStack stackInConfig = this.inputConfig.get(i);
                inputs.put(this.connections.get((int)i).from, this.craftingActive ? (int)this.craftingIngredients.stream().filter(b -> !b.stack.m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)b.stack, (ItemStack)stackInConfig.stack)).count() : stackInConfig.count);
            }
        }
        List<ItemStack> craftingArrangement = this.craftingActive ? this.craftingIngredients.stream().map(b -> b.stack).toList() : List.of();
        FactoryPanelPosition pos = this.behaviour.getPanelPosition();
        int promiseExp = this.promiseExpiration.getState();
        String address = this.addressBox.m_94155_();
        FactoryPanelConfigurationPacket packet = new FactoryPanelConfigurationPacket(pos, address, inputs, craftingArrangement, this.outputConfig.count, promiseExp, toRemove, clearPromises, this.sendReset, this.sendRedstoneReset);
        ExtraPackets.getChannel().sendToServer((Object)packet);
    }

    private void searchForCraftingRecipe() {
        ItemStack output = this.outputConfig.stack;
        if (output.m_41619_()) {
            return;
        }
        if (this.behaviour.targetedBy.isEmpty()) {
            return;
        }
        Set itemsToUse = this.inputConfig.stream().map(b -> b.stack).filter(i -> !i.m_41619_()).map(i -> i.m_41720_()).collect(Collectors.toSet());
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        this.availableCraftingRecipe = level.m_7465_().m_44013_(RecipeType.f_44107_).parallelStream().filter(r -> output.m_41720_() == r.m_8043_(level.m_9598_()).m_41720_()).filter(r -> {
            if (AllRecipeTypes.shouldIgnoreInAutomation((Recipe)r)) {
                return false;
            }
            HashSet<Item> itemsUsed = new HashSet<Item>();
            for (Ingredient ingredient : r.m_7527_()) {
                if (ingredient.m_43947_()) continue;
                boolean available = false;
                for (BigItemStack bis : this.inputConfig) {
                    if (bis.stack.m_41619_() || !ingredient.test(bis.stack)) continue;
                    available = true;
                    itemsUsed.add(bis.stack.m_41720_());
                    break;
                }
                if (available) continue;
                return false;
            }
            return itemsUsed.size() >= itemsToUse.size();
        }).findAny().orElse(null);
    }
}

