/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.packagePort;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import moe.paring.createlogisticsbackport.config.ExtraConfigs;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.PackagePortBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.PackagePortTarget;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.PackagePortTargetSelectionHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PackagePortPlacementPacket
extends SimplePacketBase {
    private PackagePortTarget target;
    private BlockPos pos;

    public PackagePortPlacementPacket(PackagePortTarget target, BlockPos pos) {
        this.target = target;
        this.pos = pos;
    }

    public PackagePortPlacementPacket(FriendlyByteBuf buffer) {
        this.target = PackagePortTarget.read(buffer.m_130260_());
        this.pos = buffer.m_130135_();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.target.write());
        buffer.m_130064_(this.pos);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level world = player.m_9236_();
            if (world == null || !world.m_46749_(this.pos)) {
                return;
            }
            BlockEntity blockEntity = world.m_7702_(this.pos);
            if (!(blockEntity instanceof PackagePortBlockEntity)) {
                return;
            }
            PackagePortBlockEntity ppbe = (PackagePortBlockEntity)blockEntity;
            if (!this.target.canSupport((BlockEntity)ppbe)) {
                return;
            }
            Vec3 targetLocation = this.target.getExactTargetLocation(ppbe, (LevelAccessor)world, this.pos);
            if (targetLocation == Vec3.f_82478_ || !targetLocation.m_82509_((Position)Vec3.m_82539_((Vec3i)this.pos), (double)((Integer)ExtraConfigs.server().logistics.packagePortRange.get() + 2))) {
                return;
            }
            this.target.setup(ppbe, (LevelAccessor)world, this.pos);
            ppbe.target = this.target;
            ppbe.notifyUpdate();
            ppbe.use((Player)player);
        });
        return true;
    }

    public static class ClientBoundRequest
    extends SimplePacketBase {
        BlockPos pos;

        public ClientBoundRequest(BlockPos pos) {
            this.pos = pos;
        }

        public ClientBoundRequest(FriendlyByteBuf buffer) {
            this.pos = buffer.m_130135_();
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130064_(this.pos);
        }

        public boolean handle(NetworkEvent.Context context) {
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PackagePortTargetSelectionHandler.flushSettings(this.pos)));
            return true;
        }
    }
}

