/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.packagePort;

import com.simibubi.create.AllTags;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import moe.paring.createlogisticsbackport.config.ExtraConfigs;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.PackagePortBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.PackagePortPlacementPacket;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.PackagePortTarget;
import moe.paring.createlogisticsbackport.registry.ExtraBlocks;
import moe.paring.createlogisticsbackport.registry.ExtraItemTags;
import moe.paring.createlogisticsbackport.registry.ExtraPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PackagePortTargetSelectionHandler {
    public static PackagePortTarget activePackageTarget;
    public static Vec3 exactPositionOfTarget;
    public static boolean isPostbox;

    public static void flushSettings(BlockPos pos) {
        if (activePackageTarget == null) {
            Lang.translate((String)"gui.package_port.not_targeting_anything", (Object[])new Object[0]).sendStatus((Player)Minecraft.m_91087_().f_91074_);
            return;
        }
        if (PackagePortTargetSelectionHandler.validateDiff(exactPositionOfTarget, pos) == null) {
            PackagePortTargetSelectionHandler.activePackageTarget.relativePos = PackagePortTargetSelectionHandler.activePackageTarget.relativePos.m_121996_((Vec3i)pos);
            ExtraPackets.getChannel().sendToServer((Object)new PackagePortPlacementPacket(activePackageTarget, pos));
        }
        activePackageTarget = null;
        isPostbox = false;
    }

    public static boolean onUse() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult hitResult = mc.f_91077_;
        ItemStack mainHandItem = mc.f_91074_.m_21205_();
        if (hitResult == null || hitResult.m_6662_() == HitResult.Type.MISS) {
            return false;
        }
        if (!(hitResult instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult bhr = (BlockHitResult)hitResult;
        BlockPos pos = bhr.m_82425_();
        BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
        if (!(blockEntity instanceof StationBlockEntity)) {
            return false;
        }
        StationBlockEntity sbe = (StationBlockEntity)blockEntity;
        if (sbe.edgePoint == null) {
            return false;
        }
        if (!ExtraItemTags.POSTBOXES.matches(mainHandItem)) {
            return false;
        }
        exactPositionOfTarget = Vec3.m_82512_((Vec3i)pos);
        activePackageTarget = new PackagePortTarget.TrainStationFrogportTarget(pos);
        isPostbox = true;
        return true;
    }

    public static void tick() {
        String validateDiff;
        HitResult objectMouseOver;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        boolean isPostbox = ExtraItemTags.POSTBOXES.matches(player.m_21205_());
        boolean isWrench = AllTags.AllItemTags.WRENCH.matches(player.m_21205_());
        if (!isWrench) {
            if (activePackageTarget == null) {
                return;
            }
            if (!ExtraBlocks.PACKAGE_FROGPORT.isIn(player.m_21205_()) && !isPostbox) {
                return;
            }
        }
        if (!((objectMouseOver = mc.f_91077_) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)objectMouseOver;
        if (isWrench) {
            if (blockRayTraceResult.m_6662_() == HitResult.Type.MISS) {
                return;
            }
            BlockPos pos = blockRayTraceResult.m_82425_();
            BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
            if (!(blockEntity instanceof PackagePortBlockEntity)) {
                return;
            }
            PackagePortBlockEntity ppbe = (PackagePortBlockEntity)blockEntity;
            if (ppbe.target == null) {
                return;
            }
            Vec3 source = Vec3.m_82539_((Vec3i)pos);
            Vec3 target = ppbe.target.getExactTargetLocation(ppbe, (LevelAccessor)mc.f_91073_, pos);
            if (target == Vec3.f_82478_) {
                return;
            }
            Color color = new Color(10411635);
            PackagePortTargetSelectionHandler.animateConnection(mc, source, target, color);
            CreateClient.OUTLINER.chaseAABB((Object)"ChainPointSelected", new AABB(target, target)).colored(color).lineWidth(0.2f).disableLineNormals();
            return;
        }
        Vec3 target = exactPositionOfTarget;
        if (blockRayTraceResult.m_6662_() == HitResult.Type.MISS) {
            CreateClient.OUTLINER.chaseAABB((Object)"ChainPointSelected", new AABB(target, target)).colored(10411635).lineWidth(0.2f).disableLineNormals();
            return;
        }
        BlockPos pos = blockRayTraceResult.m_82425_();
        if (!mc.f_91073_.m_8055_(pos).m_247087_()) {
            pos = pos.m_121945_(blockRayTraceResult.m_82434_());
        }
        boolean valid = (validateDiff = PackagePortTargetSelectionHandler.validateDiff(target, pos)) == null;
        Color color = new Color(valid ? 10411635 : 0xFF7171);
        Vec3 source = Vec3.m_82539_((Vec3i)pos);
        Lang.translate((String)(validateDiff != null ? validateDiff : "package_port.valid"), (Object[])new Object[0]).color(color.getRGB()).sendStatus((Player)player);
        CreateClient.OUTLINER.chaseAABB((Object)"ChainPointSelected", new AABB(target, target)).colored(color).lineWidth(0.2f).disableLineNormals();
        if (!mc.f_91073_.m_8055_(pos).m_247087_()) {
            return;
        }
        CreateClient.OUTLINER.chaseAABB((Object)"TargetedFrogPos", new AABB(pos).m_82310_(0.0, 1.0, 0.0).m_165897_(0.125, 0.0, 0.125)).colored(color).lineWidth(0.0625f).disableLineNormals();
        PackagePortTargetSelectionHandler.animateConnection(mc, source, target, color);
    }

    public static void animateConnection(Minecraft mc, Vec3 source, Vec3 target, Color color) {
        DustParticleOptions data = new DustParticleOptions(color.asVectorF(), 1.0f);
        ClientLevel world = mc.f_91073_;
        double totalFlyingTicks = 10.0;
        int segments = (int)totalFlyingTicks / 3 + 1;
        double tickOffset = totalFlyingTicks / (double)segments;
        for (int i = 0; i < segments; ++i) {
            double ticks = (double)(AnimationTickHolder.getRenderTime() / 3.0f) % tickOffset + (double)i * tickOffset;
            Vec3 vec = source.m_165921_(target, ticks / totalFlyingTicks);
            world.m_7106_((ParticleOptions)data, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static String validateDiff(Vec3 target, BlockPos placedPos) {
        Vec3 source = Vec3.m_82539_((Vec3i)placedPos);
        Vec3 diff = target.m_82546_(source);
        if (diff.f_82480_ < 0.0 && !isPostbox) {
            return "package_port.cannot_reach_down";
        }
        if (diff.m_82553_() > (double)((Integer)ExtraConfigs.server().logistics.packagePortRange.get()).intValue()) {
            return "package_port.too_far";
        }
        return null;
    }
}

