/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.packagePort.frogport;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.frogport.FrogportBlockEntity;
import moe.paring.createlogisticsbackport.polyfill.SmartBlockEntityExtras;
import moe.paring.createlogisticsbackport.registry.ExtraPartialModels;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class FrogportRenderer
extends SmartBlockEntityRenderer<FrogportBlockEntity>
implements SmartBlockEntityExtras<FrogportBlockEntity> {
    public FrogportRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(FrogportBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        SuperByteBuffer body = CachedBufferer.partial((PartialModel)ExtraPartialModels.FROGPORT_BODY, (BlockState)blockEntity.m_58900_());
        float yaw = blockEntity.getYaw();
        float headPitch = 80.0f;
        float tonguePitch = 0.0f;
        float tongueLength = 0.0f;
        float headPitchModifier = 1.0f;
        boolean hasTarget = blockEntity.target != null;
        boolean animating = blockEntity.isAnimationInProgress();
        boolean depositing = blockEntity.currentlyDepositing;
        Vec3 diff = Vec3.f_82478_;
        if (blockEntity.addressFilter != null && !blockEntity.addressFilter.isBlank()) {
            this.renderNameplateOnHover(blockEntity, (Component)Component.m_237113_((String)blockEntity.addressFilter), 1.0f, ms, buffer, light);
        }
        if (Backend.canUseInstancing((Level)blockEntity.m_58904_())) {
            return;
        }
        if (hasTarget) {
            diff = blockEntity.target.getExactTargetLocation(blockEntity, (LevelAccessor)blockEntity.m_58904_(), blockEntity.m_58899_()).m_82492_(0.0, animating && depositing ? 0.0 : 0.75, 0.0).m_82546_(Vec3.m_82512_((Vec3i)blockEntity.m_58899_()));
            tonguePitch = (float)Mth.m_14136_((double)diff.f_82480_, (double)(diff.m_82542_(1.0, 0.0, 1.0).m_82553_() + 0.1875)) * 57.295776f;
            tongueLength = Math.max((float)diff.m_82553_(), 1.0f);
            headPitch = Mth.m_14036_((float)(tonguePitch * 2.0f), (float)60.0f, (float)100.0f);
        }
        if (animating) {
            float progress = blockEntity.animationProgress.getValue(partialTicks);
            float scale = 1.0f;
            float itemDistance = 0.0f;
            if (depositing) {
                double modifier = Math.max(0.0, 1.0 - Math.pow(((double)progress - 0.25) * 4.0 - 1.0, 4.0));
                itemDistance = (float)Math.max((double)tongueLength * Math.min(1.0, ((double)progress - 0.25) * 3.0), (double)tongueLength * modifier);
                tongueLength = (float)((double)tongueLength * Math.max(0.0, 1.0 - Math.pow(((double)progress * 1.25 - 0.25) * 4.0 - 1.0, 4.0)));
                headPitchModifier = (float)Math.max(0.0, 1.0 - Math.pow((double)progress * 1.25 * 2.0 - 1.0, 4.0));
                scale = 0.25f + progress * 3.0f / 4.0f;
            } else {
                tongueLength = (float)((double)tongueLength * Math.pow(Math.max(0.0, 1.0 - (double)progress * 1.25), 5.0));
                headPitchModifier = 1.0f - (float)Math.min(1.0, Math.max(0.0, (Math.pow((double)progress * 1.5, 2.0) - 0.5) * 2.0));
                scale = (float)Math.max(0.5, 1.0 - (double)progress * 1.25);
                itemDistance = tongueLength;
            }
            this.renderPackage(blockEntity, ms, buffer, light, overlay, diff, scale, itemDistance);
        } else {
            tongueLength = 0.0f;
            float anticipation = blockEntity.anticipationProgress.getValue(partialTicks);
            headPitchModifier = anticipation > 0.0f ? (float)Math.max(0.0, 1.0 - Math.pow((double)anticipation * 1.25 * 2.0 - 1.0, 4.0)) : 0.0f;
        }
        headPitch *= headPitchModifier;
        headPitch = Math.max(headPitch, blockEntity.manualOpenAnimationProgress.getValue(partialTicks) * 60.0f);
        tongueLength = Math.max(tongueLength, blockEntity.manualOpenAnimationProgress.getValue(partialTicks) * 0.25f);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)body.centre()).rotateY((double)yaw)).unCentre()).light(light).overlay(overlay).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
        SuperByteBuffer head = CachedBufferer.partial((PartialModel)(blockEntity.goggles ? ExtraPartialModels.FROGPORT_HEAD_GOGGLES : ExtraPartialModels.FROGPORT_HEAD), (BlockState)blockEntity.m_58900_());
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)head.centre()).rotateY((double)yaw)).unCentre()).translate(0.5, 0.625, 0.6875).rotateX((double)headPitch)).translateBack(0.5, 0.625, 0.6875);
        head.light(light).overlay(overlay).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
        SuperByteBuffer tongue = CachedBufferer.partial((PartialModel)ExtraPartialModels.FROGPORT_TONGUE, (BlockState)blockEntity.m_58900_());
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)tongue.centre()).rotateY((double)yaw)).unCentre()).translate(0.5, 0.625, 0.6875).rotateX((double)tonguePitch)).scale(1.0f, 1.0f, tongueLength / 0.4375f).translateBack(0.5, 0.625, 0.6875);
        tongue.light(light).overlay(overlay).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
    }

    private void renderPackage(FrogportBlockEntity blockEntity, PoseStack ms, MultiBufferSource buffer, int light, int overlay, Vec3 diff, float scale, float itemDistance) {
        if (blockEntity.animatedPackage == null) {
            return;
        }
        if ((double)scale < 0.45) {
            return;
        }
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)blockEntity.animatedPackage.m_41720_());
        if (key == null) {
            return;
        }
        SuperByteBuffer rigBuffer = CachedBufferer.partial((PartialModel)ExtraPartialModels.PACKAGE_RIGGING.get(key), (BlockState)blockEntity.m_58900_());
        SuperByteBuffer boxBuffer = CachedBufferer.partial((PartialModel)ExtraPartialModels.PACKAGES.get(key), (BlockState)blockEntity.m_58900_());
        boolean animating = blockEntity.isAnimationInProgress();
        boolean depositing = blockEntity.currentlyDepositing;
        for (SuperByteBuffer buf : new SuperByteBuffer[]{boxBuffer, rigBuffer}) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)buf.translate(0.0, 0.1875, 0.0).translate(diff.m_82541_().m_82490_((double)itemDistance).m_82492_(0.0, animating && depositing ? 0.75 : 0.0, 0.0))).centre()).scale(scale)).unCentre()).light(light).overlay(overlay).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
            if (!blockEntity.currentlyDepositing) break;
        }
    }
}

