/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.packagePort.frogport;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.PackagePortBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.frogport.FrogportBlockEntity;
import moe.paring.createlogisticsbackport.registry.ExtraPartialModels;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class FrogportVisual
extends BlockEntityInstance<FrogportBlockEntity>
implements DynamicInstance {
    private final ModelData body;
    private ModelData head;
    private final ModelData tongue;
    private final ModelData rig;
    private final ModelData box;
    private final PoseStack basePose = new PoseStack();
    private float lastYaw = Float.NaN;
    private float lastHeadPitch = Float.NaN;
    private float lastTonguePitch = Float.NaN;
    private float lastTongueLength = Float.NaN;
    private boolean lastGoggles = false;

    public FrogportVisual(MaterialManager materialManager, FrogportBlockEntity blockEntity) {
        super(materialManager, (BlockEntity)blockEntity);
        this.body = (ModelData)materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(ExtraPartialModels.FROGPORT_BODY).createInstance();
        this.head = (ModelData)materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(ExtraPartialModels.FROGPORT_HEAD).createInstance();
        this.tongue = (ModelData)materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(ExtraPartialModels.FROGPORT_TONGUE).createInstance();
        this.rig = (ModelData)materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(Blocks.f_50016_.m_49966_()).createInstance();
        this.box = (ModelData)materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(Blocks.f_50016_.m_49966_()).createInstance();
        this.rig.setEmptyTransform();
        this.box.setEmptyTransform();
        this.animate();
    }

    public void beginFrame() {
        this.animate();
    }

    private void animate() {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        this.updateGoggles();
        float yaw = ((FrogportBlockEntity)this.blockEntity).getYaw();
        float headPitch = 80.0f;
        float tonguePitch = 0.0f;
        float tongueLength = 0.0f;
        float headPitchModifier = 1.0f;
        boolean hasTarget = ((FrogportBlockEntity)this.blockEntity).target != null;
        boolean animating = ((FrogportBlockEntity)this.blockEntity).isAnimationInProgress();
        boolean depositing = ((FrogportBlockEntity)this.blockEntity).currentlyDepositing;
        Vec3 diff = Vec3.f_82478_;
        if (hasTarget) {
            diff = ((FrogportBlockEntity)this.blockEntity).target.getExactTargetLocation((PackagePortBlockEntity)this.blockEntity, (LevelAccessor)((FrogportBlockEntity)this.blockEntity).m_58904_(), ((FrogportBlockEntity)this.blockEntity).m_58899_()).m_82492_(0.0, animating && depositing ? 0.0 : 0.75, 0.0).m_82546_(Vec3.m_82512_((Vec3i)((FrogportBlockEntity)this.blockEntity).m_58899_()));
            tonguePitch = (float)Mth.m_14136_((double)diff.f_82480_, (double)(diff.m_82542_(1.0, 0.0, 1.0).m_82553_() + 0.1875)) * 57.295776f;
            tongueLength = Math.max((float)diff.m_82553_(), 1.0f);
            headPitch = Mth.m_14036_((float)(tonguePitch * 2.0f), (float)60.0f, (float)100.0f);
        }
        if (animating) {
            float progress = ((FrogportBlockEntity)this.blockEntity).animationProgress.getValue(partialTicks);
            float scale = 1.0f;
            float itemDistance = 0.0f;
            if (depositing) {
                double modifier = Math.max(0.0, 1.0 - Math.pow(((double)progress - 0.25) * 4.0 - 1.0, 4.0));
                itemDistance = (float)Math.max((double)tongueLength * Math.min(1.0, ((double)progress - 0.25) * 3.0), (double)tongueLength * modifier);
                tongueLength = (float)((double)tongueLength * Math.max(0.0, 1.0 - Math.pow(((double)progress * 1.25 - 0.25) * 4.0 - 1.0, 4.0)));
                headPitchModifier = (float)Math.max(0.0, 1.0 - Math.pow((double)progress * 1.25 * 2.0 - 1.0, 4.0));
                scale = 0.25f + progress * 3.0f / 4.0f;
            } else {
                tongueLength = (float)((double)tongueLength * Math.pow(Math.max(0.0, 1.0 - (double)progress * 1.25), 5.0));
                headPitchModifier = 1.0f - (float)Math.min(1.0, Math.max(0.0, (Math.pow((double)progress * 1.5, 2.0) - 0.5) * 2.0));
                scale = (float)Math.max(0.5, 1.0 - (double)progress * 1.25);
                itemDistance = tongueLength;
            }
            this.renderPackage(diff, scale, itemDistance);
        } else {
            tongueLength = 0.0f;
            float anticipation = ((FrogportBlockEntity)this.blockEntity).anticipationProgress.getValue(partialTicks);
            headPitchModifier = anticipation > 0.0f ? (float)Math.max(0.0, 1.0 - Math.pow((double)anticipation * 1.25 * 2.0 - 1.0, 4.0)) : 0.0f;
            this.rig.setEmptyTransform();
            this.rig.setEmptyTransform();
        }
        headPitch *= headPitchModifier;
        headPitch = Math.max(headPitch, ((FrogportBlockEntity)this.blockEntity).manualOpenAnimationProgress.getValue(partialTicks) * 60.0f);
        tongueLength = Math.max(tongueLength, ((FrogportBlockEntity)this.blockEntity).manualOpenAnimationProgress.getValue(partialTicks) * 0.25f);
        if (yaw != this.lastYaw) {
            ((ModelData)((ModelData)((ModelData)((ModelData)this.body.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotateY((double)yaw)).unCentre()).markDirty();
            this.basePose.m_166856_();
            TransformStack ts = TransformStack.cast((PoseStack)this.basePose);
            ((TransformStack)((TransformStack)((TransformStack)ts.translate((Vec3i)this.getInstancePosition())).centre()).rotateY((double)yaw)).unCentre();
            ts.translate(0.5, 0.625, 0.6875);
            this.lastYaw = yaw;
            this.lastTonguePitch = Float.NaN;
            this.lastHeadPitch = Float.NaN;
        }
        if (headPitch != this.lastHeadPitch) {
            ((ModelData)((ModelData)this.head.setTransform(this.basePose).rotateX((double)headPitch)).translateBack(0.5, 0.625, 0.6875)).markDirty();
            this.lastHeadPitch = headPitch;
        }
        if (tonguePitch != this.lastTonguePitch || tongueLength != this.lastTongueLength) {
            ((ModelData)((ModelData)this.tongue.setTransform(this.basePose).rotateX((double)tonguePitch)).scale(1.0f, 1.0f, tongueLength / 0.4375f).translateBack(0.5, 0.625, 0.6875)).markDirty();
            this.lastTonguePitch = tonguePitch;
            this.lastTongueLength = tongueLength;
        }
    }

    public void updateGoggles() {
        if (((FrogportBlockEntity)this.blockEntity).goggles && !this.lastGoggles) {
            this.head.delete();
            this.head = (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(ExtraPartialModels.FROGPORT_HEAD_GOGGLES).createInstance();
            this.lastHeadPitch = -1.0f;
            this.updateLight();
            this.lastGoggles = true;
        }
        if (!((FrogportBlockEntity)this.blockEntity).goggles && this.lastGoggles) {
            this.head.delete();
            this.head = (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(ExtraPartialModels.FROGPORT_HEAD).createInstance();
            this.lastHeadPitch = -1.0f;
            this.updateLight();
            this.lastGoggles = false;
        }
    }

    private void renderPackage(Vec3 diff, float scale, float itemDistance) {
        if (((FrogportBlockEntity)this.blockEntity).animatedPackage == null || (double)scale < 0.45) {
            this.rig.setEmptyTransform();
            this.box.setEmptyTransform();
            return;
        }
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)((FrogportBlockEntity)this.blockEntity).animatedPackage.m_41720_());
        if (key == null) {
            this.rig.setEmptyTransform();
            this.box.setEmptyTransform();
            return;
        }
        boolean animating = ((FrogportBlockEntity)this.blockEntity).isAnimationInProgress();
        boolean depositing = ((FrogportBlockEntity)this.blockEntity).currentlyDepositing;
        this.materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(ExtraPartialModels.PACKAGES.get(key)).stealInstance((InstanceData)this.box);
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.box.loadIdentity().translate((Vec3i)this.getInstancePosition())).translate(0.0, 0.1875, 0.0).translate(diff.m_82541_().m_82490_((double)itemDistance).m_82492_(0.0, animating && depositing ? 0.75 : 0.0, 0.0))).centre()).scale(scale)).unCentre()).markDirty();
        if (!depositing) {
            this.rig.setEmptyTransform();
            return;
        }
        this.materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(ExtraPartialModels.PACKAGE_RIGGING.get(key)).stealInstance((InstanceData)this.rig);
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.rig.loadIdentity().translate((Vec3i)this.getInstancePosition())).translate(0.0, 0.1875, 0.0).translate(diff.m_82541_().m_82490_((double)itemDistance).m_82492_(0.0, animating && depositing ? 0.75 : 0.0, 0.0))).centre()).scale(scale)).unCentre()).markDirty();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.body, this.head, this.tongue, this.rig, this.box});
    }

    protected void remove() {
        this.body.delete();
        this.head.delete();
        this.tongue.delete();
        this.rig.delete();
        this.box.delete();
    }
}

