/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.packagePort.postbox;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import moe.paring.createlogisticsbackport.accessor.GlobalStationMixinAccessor;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.PackagePortBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.postbox.PostboxBlock;
import moe.paring.createlogisticsbackport.polyfill.trains.GlobalPackagePort;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class PostboxBlockEntity
extends PackagePortBlockEntity {
    public WeakReference<GlobalStation> trackedGlobalStation = new WeakReference<Object>(null);
    public LerpedFloat flag = LerpedFloat.linear().startWithValue(0.0);
    public boolean forceFlag;
    private boolean sendParticles;
    public AbstractComputerBehaviour computerBehaviour;

    public PostboxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = ComputerCraftProxy.behaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        super.addBehaviours(behaviours);
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_ && !this.isVirtual()) {
            if (this.sendParticles) {
                this.sendData();
            }
            return;
        }
        float currentTarget = this.flag.getChaseTarget();
        if (currentTarget == 0.0f || this.flag.settled()) {
            boolean target;
            boolean bl = target = !this.inventory.m_7983_() || this.forceFlag;
            if ((float)target != currentTarget) {
                this.flag.chase((double)target, (double)0.1f, LerpedFloat.Chaser.LINEAR);
                if (target) {
                    AllSoundEvents.CONTRAPTION_ASSEMBLE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 1.0f, 2.0f, true);
                }
            }
        }
        boolean settled = this.flag.getValue() > 0.15f;
        this.flag.tickChaser();
        if (currentTarget == 0.0f && settled != this.flag.getValue() > 0.15f) {
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.75f, 1.5f, true);
        }
        if (this.sendParticles) {
            this.sendParticles = false;
            BoneMealItem.m_40638_((LevelAccessor)this.f_58857_, (BlockPos)this.f_58858_, (int)40);
        }
    }

    @Override
    protected void onOpenChange(boolean open) {
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)PostboxBlock.OPEN, (Comparable)Boolean.valueOf(open)));
        this.f_58857_.m_247517_(null, this.f_58858_, open ? SoundEvents.f_11725_ : SoundEvents.f_11724_, SoundSource.BLOCKS);
    }

    public void spawnParticles() {
        this.sendParticles = true;
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (clientPacket && this.sendParticles) {
            NBTHelper.putMarker((CompoundTag)tag, (String)"Particles");
        }
        this.sendParticles = false;
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.sendParticles = clientPacket && tag.m_128441_("Particles");
    }

    public void onChunkUnloaded() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        GlobalStation station = (GlobalStation)this.trackedGlobalStation.get();
        if (station == null) {
            return;
        }
        Map<BlockPos, GlobalPackagePort> ports = ((GlobalStationMixinAccessor)station).create_logistics_backport$getConnectedPorts();
        if (!ports.containsKey(this.f_58858_)) {
            return;
        }
        GlobalPackagePort globalPackagePort = ports.get(this.f_58858_);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            globalPackagePort.offlineBuffer.setStackInSlot(i, this.inventory.getStackInSlot(i));
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
        globalPackagePort.primed = true;
        Create.RAILWAYS.markTracksDirty();
        super.onChunkUnloaded();
    }

    public void invalidateCaps() {
        super.invalidate();
        this.computerBehaviour.removePeripheral();
    }
}

