/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.packager;

import com.google.common.collect.Lists;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import moe.paring.createlogisticsbackport.content.logistics.BigItemStack;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.LogisticalStockResponsePacket;
import moe.paring.createlogisticsbackport.registry.ExtraPackets;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;

public class InventorySummary {
    public static final InventorySummary EMPTY = new InventorySummary();
    private Map<Item, List<BigItemStack>> items = new IdentityHashMap<Item, List<BigItemStack>>();
    private List<BigItemStack> stacksByCount;
    private int totalCount;
    public int contributingLinks;

    public void add(InventorySummary summary) {
        summary.items.forEach((i, list) -> list.forEach(this::add));
        this.contributingLinks += summary.contributingLinks;
    }

    public void add(ItemStack stack) {
        this.add(stack, stack.m_41613_());
    }

    public void add(BigItemStack entry) {
        this.add(entry.stack, entry.count);
    }

    public Map<Item, List<BigItemStack>> getItemMap() {
        return this.items;
    }

    public InventorySummary copy() {
        InventorySummary inventorySummary = new InventorySummary();
        this.items.forEach((i, list) -> list.forEach(entry -> inventorySummary.add(entry.stack, entry.count)));
        return inventorySummary;
    }

    public void add(ItemStack stack, int count) {
        if (count == 0 || stack.m_41619_()) {
            return;
        }
        if (this.totalCount < 1000000000) {
            this.totalCount += count;
        }
        List stacks = this.items.computeIfAbsent(stack.m_41720_(), $ -> Lists.newArrayList());
        for (BigItemStack existing : stacks) {
            ItemStack existingStack = existing.stack;
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)existingStack, (ItemStack)stack)) continue;
            if (existing.count < 1000000000) {
                existing.count += count;
            }
            return;
        }
        if (stack.m_41613_() > stack.m_41741_()) {
            stack = stack.m_255036_(1);
        }
        BigItemStack newEntry = new BigItemStack(stack, count);
        stacks.add(newEntry);
    }

    public boolean erase(ItemStack stack) {
        List<BigItemStack> stacks = this.items.get(stack.m_41720_());
        if (stacks == null) {
            return false;
        }
        Iterator<BigItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            BigItemStack existing = iterator.next();
            ItemStack existingStack = existing.stack;
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)existingStack, (ItemStack)stack)) continue;
            this.totalCount -= existing.count;
            iterator.remove();
            return true;
        }
        return false;
    }

    public int getCountOf(ItemStack stack) {
        List<BigItemStack> list = this.items.get(stack.m_41720_());
        if (list == null) {
            return 0;
        }
        for (BigItemStack entry : list) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)entry.stack, (ItemStack)stack)) continue;
            return entry.count;
        }
        return 0;
    }

    public int getTotalOfMatching(Predicate<ItemStack> filter) {
        MutableInt sum = new MutableInt();
        this.items.forEach(($, list) -> {
            for (BigItemStack entry : list) {
                if (!filter.test(entry.stack)) continue;
                sum.add(entry.count);
            }
        });
        return sum.getValue();
    }

    public List<BigItemStack> getStacks() {
        if (this.stacksByCount == null) {
            ArrayList<BigItemStack> stacks = new ArrayList<BigItemStack>();
            this.items.forEach((i, list) -> list.forEach(stacks::add));
            return stacks;
        }
        return this.stacksByCount;
    }

    public List<BigItemStack> getStacksByCount() {
        if (this.stacksByCount == null) {
            this.stacksByCount = new ArrayList<BigItemStack>();
            this.items.forEach((i, list) -> list.forEach(this.stacksByCount::add));
            Collections.sort(this.stacksByCount, BigItemStack.comparator());
        }
        return this.stacksByCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void divideAndSendTo(ServerPlayer player, BlockPos pos) {
        List<BigItemStack> stacks = this.getStacksByCount();
        int remaining = stacks.size();
        ArrayList<BigItemStack> currentList = null;
        PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> player);
        if (stacks.isEmpty()) {
            ExtraPackets.getChannel().send(target, (Object)new LogisticalStockResponsePacket(true, pos, Collections.emptyList()));
        }
        for (BigItemStack entry : stacks) {
            if (currentList == null) {
                currentList = new ArrayList<BigItemStack>(Math.min(100, remaining));
            }
            currentList.add(entry);
            if (--remaining == 0) break;
            if (currentList.size() < 100) continue;
            ExtraPackets.getChannel().send(target, (Object)new LogisticalStockResponsePacket(false, pos, currentList));
            currentList = null;
        }
        if (currentList != null) {
            ExtraPackets.getChannel().send(target, (Object)new LogisticalStockResponsePacket(true, pos, (List<BigItemStack>)currentList));
        }
    }

    public CompoundTag write() {
        ArrayList all = new ArrayList();
        this.items.forEach((key, list) -> all.addAll(list));
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("List", (Tag)NBTHelper.writeCompoundList(all, BigItemStack::write));
        return tag;
    }

    public static InventorySummary read(CompoundTag tag) {
        InventorySummary summary = new InventorySummary();
        NBTHelper.iterateCompoundList((ListTag)tag.m_128437_("List", 10), c -> summary.add(BigItemStack.read(c)));
        return summary;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }
}

