/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.packager;

import com.google.common.base.Predicate;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.simibubi.create.content.logistics.crate.BottomlessItemHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import moe.paring.createlogisticsbackport.CreateLogisticsBackport;
import moe.paring.createlogisticsbackport.api.packager.unpacking.UnpackingHandler;
import moe.paring.createlogisticsbackport.content.logistics.BigItemStack;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageItem;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelBehaviour;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelBlock;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.frogport.FrogportBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packager.IdentifiedInventory;
import moe.paring.createlogisticsbackport.content.logistics.packager.InventorySummary;
import moe.paring.createlogisticsbackport.content.logistics.packager.PackagerBlock;
import moe.paring.createlogisticsbackport.content.logistics.packager.PackagerItemHandler;
import moe.paring.createlogisticsbackport.content.logistics.packager.PackagingRequest;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.PackagerLinkBlock;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.PackagerLinkBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.RequestPromiseQueue;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.WiFiEffectPacket;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.PackageOrderWithCrafts;
import moe.paring.createlogisticsbackport.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour2;
import moe.paring.createlogisticsbackport.polyfill.ItemHelperExtra;
import moe.paring.createlogisticsbackport.registry.ExtraBlocks;
import moe.paring.createlogisticsbackport.registry.ExtraSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PackagerBlockEntity
extends SmartBlockEntity {
    public boolean redstonePowered;
    public int buttonCooldown;
    public String signBasedAddress;
    public InvManipulationBehaviour2 targetInventory;
    public ItemStack heldBox;
    public ItemStack previouslyUnwrapped;
    public List<BigItemStack> queuedExitingPackages;
    public PackagerItemHandler inventory;
    private final LazyOptional<IItemHandler> invProvider;
    public static final int CYCLE = 20;
    public int animationTicks;
    public boolean animationInward;
    public AbstractComputerBehaviour computerBehaviour;
    public Boolean hasCustomComputerAddress;
    public String customComputerAddress;
    private InventorySummary availableItems;
    private VersionedInventoryTrackerBehaviour invVersionTracker;

    public PackagerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.redstonePowered = state.m_61145_((Property)PackagerBlock.POWERED).orElse(false);
        this.heldBox = ItemStack.f_41583_;
        this.previouslyUnwrapped = ItemStack.f_41583_;
        this.inventory = new PackagerItemHandler(this);
        this.invProvider = LazyOptional.of(() -> this.inventory);
        this.animationTicks = 0;
        this.animationInward = true;
        this.queuedExitingPackages = new LinkedList<BigItemStack>();
        this.signBasedAddress = "";
        this.customComputerAddress = "";
        this.hasCustomComputerAddress = false;
        this.buttonCooldown = 0;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.targetInventory = new InvManipulationBehaviour2(this, CapManipulationBehaviourBase.InterfaceProvider.oppositeOfBlockFacing()).withFilter((Predicate<BlockEntity>)((Predicate)this::supportsBlockEntity));
        behaviours.add((BlockEntityBehaviour)this.targetInventory);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
        this.computerBehaviour = ComputerCraftProxy.behaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
    }

    private boolean supportsBlockEntity(BlockEntity target) {
        return target != null && !(target instanceof PortableStorageInterfaceBlockEntity);
    }

    public void initialize() {
        super.initialize();
        this.recheckIfLinksPresent();
    }

    public void tick() {
        super.tick();
        if (this.buttonCooldown > 0) {
            --this.buttonCooldown;
        }
        if (this.animationTicks == 0) {
            this.previouslyUnwrapped = ItemStack.f_41583_;
            if (!this.f_58857_.m_5776_() && !this.queuedExitingPackages.isEmpty() && this.heldBox.m_41619_()) {
                BigItemStack entry = this.queuedExitingPackages.get(0);
                this.heldBox = entry.stack.m_41777_();
                --entry.count;
                if (entry.count <= 0) {
                    this.queuedExitingPackages.remove(0);
                }
                this.animationInward = false;
                this.animationTicks = 20;
                this.notifyUpdate();
            }
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (this.animationTicks == 20 - (this.animationInward ? 5 : 1)) {
                ExtraSoundEvents.PACKAGER.playAt(this.f_58857_, (Vec3i)this.f_58858_, 1.0f, 1.0f, true);
            }
            if (this.animationTicks == (this.animationInward ? 1 : 5)) {
                this.f_58857_.m_245747_(this.f_58858_, SoundEvents.f_12011_, SoundSource.BLOCKS, 0.25f, 0.75f, true);
            }
        }
        --this.animationTicks;
        if (this.animationTicks == 0 && !this.f_58857_.m_5776_()) {
            this.wakeTheFrogs();
            this.m_6596_();
        }
    }

    public void triggerStockCheck() {
        this.getAvailableItems();
    }

    public InventorySummary getAvailableItems() {
        return this.getAvailableItems(false);
    }

    public InventorySummary getAvailableItems(boolean scanInputSlots) {
        if (this.availableItems != null && this.invVersionTracker.stillWaiting((IItemHandler)this.targetInventory.getInventory())) {
            return this.availableItems;
        }
        InventorySummary availableItems = new InventorySummary();
        IItemHandler targetInv = (IItemHandler)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            this.availableItems = availableItems;
            return availableItems;
        }
        if (targetInv instanceof BottomlessItemHandler) {
            BottomlessItemHandler bih = (BottomlessItemHandler)targetInv;
            availableItems.add(bih.getStackInSlot(0), 1000000000);
            this.availableItems = availableItems;
            return availableItems;
        }
        for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
            int slotLimit = targetInv.getSlotLimit(slot);
            availableItems.add(scanInputSlots ? targetInv.getStackInSlot(slot) : targetInv.extractItem(slot, slotLimit, true));
        }
        this.invVersionTracker.awaitNewVersion((IItemHandler)this.targetInventory.getInventory());
        this.submitNewArrivals(this.availableItems, availableItems);
        this.availableItems = availableItems;
        return availableItems;
    }

    private void submitNewArrivals(InventorySummary before, InventorySummary after) {
        if (before == null || after.isEmpty()) {
            return;
        }
        HashSet<RequestPromiseQueue> promiseQueues = new HashSet<RequestPromiseQueue>();
        for (Direction d : Iterate.directions) {
            Object object;
            if (!this.f_58857_.m_46749_(this.f_58858_.m_121945_(d))) continue;
            BlockState adjacentState = this.f_58857_.m_8055_(this.f_58858_.m_121945_(d));
            if (ExtraBlocks.FACTORY_GAUGE.has(adjacentState)) {
                if (FactoryPanelBlock.connectedDirection(adjacentState) != d || !((object = this.f_58857_.m_7702_(this.f_58858_.m_121945_(d))) instanceof FactoryPanelBlockEntity)) continue;
                FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)((Object)object);
                if (!fpbe.restocker) continue;
                object = fpbe.panels.values().iterator();
                while (object.hasNext()) {
                    FactoryPanelBehaviour behaviour = (FactoryPanelBehaviour)object.next();
                    if (!behaviour.isActive()) continue;
                    promiseQueues.add(behaviour.restockerPromises);
                }
            }
            if (!ExtraBlocks.STOCK_LINK.has(adjacentState) || PackagerLinkBlock.m_53200_(adjacentState) != d || !((object = this.f_58857_.m_7702_(this.f_58858_.m_121945_(d))) instanceof PackagerLinkBlockEntity)) continue;
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)((Object)object);
            UUID freqId = plbe.behaviour.freqId;
            if (!CreateLogisticsBackport.LOGISTICS.hasQueuedPromises(freqId)) continue;
            promiseQueues.add(CreateLogisticsBackport.LOGISTICS.getQueuedPromises(freqId));
        }
        if (promiseQueues.isEmpty()) {
            return;
        }
        for (BigItemStack entry : after.getStacks()) {
            before.add(entry.stack, -entry.count);
        }
        for (RequestPromiseQueue queue : promiseQueues) {
            for (BigItemStack entry : before.getStacks()) {
                if (entry.count >= 0) continue;
                queue.itemEnteredSystem(entry.stack, -entry.count);
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.recheckIfLinksPresent();
        if (!this.redstonePowered) {
            return;
        }
        this.redstonePowered = this.m_58900_().m_61145_((Property)PackagerBlock.POWERED).orElse(false);
        if (!this.redstoneModeActive()) {
            return;
        }
        this.updateSignAddress();
        this.attemptToSend(null);
    }

    public void recheckIfLinksPresent() {
        boolean isLinked;
        if (this.f_58857_.m_5776_()) {
            return;
        }
        BlockState blockState = this.m_58900_();
        if (!blockState.m_61138_((Property)PackagerBlock.LINKED)) {
            return;
        }
        boolean shouldBeLinked = this.getLinkPos() != null;
        if (shouldBeLinked == (isLinked = ((Boolean)blockState.m_61143_((Property)PackagerBlock.LINKED)).booleanValue())) {
            return;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61122_((Property)PackagerBlock.LINKED));
    }

    public boolean redstoneModeActive() {
        return this.m_58900_().m_61145_((Property)PackagerBlock.LINKED).orElse(false) == false;
    }

    private BlockPos getLinkPos() {
        for (Direction d : Iterate.directions) {
            BlockState adjacentState = this.f_58857_.m_8055_(this.f_58858_.m_121945_(d));
            if (!ExtraBlocks.STOCK_LINK.has(adjacentState) || PackagerLinkBlock.m_53200_(adjacentState) != d) continue;
            return this.f_58858_.m_121945_(d);
        }
        return null;
    }

    public void flashLink() {
        for (Direction d : Iterate.directions) {
            BlockState adjacentState = this.f_58857_.m_8055_(this.f_58858_.m_121945_(d));
            if (!ExtraBlocks.STOCK_LINK.has(adjacentState) || PackagerLinkBlock.m_53200_(adjacentState) != d) continue;
            WiFiEffectPacket.send(this.f_58857_, this.f_58858_.m_121945_(d));
            return;
        }
    }

    public boolean isTooBusyFor(LogisticallyLinkedBehaviour.RequestType type) {
        int queue = this.queuedExitingPackages.size();
        return queue >= (switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case LogisticallyLinkedBehaviour.RequestType.PLAYER -> 50;
            case LogisticallyLinkedBehaviour.RequestType.REDSTONE -> 20;
            case LogisticallyLinkedBehaviour.RequestType.RESTOCK -> 10;
        });
    }

    public void activate() {
        this.redstonePowered = true;
        this.m_6596_();
        this.recheckIfLinksPresent();
        if (!this.redstoneModeActive()) {
            return;
        }
        this.updateSignAddress();
        this.attemptToSend(null);
        this.buttonCooldown = 40;
    }

    public boolean unwrapBox(ItemStack box, boolean simulate) {
        if (this.animationTicks > 0) {
            return false;
        }
        Objects.requireNonNull(this.f_58857_);
        ItemStackHandler contents = PackageItem.getContents(box);
        List<ItemStack> items = ItemHelperExtra.getNonEmptyStacks(contents);
        if (items.isEmpty()) {
            return true;
        }
        PackageOrderWithCrafts orderContext = PackageItem.getOrderContext(box);
        Direction facing = this.m_58900_().m_61145_((Property)PackagerBlock.f_52588_).orElse(Direction.UP);
        BlockPos target = this.f_58858_.m_121945_(facing.m_122424_());
        BlockState targetState = this.f_58857_.m_8055_(target);
        UnpackingHandler handler = UnpackingHandler.REGISTRY.get((StateHolder<Block, ?>)targetState);
        UnpackingHandler toUse = handler != null ? handler : UnpackingHandler.DEFAULT;
        boolean unpacked = toUse.unpack(this.f_58857_, target, targetState, facing, items, orderContext, simulate);
        if (unpacked && !simulate) {
            this.previouslyUnwrapped = box;
            this.animationInward = true;
            this.animationTicks = 20;
            this.notifyUpdate();
        }
        return unpacked;
    }

    public void attemptToSend(List<PackagingRequest> queuedRequests) {
        BlockEntity blockEntity;
        boolean requestQueue;
        if (!(queuedRequests != null || this.heldBox.m_41619_() && this.animationTicks == 0 && this.buttonCooldown <= 0)) {
            return;
        }
        IItemHandler targetInv = (IItemHandler)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        boolean anyItemPresent = false;
        ItemStackHandler extractedItems = new ItemStackHandler(9);
        ItemStack extractedPackageItem = ItemStack.f_41583_;
        PackagingRequest nextRequest = null;
        String fixedAddress = null;
        int fixedOrderId = 0;
        int linkIndexInOrder = 0;
        boolean finalLinkInOrder = false;
        int packageIndexAtLink = 0;
        boolean finalPackageAtLink = false;
        PackageOrderWithCrafts orderContext = null;
        boolean bl = requestQueue = queuedRequests != null;
        if (requestQueue && !queuedRequests.isEmpty()) {
            nextRequest = queuedRequests.get(0);
            fixedAddress = nextRequest.address();
            fixedOrderId = nextRequest.orderId();
            linkIndexInOrder = nextRequest.linkIndex();
            finalLinkInOrder = nextRequest.finalLink().booleanValue();
            packageIndexAtLink = nextRequest.packageCounter().getAndIncrement();
            orderContext = nextRequest.context();
        }
        block0: for (int i = 0; i < 9; ++i) {
            boolean continuePacking = true;
            block1: while (continuePacking) {
                continuePacking = false;
                for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
                    boolean bulky;
                    int initialCount = requestQueue ? Math.min(64, nextRequest.getCount()) : 64;
                    ItemStack extracted = targetInv.extractItem(slot, initialCount, true);
                    if (extracted.m_41619_() || requestQueue && !ItemHandlerHelper.canItemStacksStack((ItemStack)extracted, (ItemStack)nextRequest.item())) continue;
                    boolean bl2 = bulky = !extracted.m_41720_().m_142095_();
                    if (bulky && anyItemPresent) continue;
                    anyItemPresent = true;
                    int leftovers = ItemHandlerHelper.insertItemStacked((IItemHandler)extractedItems, (ItemStack)extracted.m_41777_(), (boolean)false).m_41613_();
                    int transferred = extracted.m_41613_() - leftovers;
                    targetInv.extractItem(slot, transferred, false);
                    if (extracted.m_41720_() instanceof PackageItem) {
                        extractedPackageItem = extracted;
                    }
                    if (!requestQueue) {
                        if (!bulky) continue;
                        break block0;
                    }
                    nextRequest.subtract(transferred);
                    if (!nextRequest.isEmpty()) {
                        if (!bulky) continue;
                        break block0;
                    }
                    finalPackageAtLink = true;
                    queuedRequests.remove(0);
                    if (queuedRequests.isEmpty()) break block0;
                    int previousCount = nextRequest.packageCounter().intValue();
                    nextRequest = queuedRequests.get(0);
                    if (!fixedAddress.equals(nextRequest.address()) || fixedOrderId != nextRequest.orderId()) break block0;
                    nextRequest.packageCounter().setValue(previousCount);
                    finalPackageAtLink = false;
                    continuePacking = true;
                    if (nextRequest.context() != null) {
                        orderContext = nextRequest.context();
                    }
                    if (!bulky) continue block1;
                    break block0;
                }
            }
        }
        if (!anyItemPresent) {
            if (nextRequest != null) {
                queuedRequests.remove(0);
            }
            return;
        }
        ItemStack createdBox = extractedPackageItem.m_41619_() ? PackageItem.containing(extractedItems) : extractedPackageItem.m_41777_();
        PackageItem.clearAddress(createdBox);
        if (fixedAddress != null) {
            PackageItem.addAddress(createdBox, fixedAddress);
        }
        if (requestQueue) {
            PackageItem.setOrder(createdBox, fixedOrderId, linkIndexInOrder, finalLinkInOrder, packageIndexAtLink, finalPackageAtLink, orderContext);
        }
        if (!requestQueue && !this.signBasedAddress.isBlank()) {
            PackageItem.addAddress(createdBox, this.signBasedAddress);
        }
        BlockPos linkPos = this.getLinkPos();
        if (extractedPackageItem.m_41619_() && linkPos != null && (blockEntity = this.f_58857_.m_7702_(linkPos)) instanceof PackagerLinkBlockEntity) {
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)blockEntity;
            plbe.behaviour.deductFromAccurateSummary(extractedItems);
        }
        if (!this.heldBox.m_41619_() || this.animationTicks != 0) {
            this.queuedExitingPackages.add(new BigItemStack(createdBox, 1));
            return;
        }
        this.heldBox = createdBox;
        this.animationInward = false;
        this.animationTicks = 20;
        this.triggerStockCheck();
        this.notifyUpdate();
    }

    public void updateSignAddress() {
        this.signBasedAddress = "";
        for (Direction side : Iterate.directions) {
            String address = this.getSign(side);
            if (address == null || address.isBlank()) continue;
            this.signBasedAddress = address;
        }
        if (this.computerBehaviour.hasAttachedComputer() && this.hasCustomComputerAddress.booleanValue()) {
            this.signBasedAddress = this.customComputerAddress;
        } else {
            this.hasCustomComputerAddress = false;
        }
    }

    protected String getSign(Direction side) {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
        if (!(blockEntity instanceof SignBlockEntity)) {
            return null;
        }
        SignBlockEntity sign = (SignBlockEntity)blockEntity;
        for (boolean front : Iterate.trueAndFalse) {
            SignText text = sign.m_277157_(front);
            Object address = "";
            for (Component component : text.m_276945_(false)) {
                String string = component.getString();
                if (string.isBlank()) continue;
                address = (String)address + string.trim() + " ";
            }
            if (((String)address).isBlank()) continue;
            return ((String)address).trim();
        }
        return null;
    }

    protected void wakeTheFrogs() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(Direction.UP));
        if (blockEntity instanceof FrogportBlockEntity) {
            FrogportBlockEntity port = (FrogportBlockEntity)blockEntity;
            port.tryPullingFromOwnAndAdjacentInventories();
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.redstonePowered = compound.m_128471_("Active");
        this.animationInward = compound.m_128471_("AnimationInward");
        this.animationTicks = compound.m_128451_("AnimationTicks");
        this.signBasedAddress = compound.m_128461_("SignAddress");
        this.customComputerAddress = compound.m_128461_("ComputerAddress");
        this.hasCustomComputerAddress = compound.m_128471_("HasComputerAddress");
        this.heldBox = ItemStack.m_41712_((CompoundTag)compound.m_128469_("HeldBox"));
        this.previouslyUnwrapped = ItemStack.m_41712_((CompoundTag)compound.m_128469_("InsertedBox"));
        if (clientPacket) {
            return;
        }
        this.queuedExitingPackages = NBTHelper.readCompoundList((ListTag)compound.m_128437_("QueuedExitingPackages", 10), BigItemStack::read);
        if (compound.m_128441_("LastSummary")) {
            this.availableItems = InventorySummary.read(compound.m_128469_("LastSummary"));
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128379_("Active", this.redstonePowered);
        compound.m_128379_("AnimationInward", this.animationInward);
        compound.m_128405_("AnimationTicks", this.animationTicks);
        compound.m_128359_("SignAddress", this.signBasedAddress);
        compound.m_128359_("ComputerAddress", this.customComputerAddress);
        compound.m_128379_("HasComputerAddress", this.hasCustomComputerAddress.booleanValue());
        compound.m_128365_("HeldBox", (Tag)this.heldBox.serializeNBT());
        compound.m_128365_("InsertedBox", (Tag)this.previouslyUnwrapped.serializeNBT());
        if (clientPacket) {
            return;
        }
        compound.m_128365_("QueuedExitingPackages", (Tag)NBTHelper.writeCompoundList(this.queuedExitingPackages, BigItemStack::write));
        if (this.availableItems != null) {
            compound.m_128365_("LastSummary", (Tag)this.availableItems.write());
        }
    }

    public void invalidate() {
        super.invalidate();
        this.invProvider.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inventory);
        this.queuedExitingPackages.forEach(bigStack -> {
            for (int i = 0; i < bigStack.count; ++i) {
                Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)bigStack.stack.m_41777_());
            }
        });
        this.queuedExitingPackages.clear();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.invProvider.cast();
        }
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public float getTrayOffset(float partialTicks) {
        float tickCycle = this.animationInward ? (float)this.animationTicks - partialTicks : (float)(this.animationTicks - 5) - partialTicks;
        float progress = Mth.m_14036_((float)(tickCycle / 15.0f * 2.0f - 1.0f), (float)-1.0f, (float)1.0f);
        progress = 1.0f - progress * progress;
        return progress * progress;
    }

    public ItemStack getRenderedBox() {
        if (this.animationInward) {
            return this.animationTicks <= 10 ? ItemStack.f_41583_ : this.previouslyUnwrapped;
        }
        return this.animationTicks >= 10 ? ItemStack.f_41583_ : this.heldBox;
    }

    public boolean isTargetingSameInventory(@Nullable IdentifiedInventory inventory) {
        if (inventory == null) {
            return false;
        }
        IItemHandler targetHandler = (IItemHandler)this.targetInventory.getInventory();
        if (targetHandler == null) {
            return false;
        }
        if (inventory.identifier() != null) {
            BlockFace face = this.targetInventory.getTarget().getOpposite();
            return inventory.identifier().contains(face);
        }
        return PackagerBlockEntity.isSameInventoryFallback(targetHandler, inventory.handler());
    }

    private static boolean isSameInventoryFallback(IItemHandler first, IItemHandler second) {
        if (first == second) {
            return true;
        }
        for (int i = 0; i < second.getSlots(); ++i) {
            ItemStack stackInSlot = second.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            for (int j = 0; j < first.getSlots(); ++j) {
                if (stackInSlot != first.getStackInSlot(j)) continue;
                return true;
            }
            break;
        }
        return false;
    }
}

