/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.packager;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import moe.paring.createlogisticsbackport.content.logistics.packager.PackagerBlock;
import moe.paring.createlogisticsbackport.content.logistics.packager.PackagerBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packager.PackagerRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PackagerVisual<T extends PackagerBlockEntity>
extends BlockEntityInstance<T>
implements DynamicInstance {
    public final ModelData hatch;
    public final ModelData tray;
    public float lastTrayOffset = Float.NaN;
    public PartialModel lastHatchPartial;

    public PackagerVisual(MaterialManager materialManager, T blockEntity) {
        super(materialManager, blockEntity);
        this.lastHatchPartial = PackagerRenderer.getHatchModel(blockEntity);
        this.hatch = (ModelData)materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(this.lastHatchPartial).createInstance();
        this.tray = (ModelData)materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(PackagerRenderer.getTrayModel(blockEntity.m_58900_())).createInstance();
        Direction facing = ((Direction)this.blockState.m_61143_((Property)PackagerBlock.f_52588_)).m_122424_();
        Vec3 lowerCorner = Vec3.m_82528_((Vec3i)facing.m_122436_());
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.hatch.loadIdentity().translate((Vec3i)this.getInstancePosition())).translate(lowerCorner.m_82490_((double)0.49999f))).centre()).rotateY((double)AngleHelper.horizontalAngle((Direction)facing))).rotateX((double)AngleHelper.verticalAngle((Direction)facing))).unCentre()).markDirty();
        this.animate();
    }

    public void beginFrame() {
        this.animate();
    }

    public void animate() {
        float trayOffset;
        float partialTick = AnimationTickHolder.getPartialTicks();
        PartialModel hatchPartial = PackagerRenderer.getHatchModel((PackagerBlockEntity)this.blockEntity);
        if (hatchPartial != this.lastHatchPartial) {
            this.materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(hatchPartial).stealInstance((InstanceData)this.hatch);
            this.lastHatchPartial = hatchPartial;
        }
        if ((trayOffset = ((PackagerBlockEntity)this.blockEntity).getTrayOffset(partialTick)) != this.lastTrayOffset) {
            Direction facing = ((Direction)this.blockState.m_61143_((Property)PackagerBlock.f_52588_)).m_122424_();
            Vec3 lowerCorner = Vec3.m_82528_((Vec3i)facing.m_122436_());
            ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.tray.loadIdentity().translate((Vec3i)this.getInstancePosition())).translate(lowerCorner.m_82490_((double)trayOffset))).centre()).rotateY((double)facing.m_122435_())).unCentre()).markDirty();
            this.lastTrayOffset = trayOffset;
        }
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.hatch, this.tray});
    }

    protected void remove() {
        this.hatch.delete();
        this.tray.delete();
    }
}

