/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.packagerLink;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.Iterate;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.PackagerLinkBlockEntity;
import moe.paring.createlogisticsbackport.registry.ExtraBlockEntityTypes;
import moe.paring.createlogisticsbackport.registry.ExtraShapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PackagerLinkBlock
extends FaceAttachedHorizontalDirectionalBlock
implements IBE<PackagerLinkBlockEntity>,
ProperWaterloggedBlock,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public PackagerLinkBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        BlockState placed = super.m_5573_(context);
        if (placed == null) {
            return null;
        }
        if (placed.m_61143_((Property)f_53179_) == AttachFace.CEILING) {
            placed = (BlockState)placed.m_61124_((Property)f_54117_, (Comparable)((Direction)placed.m_61143_((Property)f_54117_)).m_122424_());
        }
        return this.withWater((BlockState)placed.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(PackagerLinkBlock.getPower(placed, context.m_43725_(), pos) > 0)), context);
    }

    public static Direction m_53200_(BlockState state) {
        return FaceAttachedHorizontalDirectionalBlock.m_53200_((BlockState)state);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return true;
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pPos);
        return pState;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        int power = PackagerLinkBlock.getPower(state, worldIn, pos);
        boolean powered = power > 0;
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != powered) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, link -> link.behaviour.redstonePowerChanged(power));
    }

    public static int getPower(BlockState state, Level worldIn, BlockPos pos) {
        int power = 0;
        for (Direction d : Iterate.directions) {
            if (d.m_122424_() == PackagerLinkBlock.m_53200_(state)) continue;
            power = Math.max(power, worldIn.m_277185_(pos.m_121945_(d), d));
        }
        return power;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, plbe -> {
            if (pPlacer instanceof Player) {
                Player player = (Player)pPlacer;
                plbe.placedBy = player.m_20148_();
                plbe.notifyUpdate();
            }
        });
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return ExtraShapes.STOCK_LINK.get(PackagerLinkBlock.m_53200_(pState));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{POWERED, WATERLOGGED, f_53179_, f_54117_}));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public Class<PackagerLinkBlockEntity> getBlockEntityClass() {
        return PackagerLinkBlockEntity.class;
    }

    public BlockEntityType<? extends PackagerLinkBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ExtraBlockEntityTypes.PACKAGER_LINK.get();
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        IBE.onRemove((BlockState)pState, (Level)pLevel, (BlockPos)pPos, (BlockState)pNewState);
    }
}

