/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.packagerLink;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import moe.paring.createlogisticsbackport.content.logistics.packager.IdentifiedInventory;
import moe.paring.createlogisticsbackport.content.logistics.packager.InventorySummary;
import moe.paring.createlogisticsbackport.content.logistics.packager.PackagerBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packager.PackagingRequest;
import moe.paring.createlogisticsbackport.content.logistics.packager.repackager.RepackagerBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.PackagerLinkBlock;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.WiFiParticle;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.PackageOrderWithCrafts;
import moe.paring.createlogisticsbackport.content.redstone.displayLink.LinkWithBulbBlockEntity;
import moe.paring.createlogisticsbackport.registry.ExtraSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PackagerLinkBlockEntity
extends LinkWithBulbBlockEntity {
    public LogisticallyLinkedBehaviour behaviour;
    public UUID placedBy;
    private static final Map<BlockState, Vec3> bulbOffsets = new HashMap<BlockState, Vec3>();

    public PackagerLinkBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.placedBy = null;
    }

    public InventorySummary fetchSummaryFromPackager(@Nullable IdentifiedInventory ignoredHandler) {
        PackagerBlockEntity packager = this.getPackager();
        if (packager == null) {
            return InventorySummary.EMPTY;
        }
        if (packager.isTargetingSameInventory(ignoredHandler)) {
            return InventorySummary.EMPTY;
        }
        return packager.getAvailableItems();
    }

    public void playEffect() {
        ExtraSoundEvents.STOCK_LINK.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.75f, 1.25f, false);
        Vec3 vec3 = Vec3.m_82512_((Vec3i)this.f_58858_);
        BlockState state = this.m_58900_();
        float f = 1.0f;
        AttachFace face = state.m_61145_((Property)PackagerLinkBlock.f_53179_).orElse(AttachFace.FLOOR);
        if (face != AttachFace.FLOOR) {
            f = -1.0f;
        }
        if (face == AttachFace.WALL) {
            vec3 = vec3.m_82520_(0.0, 0.25, 0.0);
        }
        vec3 = vec3.m_82549_(Vec3.m_82528_((Vec3i)state.m_61145_((Property)PackagerLinkBlock.f_54117_).orElse(Direction.SOUTH).m_122436_()).m_82490_((double)f * 0.125));
        this.pulse();
        this.f_58857_.m_7106_((ParticleOptions)new WiFiParticle.Data(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0, face == AttachFace.CEILING ? -1.0 : 1.0, 1.0);
    }

    public Pair<PackagerBlockEntity, PackagingRequest> processRequest(ItemStack stack, int amount, String address, int linkIndex, MutableBoolean finalLink, int orderId, @Nullable PackageOrderWithCrafts context, @Nullable IdentifiedInventory ignoredHandler) {
        PackagerBlockEntity packager = this.getPackager();
        if (packager == null) {
            return null;
        }
        if (packager.isTargetingSameInventory(ignoredHandler)) {
            return null;
        }
        InventorySummary summary = packager.getAvailableItems();
        int availableCount = summary.getCountOf(stack);
        if (availableCount == 0) {
            return null;
        }
        int toWithdraw = Math.min(amount, availableCount);
        return Pair.of((Object)((Object)packager), (Object)PackagingRequest.create(stack, toWithdraw, address, linkIndex, finalLink, 0, orderId, context));
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.placedBy != null) {
            tag.m_128362_("PlacedBy", this.placedBy);
        }
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.placedBy = tag.m_128441_("PlacedBy") ? tag.m_128342_("PlacedBy") : null;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.behaviour = new LogisticallyLinkedBehaviour(this, true);
        behaviours.add(this.behaviour);
    }

    public void initialize() {
        super.initialize();
        this.behaviour.redstonePowerChanged(PackagerLinkBlock.getPower(this.m_58900_(), this.f_58857_, this.f_58858_));
        PackagerBlockEntity packager = this.getPackager();
        if (packager != null) {
            packager.recheckIfLinksPresent();
        }
    }

    @Nullable
    public PackagerBlockEntity getPackager() {
        BlockState blockState = this.m_58900_();
        if (this.behaviour.redstonePower == 15) {
            return null;
        }
        BlockPos source = this.f_58858_.m_121945_(PackagerLinkBlock.m_53200_(blockState).m_122424_());
        BlockEntity blockEntity = this.f_58857_.m_7702_(source);
        if (!(blockEntity instanceof PackagerBlockEntity)) {
            return null;
        }
        PackagerBlockEntity packager = (PackagerBlockEntity)blockEntity;
        if (packager instanceof RepackagerBlockEntity) {
            return null;
        }
        return packager;
    }

    @Override
    public Direction getBulbFacing(BlockState state) {
        return PackagerLinkBlock.m_53200_(state);
    }

    @Override
    public Vec3 getBulbOffset(BlockState state) {
        return bulbOffsets.computeIfAbsent(state, s -> {
            Vec3 offset = VecHelper.voxelSpace((double)5.0, (double)6.0, (double)11.0);
            Vec3 wallOffset = VecHelper.voxelSpace((double)11.0, (double)6.0, (double)5.0);
            AttachFace face = (AttachFace)s.m_61143_((Property)PackagerLinkBlock.f_53179_);
            Vec3 vec = face == AttachFace.WALL ? wallOffset : offset;
            float angle = AngleHelper.horizontalAngle((Direction)((Direction)s.m_61143_((Property)PackagerLinkBlock.f_54117_)));
            if (face == AttachFace.CEILING) {
                angle = -angle;
            }
            if (face == AttachFace.WALL) {
                angle = 0.0f;
            }
            return VecHelper.rotateCentered((Vec3)vec, (double)angle, (Direction.Axis)Direction.Axis.Y);
        });
    }
}

