/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.packagerLink;

import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import moe.paring.createlogisticsbackport.content.logistics.BigItemStack;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.RequestPromise;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class RequestPromiseQueue {
    private Map<Item, List<RequestPromise>> promisesByItem = new IdentityHashMap<Item, List<RequestPromise>>();
    private Runnable onChanged;

    public RequestPromiseQueue(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    public void add(RequestPromise promise) {
        this.promisesByItem.computeIfAbsent(promise.promisedStack.stack.m_41720_(), $ -> new LinkedList()).add(promise);
        this.onChanged.run();
    }

    public void setOnChanged(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    public int getTotalPromisedAndRemoveExpired(ItemStack stack, int expiryTime) {
        int promised = 0;
        List<RequestPromise> list = this.promisesByItem.get(stack.m_41720_());
        if (list == null) {
            return promised;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = iterator.next();
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)promise.promisedStack.stack, (ItemStack)stack)) continue;
            if (expiryTime != -1 && promise.ticksExisted >= expiryTime) {
                iterator.remove();
                this.onChanged.run();
                continue;
            }
            promised += promise.promisedStack.count;
        }
        return promised;
    }

    public void forceClear(ItemStack stack) {
        List<RequestPromise> list = this.promisesByItem.get(stack.m_41720_());
        if (list == null) {
            return;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = iterator.next();
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)promise.promisedStack.stack, (ItemStack)stack)) continue;
            iterator.remove();
            this.onChanged.run();
        }
        if (list.isEmpty()) {
            this.promisesByItem.remove(stack.m_41720_());
        }
    }

    public void itemEnteredSystem(ItemStack stack, int amount) {
        List<RequestPromise> list = this.promisesByItem.get(stack.m_41720_());
        if (list == null) {
            return;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise requestPromise = iterator.next();
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)requestPromise.promisedStack.stack, (ItemStack)stack)) continue;
            int toSubtract = Math.min(amount, requestPromise.promisedStack.count);
            amount -= toSubtract;
            requestPromise.promisedStack.count -= toSubtract;
            if (requestPromise.promisedStack.count <= 0) {
                iterator.remove();
                this.onChanged.run();
            }
            if (amount > 0) continue;
            break;
        }
        if (list.isEmpty()) {
            this.promisesByItem.remove(stack.m_41720_());
        }
    }

    public List<RequestPromise> flatten(boolean sorted) {
        ArrayList<RequestPromise> all = new ArrayList<RequestPromise>();
        this.promisesByItem.forEach((key, list) -> all.addAll((Collection<RequestPromise>)list));
        if (sorted) {
            Collections.sort(all, RequestPromise.ageComparator());
        }
        return all;
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("List", (Tag)NBTHelper.writeCompoundList(this.flatten(false), rp -> {
            CompoundTag c = rp.promisedStack.write();
            c.m_128405_("Age", rp.ticksExisted);
            return c;
        }));
        return tag;
    }

    public static RequestPromiseQueue read(CompoundTag tag, Runnable onChanged) {
        RequestPromiseQueue queue = new RequestPromiseQueue(onChanged);
        NBTHelper.iterateCompoundList((ListTag)tag.m_128437_("List", 10), c -> {
            RequestPromise promise = new RequestPromise(BigItemStack.read(c));
            promise.ticksExisted = c.m_128451_("Age");
            queue.add(promise);
        });
        return queue;
    }

    public void tick() {
        this.promisesByItem.forEach((key, list) -> list.forEach(RequestPromise::tick));
    }

    public boolean isEmpty() {
        return this.promisesByItem.isEmpty();
    }
}

