/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.redstoneRequester;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import moe.paring.createlogisticsbackport.content.logistics.BigItemStack;
import moe.paring.createlogisticsbackport.content.logistics.redstoneRequester.AutoRequestData;
import moe.paring.createlogisticsbackport.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.PackageOrder;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.PackageOrderWithCrafts;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.StockTickerBlockEntity;
import moe.paring.createlogisticsbackport.registry.ExtraBlockEntityTypes;
import moe.paring.createlogisticsbackport.registry.ExtraBlocks;
import moe.paring.createlogisticsbackport.registry.ExtraItemTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;

public class RedstoneRequesterBlock
extends Block
implements IBE<RedstoneRequesterBlockEntity>,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;

    public RedstoneRequesterBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{POWERED, AXIS}));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.m_5573_(pContext);
        if (stateForPlacement == null) {
            return null;
        }
        return (BlockState)((BlockState)stateForPlacement.m_61124_(AXIS, (Comparable)pContext.m_8125_().m_122434_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_276867_(pContext.m_8083_())));
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        RedstoneRequesterBlockEntity req = (RedstoneRequesterBlockEntity)this.getBlockEntity((BlockGetter)pLevel, pPos);
        return req != null && req.lastRequestSucceeded ? 15 : 0;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        return this.onBlockEntityUse((BlockGetter)pLevel, pPos, be -> be.use(pPlayer));
    }

    public static void programRequester(ServerPlayer player, StockTickerBlockEntity be, PackageOrderWithCrafts order, String address) {
        ItemStack stack = player.m_21205_();
        boolean isRequester = ExtraBlocks.REDSTONE_REQUESTER.isIn(stack);
        boolean isShopCloth = ExtraItemTags.TABLE_CLOTHS.matches(stack);
        if (!isRequester && !isShopCloth) {
            return;
        }
        AutoRequestData autoRequestData = new AutoRequestData();
        autoRequestData.encodedRequest = order;
        autoRequestData.encodedTargetAdress = address;
        autoRequestData.targetOffset = be.m_58899_();
        autoRequestData.targetDim = player.m_9236_().m_46472_().m_135782_().toString();
        autoRequestData.writeToItem(BlockPos.f_121853_, stack);
        if (isRequester) {
            CompoundTag stackTag = stack.m_41783_();
            CompoundTag beTag = stackTag.m_128469_("BlockEntityTag");
            beTag.m_128362_("Freq", be.behaviour.freqId);
            stackTag.m_128365_("BlockEntityTag", (Tag)beTag);
        }
        player.m_21008_(InteractionHand.MAIN_HAND, stack);
    }

    public static void appendRequesterTooltip(ItemStack pStack, List<Component> pTooltip) {
        if (!pStack.m_41782_()) {
            return;
        }
        CompoundTag compoundnbt = pStack.m_41783_();
        if (!compoundnbt.m_128425_("EncodedRequest", 10)) {
            return;
        }
        PackageOrder contents = PackageOrder.read(compoundnbt.m_128469_("EncodedRequest"));
        for (BigItemStack entry : contents.stacks()) {
            pTooltip.add((Component)entry.stack.m_41786_().m_6881_().m_130946_(" x").m_130946_(String.valueOf(entry.count)).m_130940_(ChatFormatting.GRAY));
        }
        Lang.translate((String)"logistically_linked.tooltip_clear", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).addTo(pTooltip);
    }

    public void m_6402_(Level pLevel, BlockPos requesterPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        Player player = pPlacer instanceof Player ? (Player)pPlacer : null;
        this.withBlockEntityDo((BlockGetter)pLevel, requesterPos, rrbe -> {
            AutoRequestData data = AutoRequestData.readFromItem(pLevel, player, requesterPos, pStack);
            if (data == null) {
                return;
            }
            rrbe.encodedRequest = data.encodedRequest;
            rrbe.encodedTargetAdress = data.encodedTargetAdress;
        });
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (pLevel.m_5776_()) {
            return;
        }
        pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(pLevel.m_276867_(pPos))));
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, RedstoneRequesterBlockEntity::onRedstonePowerChanged);
    }

    public Class<RedstoneRequesterBlockEntity> getBlockEntityClass() {
        return RedstoneRequesterBlockEntity.class;
    }

    public BlockEntityType<? extends RedstoneRequesterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ExtraBlockEntityTypes.REDSTONE_REQUESTER.get();
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_(AXIS, (Comparable)pRotation.m_55954_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)pState.m_61143_(AXIS)))).m_122434_());
    }
}

