/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.stockTicker;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import javax.annotation.Nullable;
import moe.paring.createlogisticsbackport.content.logistics.packager.IdentifiedInventory;
import moe.paring.createlogisticsbackport.content.logistics.packager.InventorySummary;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.LogisticsManager;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.PackageOrder;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.PackageOrderWithCrafts;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class StockCheckingBlockEntity
extends SmartBlockEntity {
    public LogisticallyLinkedBehaviour behaviour;

    public StockCheckingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.behaviour = new LogisticallyLinkedBehaviour(this, false);
        behaviours.add(this.behaviour);
    }

    public InventorySummary getRecentSummary() {
        return LogisticsManager.getSummaryOfNetwork(this.behaviour.freqId, false);
    }

    public InventorySummary getAccurateSummary() {
        return LogisticsManager.getSummaryOfNetwork(this.behaviour.freqId, true);
    }

    public boolean broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType type, PackageOrder order, @Nullable IdentifiedInventory ignoredHandler, String address) {
        return this.broadcastPackageRequest(type, PackageOrderWithCrafts.simple(order.stacks()), ignoredHandler, address);
    }

    public boolean broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType type, PackageOrderWithCrafts order, @Nullable IdentifiedInventory ignoredHandler, String address) {
        return LogisticsManager.broadcastPackageRequest(this.behaviour.freqId, type, order, ignoredHandler, address);
    }
}

