/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.logistics.tableCloth;

import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.foundation.utility.Lang;
import moe.paring.createlogisticsbackport.content.logistics.tableCloth.ShoppingListItem;
import moe.paring.createlogisticsbackport.content.logistics.tableCloth.TableClothBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.tableCloth.TableClothFilterSlot;
import moe.paring.createlogisticsbackport.polyfill.behaviour.ValueSettingsBehaviour2;
import moe.paring.createlogisticsbackport.polyfill.behaviour.ValueSettingsBoard2;
import moe.paring.createlogisticsbackport.polyfill.behaviour.ValueSettingsFormatter2;
import moe.paring.createlogisticsbackport.polyfill.behaviour.filtering.FilteringBehaviour2;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;

public class TableClothFilteringBehaviour
extends FilteringBehaviour2 {
    public TableClothFilteringBehaviour(TableClothBlockEntity be) {
        super(be, new TableClothFilterSlot(be));
        this.withPredicate(is -> !(is.m_41720_() instanceof FilterItem) && !(is.m_41720_() instanceof ShoppingListItem));
        this.count = 1;
    }

    @Override
    public void onShortInteract(Player player, InteractionHand hand, Direction side, BlockHitResult hitResult) {
        super.onShortInteract(player, hand, side, hitResult);
    }

    @Override
    public float getRenderDistance() {
        return 32.0f;
    }

    private TableClothBlockEntity dbe() {
        return (TableClothBlockEntity)this.blockEntity;
    }

    @Override
    public boolean mayInteract(Player player) {
        return this.dbe().owner == null || player.m_20148_().equals(this.dbe().owner);
    }

    @Override
    public boolean isSafeNBT() {
        return false;
    }

    @Override
    public MutableComponent getLabel() {
        return Lang.translateDirect((String)"table_cloth.price_per_order", (Object[])new Object[0]);
    }

    @Override
    public boolean isCountVisible() {
        return !this.filter.isEmpty();
    }

    @Override
    public boolean setFilter(ItemStack stack) {
        int before = this.count;
        boolean result = super.setFilter(stack);
        this.count = before;
        return result;
    }

    @Override
    public void setValueSettings(Player player, ValueSettingsBehaviour2.ValueSettings2 settings, boolean ctrlDown) {
        if (this.getValueSettings().equals(settings)) {
            return;
        }
        this.count = Math.max(1, settings.value());
        this.blockEntity.m_6596_();
        this.blockEntity.sendData();
        this.playFeedbackSound(this);
    }

    @Override
    public ValueSettingsBoard2 createBoard(Player player, BlockHitResult hitResult) {
        return new ValueSettingsBoard2((Component)this.getLabel(), 100, 10, Lang.translatedOptions((String)"table_cloth", (String[])new String[]{"amount"}), new ValueSettingsFormatter2(this::formatValue));
    }

    @Override
    public MutableComponent formatValue(ValueSettingsBehaviour2.ValueSettings2 value) {
        return Component.m_237113_((String)String.valueOf(Math.max(1, value.value())));
    }

    @Override
    public MutableComponent getCountLabelForValueBox() {
        return Component.m_237113_((String)(this.isCountVisible() ? String.valueOf(this.count) : ""));
    }

    @Override
    public boolean isActive() {
        return this.dbe().isShop();
    }
}

