/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.redstone.displayLink;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public abstract class LinkWithBulbBlockEntity
extends SmartBlockEntity {
    private LerpedFloat glow = LerpedFloat.linear().startWithValue(0.0);
    private boolean sendPulse;

    public LinkWithBulbBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.glow.chase(0.0, 0.5, LerpedFloat.Chaser.EXP);
    }

    public void tick() {
        super.tick();
        if (this.isVirtual() || this.f_58857_.m_5776_()) {
            this.glow.tickChaser();
        }
    }

    public float getGlow(float partialTicks) {
        return this.glow.getValue(partialTicks);
    }

    public void sendPulseNextSync() {
        this.sendPulse = true;
    }

    public void pulse() {
        this.glow.setValue(2.0);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (clientPacket && this.sendPulse) {
            this.sendPulse = false;
            NBTHelper.putMarker((CompoundTag)tag, (String)"Pulse");
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (clientPacket && tag.m_128441_("Pulse")) {
            this.pulse();
        }
    }

    public Vec3 getBulbOffset(BlockState state) {
        return Vec3.f_82478_;
    }

    public Direction getBulbFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)DisplayLinkBlock.f_52588_);
    }
}

