/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.trains.schedule.destination;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import moe.paring.createlogisticsbackport.accessor.GlobalStationMixinAccessor;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageItem;
import moe.paring.createlogisticsbackport.content.trains.schedule.destination.IHaveScheduleInstructionRunner;
import moe.paring.createlogisticsbackport.mixin.ScheduleRuntimeAccessor;
import moe.paring.createlogisticsbackport.polyfill.trains.GlobalPackagePort;
import moe.paring.createlogisticsbackport.registry.ExtraBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class DeliverPackagesInstruction
extends ScheduleInstruction
implements IHaveScheduleInstructionRunner {
    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)this.getSecondLineIcon(), (Object)Lang.translateDirect((String)"schedule.instruction.package_delivery", (Object[])new Object[0]));
    }

    public ItemStack getSecondLineIcon() {
        return ExtraBlocks.PACKAGE_POSTBOXES.get(DyeColor.WHITE).asStack();
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translate((String)"schedule.instruction.package_delivery.summary", (Object[])new Object[0]).style(ChatFormatting.GOLD).component(), (Object)Lang.translateDirect((String)"schedule.instruction.package_delivery.summary_1", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY), (Object)Lang.translateDirect((String)"schedule.instruction.package_delivery.summary_2", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY));
    }

    public ResourceLocation getId() {
        return Create.asResource((String)"package_delivery");
    }

    public boolean supportsConditions() {
        return true;
    }

    @Override
    @Nullable
    public DiscoveredPath start(ScheduleRuntime runtime) {
        boolean anyMatch = false;
        String firstPackage = null;
        ArrayList<GlobalStation> validStations = new ArrayList<GlobalStation>();
        Train train = ((ScheduleRuntimeAccessor)runtime).getTrain();
        if (!train.hasForwardConductor() && !train.hasBackwardConductor()) {
            train.status.missingConductor();
            this.startCooldown(runtime);
            return null;
        }
        for (Carriage carriage : train.carriages) {
            IItemHandlerModifiable carriageInventory = carriage.storage.getItems();
            if (carriageInventory == null) continue;
            for (int slot = 0; slot < carriageInventory.getSlots(); ++slot) {
                ItemStack stack = carriageInventory.getStackInSlot(slot);
                if (!PackageItem.isPackage(stack)) continue;
                if (firstPackage == null) {
                    firstPackage = PackageItem.getAddress(stack);
                }
                block2: for (GlobalStation globalStation : train.graph.getPoints(EdgePointType.STATION)) {
                    for (Map.Entry<BlockPos, GlobalPackagePort> port : ((GlobalStationMixinAccessor)globalStation).create_logistics_backport$getConnectedPorts().entrySet()) {
                        if (!PackageItem.matchAddress(stack, port.getValue().address)) continue;
                        anyMatch = true;
                        validStations.add(globalStation);
                        continue block2;
                    }
                }
            }
        }
        if (validStations.isEmpty()) {
            if (firstPackage != null) {
                train.status.displayInformation("no_package_target", false, new Object[]{firstPackage});
                this.startCooldown(runtime);
            } else {
                runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
                ++runtime.currentEntry;
            }
            return null;
        }
        DiscoveredPath best = train.navigation.findPathTo(validStations, Double.MAX_VALUE);
        if (best == null) {
            if (anyMatch) {
                train.status.failedNavigation();
            }
            this.startCooldown(runtime);
            return null;
        }
        return best;
    }
}

