/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.content.trains.schedule.destination;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.TextScheduleInstruction;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import moe.paring.createlogisticsbackport.accessor.GlobalStationMixinAccessor;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageItem;
import moe.paring.createlogisticsbackport.content.logistics.box.PackageStyles;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.postbox.PostboxBlockEntity;
import moe.paring.createlogisticsbackport.content.trains.schedule.destination.IHaveScheduleInstructionRunner;
import moe.paring.createlogisticsbackport.mixin.ScheduleRuntimeAccessor;
import moe.paring.createlogisticsbackport.polyfill.trains.GlobalPackagePort;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class FetchPackagesInstruction
extends TextScheduleInstruction
implements IHaveScheduleInstructionRunner {
    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)this.getSecondLineIcon(), (Object)Lang.translateDirect((String)"schedule.instruction.package_retrieval", (Object[])new Object[0]));
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translate((String)"schedule.instruction.package_retrieval.summary", (Object[])new Object[0]).style(ChatFormatting.GOLD).component(), (Object)Lang.translateDirect((String)"generic.in_quotes", (Object[])new Object[]{Components.literal((String)this.getLabelText())}), (Object)Lang.translateDirect((String)"schedule.instruction.package_retrieval.summary_1", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY), (Object)Lang.translateDirect((String)"schedule.instruction.package_retrieval.summary_2", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY));
    }

    public ItemStack getSecondLineIcon() {
        return PackageStyles.getDefaultBox();
    }

    public String getFilter() {
        return this.getLabelText();
    }

    public String getFilterForRegex() {
        String filter = this.getFilter();
        if (filter.isBlank()) {
            return filter;
        }
        return "\\Q" + filter.replace("*", "\\E.*\\Q") + "\\E";
    }

    public List<Component> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)Lang.translateDirect((String)"schedule.instruction.address_filter_edit_box", (Object[])new Object[0]), (Object)Lang.translateDirect((String)"schedule.instruction.address_filter_edit_box_1", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY), (Object)Lang.translateDirect((String)"schedule.instruction.address_filter_edit_box_2", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_GRAY), (Object)Lang.translateDirect((String)"schedule.instruction.address_filter_edit_box_3", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void modifyEditBox(EditBox box) {
        box.m_94153_(s -> StringUtils.countMatches((CharSequence)s, (char)'*') <= 3);
    }

    public ResourceLocation getId() {
        return Create.asResource((String)"package_retrieval");
    }

    public boolean supportsConditions() {
        return false;
    }

    @Override
    public DiscoveredPath start(ScheduleRuntime runtime) {
        String regex = this.getFilterForRegex();
        boolean anyMatch = false;
        ArrayList<GlobalStation> validStations = new ArrayList<GlobalStation>();
        Train train = ((ScheduleRuntimeAccessor)runtime).getTrain();
        if (!train.hasForwardConductor() && !train.hasBackwardConductor()) {
            train.status.missingConductor();
            this.startCooldown(runtime);
            return null;
        }
        ServerLevel level = null;
        for (Carriage carriage : train.carriages) {
            ServerLevel sl;
            Level level2;
            CarriageContraptionEntity entity;
            if (level != null || (entity = carriage.anyAvailableEntity()) == null || !((level2 = entity.m_9236_()) instanceof ServerLevel)) continue;
            level = sl = (ServerLevel)level2;
        }
        for (GlobalStation globalStation : train.graph.getPoints(EdgePointType.STATION)) {
            for (Map.Entry<BlockPos, GlobalPackagePort> entry : ((GlobalStationMixinAccessor)globalStation).create_logistics_backport$getConnectedPorts().entrySet()) {
                BlockEntity blockEntity;
                GlobalPackagePort port = entry.getValue();
                BlockPos pos = entry.getKey();
                Object postboxInventory = port.offlineBuffer;
                if (level != null && level.m_46749_(pos) && (blockEntity = level.m_7702_(pos)) instanceof PostboxBlockEntity) {
                    PostboxBlockEntity ppbe = (PostboxBlockEntity)blockEntity;
                    postboxInventory = ppbe.inventory;
                }
                for (int slot = 0; slot < postboxInventory.getSlots(); ++slot) {
                    ItemStack stack = postboxInventory.getStackInSlot(slot);
                    if (!PackageItem.isPackage(stack) || PackageItem.matchAddress(stack, port.address)) continue;
                    try {
                        if (!PackageItem.getAddress(stack).matches(regex)) continue;
                        anyMatch = true;
                        validStations.add(globalStation);
                        continue;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
        if (validStations.isEmpty()) {
            this.startCooldown(runtime);
            runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
            ++runtime.currentEntry;
            return null;
        }
        DiscoveredPath best = train.navigation.findPathTo(validStations, Double.MAX_VALUE);
        if (best == null) {
            if (anyMatch) {
                train.status.failedNavigation();
            }
            this.startCooldown(runtime);
            return null;
        }
        return best;
    }
}

